/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui;

import java.io.IOException;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;

@Component(role=Prompter.class, hint="archetype")
public class ArchetypePrompter
implements Prompter {
    @Requirement
    private OutputHandler outputHandler;
    @Requirement
    private InputHandler inputHandler;

    public String prompt(String message) throws PrompterException {
        this.writePrompt(message);
        return this.readLine();
    }

    public String prompt(String message, String defaultReply) throws PrompterException {
        this.writePrompt(this.formatMessage(message, null, defaultReply));
        String line = this.readLine();
        if (StringUtils.isEmpty((String)line)) {
            line = defaultReply;
        }
        return line;
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws PrompterException {
        String line;
        String formattedMessage = this.formatMessage(message, possibleValues, defaultReply);
        do {
            this.writePrompt(formattedMessage);
            line = this.readLine();
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            if (line == null || possibleValues.contains(line)) continue;
            try {
                this.outputHandler.writeLine("Invalid selection.");
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present feedback", (Throwable)e);
            }
        } while (line == null || !possibleValues.contains(line));
        return line;
    }

    public String prompt(String message, List possibleValues) throws PrompterException {
        return this.prompt(message, possibleValues, null);
    }

    public String promptForPassword(String message) throws PrompterException {
        this.writePrompt(message);
        try {
            return this.inputHandler.readPassword();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", (Throwable)e);
        }
    }

    private String formatMessage(String message, List<String> possibleValues, String defaultReply) {
        StringBuilder formatted = new StringBuilder(message.length() * 2);
        formatted.append(message);
        if (defaultReply != null) {
            formatted.append(defaultReply);
        }
        return formatted.toString();
    }

    private void writePrompt(String message) throws PrompterException {
        this.showMessage(message + ": ");
    }

    private String readLine() throws PrompterException {
        try {
            return this.inputHandler.readLine();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", (Throwable)e);
        }
    }

    public void showMessage(String message) throws PrompterException {
        try {
            this.outputHandler.write(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to show message", (Throwable)e);
        }
    }
}

