/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.namesrv;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;

public class GetNamesrvConfigCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "getNamesrvConfig";
    }

    @Override
    public String commandDesc() {
        return "Get configs of name server.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String[] serverArray;
            String servers = commandLine.getOptionValue('n');
            List<String> serverList = null;
            if (servers != null && servers.length() > 0 && (serverArray = servers.trim().split(";")).length > 0) {
                serverList = Arrays.asList(serverArray);
            }
            defaultMQAdminExt.start();
            Map<String, Properties> nameServerConfigs = defaultMQAdminExt.getNameServerConfig(serverList);
            for (String server : nameServerConfigs.keySet()) {
                System.out.printf("============%s============\n", server);
                for (Object key : nameServerConfigs.get(server).keySet()) {
                    System.out.printf("%-50s=  %s\n", key, nameServerConfigs.get(server).get(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

