/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.utility;

import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.shardingsphere.distsql.parser.core.utility.UtilityDistSQLLexer;
import org.apache.shardingsphere.distsql.parser.core.utility.UtilityDistSQLParser;
import org.apache.shardingsphere.distsql.parser.core.utility.UtilityDistSQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class UtilityDistSQLStatementParserEngine {
    public SQLStatement parse(String sql) {
        ASTNode astNode = this.parseToASTNode(sql);
        return this.getSQLStatement(sql, (ParseASTNode)astNode);
    }

    private ASTNode parseToASTNode(String sql) {
        try {
            return SQLParserFactory.newInstance((String)sql, UtilityDistSQLLexer.class, UtilityDistSQLParser.class).parse();
        }
        catch (ParseCancellationException | SQLParsingException ignored) {
            throw new SQLParsingException(sql);
        }
    }

    private SQLStatement getSQLStatement(String sql, ParseASTNode parseASTNode) {
        if (parseASTNode.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException(sql);
        }
        return (SQLStatement)new UtilityDistSQLStatementVisitor().visit(parseASTNode.getRootNode());
    }
}

