/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm.encrypt;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.exception.algorithm.EncryptAlgorithmInitializationException;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public final class AESEncryptAlgorithm
implements StandardEncryptAlgorithm<Object, String> {
    private static final String AES_KEY = "aes-key-value";
    private byte[] secretKey;

    public void init(Properties props) {
        this.secretKey = this.createSecretKey(props);
    }

    private byte[] createSecretKey(Properties props) {
        ShardingSpherePreconditions.checkState((boolean)props.containsKey(AES_KEY), () -> new EncryptAlgorithmInitializationException("AES", String.format("%s can not be null", AES_KEY)));
        return Arrays.copyOf(DigestUtils.sha1((String)props.getProperty(AES_KEY)), 16);
    }

    public String encrypt(Object plainValue, EncryptContext encryptContext) {
        if (null == plainValue) {
            return null;
        }
        byte[] result = this.getCipher(1).doFinal(String.valueOf(plainValue).getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(result);
    }

    public Object decrypt(String cipherValue, EncryptContext encryptContext) {
        if (null == cipherValue) {
            return null;
        }
        byte[] result = this.getCipher(2).doFinal(Base64.getDecoder().decode(cipherValue.trim()));
        return new String(result, StandardCharsets.UTF_8);
    }

    private Cipher getCipher(int decryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher result = Cipher.getInstance(this.getType());
        result.init(decryptMode, new SecretKeySpec(this.secretKey, this.getType()));
        return result;
    }

    public String getType() {
        return "AES";
    }
}

