/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.algorithm.like;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.encrypt.api.encrypt.like.LikeEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.exception.algorithm.EncryptAlgorithmInitializationException;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;

public final class CharDigestLikeEncryptAlgorithm
implements LikeEncryptAlgorithm<Object, String> {
    private static final String DELTA = "delta";
    private static final String MASK = "mask";
    private static final String START = "start";
    private static final String DICT = "dict";
    private static final int DEFAULT_DELTA = 1;
    private static final int DEFAULT_MASK = 3965;
    private static final int DEFAULT_START = 19968;
    private static final int MAX_NUMERIC_LETTER_CHAR = 255;
    private int delta;
    private int mask;
    private int start;
    private Map<Character, Integer> charIndexes;

    public void init(Properties props) {
        this.delta = this.createDelta(props);
        this.mask = this.createMask(props);
        this.start = this.createStart(props);
        this.charIndexes = this.createCharIndexes(props);
    }

    private int createDelta(Properties props) {
        if (props.containsKey(DELTA)) {
            String delta = props.getProperty(DELTA);
            try {
                return Integer.parseInt(delta);
            }
            catch (NumberFormatException ex) {
                throw new EncryptAlgorithmInitializationException("CHAR_DIGEST_LIKE", "delta can only be a decimal number");
            }
        }
        return 1;
    }

    private int createMask(Properties props) {
        if (props.containsKey(MASK)) {
            String mask = props.getProperty(MASK);
            try {
                return Integer.parseInt(mask);
            }
            catch (NumberFormatException ex) {
                throw new EncryptAlgorithmInitializationException("CHAR_DIGEST_LIKE", "mask can only be a decimal number");
            }
        }
        return 3965;
    }

    private int createStart(Properties props) {
        if (props.containsKey(START)) {
            String start = props.getProperty(START);
            try {
                return Integer.parseInt(start);
            }
            catch (NumberFormatException ex) {
                throw new EncryptAlgorithmInitializationException("CHAR_DIGEST_LIKE", "start can only be a decimal number");
            }
        }
        return 19968;
    }

    private Map<Character, Integer> createCharIndexes(Properties props) {
        String dictContent = props.containsKey(DICT) && !Strings.isNullOrEmpty((String)props.getProperty(DICT)) ? props.getProperty(DICT) : this.initDefaultDict();
        HashMap<Character, Integer> result = new HashMap<Character, Integer>(dictContent.length(), 1.0f);
        for (int index = 0; index < dictContent.length(); ++index) {
            result.put(Character.valueOf(dictContent.charAt(index)), index);
        }
        return result;
    }

    private String initDefaultDict() {
        InputStream inputStream = CharDigestLikeEncryptAlgorithm.class.getClassLoader().getResourceAsStream("algorithm/like/common_chinese_character.dict");
        LineProcessor<String> lineProcessor = new LineProcessor<String>(){
            private final StringBuilder builder = new StringBuilder();

            public boolean processLine(String line) {
                if (line.startsWith("#") || 0 == line.length()) {
                    return true;
                }
                this.builder.append(line);
                return false;
            }

            public String getResult() {
                return this.builder.toString();
            }
        };
        return (String)CharStreams.readLines((Readable)new InputStreamReader(inputStream, Charsets.UTF_8), (LineProcessor)lineProcessor);
    }

    public String encrypt(Object plainValue, EncryptContext encryptContext) {
        return null == plainValue ? null : this.digest(String.valueOf(plainValue));
    }

    private String digest(String plainValue) {
        StringBuilder result = new StringBuilder(plainValue.length());
        for (char each : plainValue.toCharArray()) {
            char maskedChar = this.getMaskedChar(each);
            if ('%' == maskedChar || '_' == maskedChar) {
                result.append(each);
                continue;
            }
            result.append(maskedChar);
        }
        return result.toString();
    }

    private char getMaskedChar(char originalChar) {
        if ('%' == originalChar || '_' == originalChar) {
            return originalChar;
        }
        if (originalChar <= '\u00ff') {
            return (char)(originalChar + this.delta & this.mask);
        }
        if (this.charIndexes.containsKey(Character.valueOf(originalChar))) {
            return (char)((this.charIndexes.get(Character.valueOf(originalChar)) + this.delta & this.mask) + this.start);
        }
        return (char)((originalChar + this.delta & this.mask) + this.start);
    }

    public String getType() {
        return "CHAR_DIGEST_LIKE";
    }
}

