/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptAssistedQueryColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptAssistedQueryEncryptorNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptCipherColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptEncryptorNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptLikeQueryColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptLikeQueryEncryptorNotFoundException;
import org.apache.shardingsphere.infra.config.rule.checker.RuleConfigurationChecker;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public final class EncryptRuleConfigurationChecker
implements RuleConfigurationChecker<EncryptRuleConfiguration> {
    public void check(String databaseName, EncryptRuleConfiguration config, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) {
        this.checkTableConfiguration(databaseName, config.getTables(), config.getEncryptors().keySet());
    }

    private void checkTableConfiguration(String databaseName, Collection<EncryptTableRuleConfiguration> tables, Collection<String> encryptors) {
        for (EncryptTableRuleConfiguration each : tables) {
            for (EncryptColumnRuleConfiguration column : each.getColumns()) {
                this.checkCipherColumnConfiguration(databaseName, encryptors, column);
                this.checkAssistColumnConfiguration(databaseName, encryptors, column);
                this.checkLikeColumnConfiguration(databaseName, encryptors, column);
            }
        }
    }

    private void checkCipherColumnConfiguration(String databaseName, Collection<String> encryptors, EncryptColumnRuleConfiguration column) {
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)column.getCipherColumn()) ? 1 : 0) != 0, () -> new EncryptCipherColumnNotFoundException(column.getLogicColumn(), databaseName));
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)column.getEncryptorName()) ? 1 : 0) != 0, () -> new EncryptEncryptorNotFoundException(String.format("Encryptor name of `%s` can not be null in database `%s`.", column.getLogicColumn(), databaseName)));
        ShardingSpherePreconditions.checkState((boolean)encryptors.contains(column.getEncryptorName()), () -> new EncryptEncryptorNotFoundException(String.format("Can not find encryptor `%s` in database `%s`.", column.getEncryptorName(), databaseName)));
    }

    private void checkAssistColumnConfiguration(String databaseName, Collection<String> encryptors, EncryptColumnRuleConfiguration column) {
        if (Strings.isNullOrEmpty((String)column.getAssistedQueryColumn()) && Strings.isNullOrEmpty((String)column.getAssistedQueryEncryptorName())) {
            return;
        }
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)column.getAssistedQueryColumn()) ? 1 : 0) != 0, () -> new EncryptAssistedQueryColumnNotFoundException(column.getLogicColumn(), databaseName));
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)column.getAssistedQueryEncryptorName()) ? 1 : 0) != 0, () -> new EncryptAssistedQueryEncryptorNotFoundException(String.format("Assisted query encryptor name of `%s` can not be null in database `%s`.", column.getLogicColumn(), databaseName)));
        ShardingSpherePreconditions.checkState((boolean)encryptors.contains(column.getAssistedQueryEncryptorName()), () -> new EncryptAssistedQueryEncryptorNotFoundException(String.format("Can not find assisted query encryptor `%s` in database `%s`.", column.getAssistedQueryEncryptorName(), databaseName)));
    }

    private void checkLikeColumnConfiguration(String databaseName, Collection<String> encryptors, EncryptColumnRuleConfiguration column) {
        if (Strings.isNullOrEmpty((String)column.getLikeQueryColumn()) && Strings.isNullOrEmpty((String)column.getLikeQueryEncryptorName())) {
            return;
        }
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)column.getLikeQueryColumn()) ? 1 : 0) != 0, () -> new EncryptLikeQueryColumnNotFoundException(column.getLogicColumn(), databaseName));
        ShardingSpherePreconditions.checkState((!Strings.isNullOrEmpty((String)column.getLikeQueryEncryptorName()) ? 1 : 0) != 0, () -> new EncryptLikeQueryEncryptorNotFoundException(String.format("Like query encryptor name of `%s` can not be null in database `%s`.", column.getLogicColumn(), databaseName)));
        ShardingSpherePreconditions.checkState((boolean)encryptors.contains(column.getLikeQueryEncryptorName()), () -> new EncryptLikeQueryEncryptorNotFoundException(String.format("Can not find like query encryptor `%s` in database `%s`.", column.getLikeQueryEncryptorName(), databaseName)));
    }

    public int getOrder() {
        return 10;
    }

    public Class<EncryptRuleConfiguration> getTypeClass() {
        return EncryptRuleConfiguration.class;
    }
}

