/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge;

import org.apache.shardingsphere.encrypt.merge.dal.EncryptDALResultDecorator;
import org.apache.shardingsphere.encrypt.merge.dql.EncryptAlgorithmMetaData;
import org.apache.shardingsphere.encrypt.merge.dql.EncryptDQLResultDecorator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.infra.merge.engine.decorator.ResultDecoratorEngine;
import org.apache.shardingsphere.infra.merge.engine.decorator.impl.TransparentResultDecorator;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;

public final class EncryptResultDecoratorEngine
implements ResultDecoratorEngine<EncryptRule> {
    public ResultDecorator<?> newInstance(ShardingSphereDatabase database, EncryptRule encryptRule, ConfigurationProperties props, SQLStatementContext<?> sqlStatementContext) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            EncryptAlgorithmMetaData algorithmMetaData = new EncryptAlgorithmMetaData(database, encryptRule, (SelectStatementContext)sqlStatementContext);
            return new EncryptDQLResultDecorator(algorithmMetaData);
        }
        if (sqlStatementContext.getSqlStatement() instanceof DALStatement) {
            return new EncryptDALResultDecorator();
        }
        return new TransparentResultDecorator();
    }

    public int getOrder() {
        return 10;
    }

    public Class<EncryptRule> getTypeClass() {
        return EncryptRule.class;
    }
}

