/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.show;

import com.google.common.base.Splitter;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public abstract class EncryptShowCreateTableMergedResult
implements MergedResult {
    private static final String COMMA = ",";
    private static final int CREATE_TABLE_DEFINITION_INDEX = 2;
    private final String tableName;
    private final EncryptRule encryptRule;

    protected EncryptShowCreateTableMergedResult(SQLStatementContext<?> sqlStatementContext, EncryptRule encryptRule) {
        ShardingSpherePreconditions.checkState((sqlStatementContext instanceof TableAvailable && 1 == ((TableAvailable)sqlStatementContext).getAllTables().size() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("SHOW CREATE TABLE FOR MULTI TABLE"));
        this.tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
        this.encryptRule = encryptRule;
    }

    public final boolean next() throws SQLException {
        return this.nextValue();
    }

    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (2 == columnIndex) {
            String result = this.getOriginalValue(2, type).toString();
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(this.tableName);
            if (!encryptTable.isPresent()) {
                return result;
            }
            StringBuilder builder = new StringBuilder(result.substring(0, result.indexOf("(") + 1));
            List columnDefinitions = Splitter.on((String)COMMA).splitToList((CharSequence)result.substring(result.indexOf("(") + 1, result.lastIndexOf(")")));
            for (String each : columnDefinitions) {
                this.findLogicColumnDefinition(each, encryptTable.get()).ifPresent(optional -> builder.append((String)optional).append(COMMA));
            }
            builder.deleteCharAt(builder.length() - 1).append(result.substring(result.lastIndexOf(")")));
            return builder.toString();
        }
        return this.getOriginalValue(columnIndex, type);
    }

    private Optional<String> findLogicColumnDefinition(String columnDefinition, EncryptTable encryptTable) {
        Collection cipherColumns = encryptTable.getLogicColumns().stream().map(encryptTable::getCipherColumn).collect(Collectors.toList());
        for (String each : cipherColumns) {
            if (!columnDefinition.contains(each)) continue;
            return Optional.of(columnDefinition.replace(each, encryptTable.getLogicColumnByCipherColumn(each)));
        }
        if (encryptTable.getPlainColumns().stream().anyMatch(columnDefinition::contains)) {
            return Optional.empty();
        }
        if (encryptTable.getAssistedQueryColumns().stream().anyMatch(columnDefinition::contains)) {
            return Optional.empty();
        }
        if (encryptTable.getLikeQueryColumns().stream().anyMatch(columnDefinition::contains)) {
            return Optional.empty();
        }
        return Optional.of(columnDefinition);
    }

    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException("");
    }

    protected abstract boolean nextValue() throws SQLException;

    protected abstract Object getOriginalValue(int var1, Class<?> var2) throws SQLException;
}

