/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.metadata.reviser.column;

import java.util.Collection;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnExistedReviser;

public final class EncryptColumnExistedReviser
implements ColumnExistedReviser {
    private final EncryptTable encryptTable;
    private final Collection<String> plainColumns;
    private final Collection<String> assistedQueryColumns;
    private final Collection<String> likeQueryColumns;

    public EncryptColumnExistedReviser(EncryptTable encryptTable) {
        this.encryptTable = encryptTable;
        this.plainColumns = encryptTable.getPlainColumns();
        this.assistedQueryColumns = encryptTable.getAssistedQueryColumns();
        this.likeQueryColumns = encryptTable.getLikeQueryColumns();
    }

    public boolean isExisted(String originalName) {
        return this.plainColumns.contains(originalName) || this.encryptTable.isCipherColumn(originalName) || !this.assistedQueryColumns.contains(originalName) && !this.likeQueryColumns.contains(originalName);
    }
}

