/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.metadata.reviser.column;

import java.util.Collection;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.column.ColumnNameReviser;

public final class EncryptColumnNameReviser
implements ColumnNameReviser {
    private final EncryptTable encryptTable;
    private final Collection<String> plainColumns;

    public EncryptColumnNameReviser(EncryptTable encryptTable) {
        this.encryptTable = encryptTable;
        this.plainColumns = encryptTable.getPlainColumns();
    }

    public String revise(String originalName) {
        if (this.plainColumns.contains(originalName)) {
            return this.encryptTable.getLogicColumnByPlainColumn(originalName);
        }
        if (this.encryptTable.isCipherColumn(originalName)) {
            return this.encryptTable.getLogicColumnByCipherColumn(originalName);
        }
        return originalName;
    }
}

