/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.condition;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;

public final class EncryptConditionEngine {
    private static final Set<String> LOGICAL_OPERATOR = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> SUPPORTED_COMPARE_OPERATOR = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final EncryptRule encryptRule;
    private final Map<String, ShardingSphereSchema> schemas;

    public Collection<EncryptCondition> createEncryptConditions(Collection<WhereSegment> whereSegments, Collection<ColumnSegment> columnSegments, SQLStatementContext<?> sqlStatementContext, String databaseName) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)databaseName);
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(this.schemas::get).orElseGet(() -> this.schemas.get(defaultSchema));
        Map expressionTableNames = sqlStatementContext.getTablesContext().findTableNamesByColumnSegment(columnSegments, schema);
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractUtil.getAndPredicates((ExpressionSegment)each.getExpr());
            for (AndPredicate predicate : andPredicates) {
                this.addEncryptConditions(result, predicate.getPredicates(), (Map<String, String>)expressionTableNames);
            }
        }
        return result;
    }

    private void addEncryptConditions(Collection<EncryptCondition> encryptConditions, Collection<ExpressionSegment> predicates, Map<String, String> expressionTableNames) {
        HashSet<Integer> stopIndexes = new HashSet<Integer>(predicates.size(), 1.0f);
        for (ExpressionSegment each : predicates) {
            if (!stopIndexes.add(each.getStopIndex())) continue;
            this.addEncryptConditions(encryptConditions, each, expressionTableNames);
        }
    }

    private void addEncryptConditions(Collection<EncryptCondition> encryptConditions, ExpressionSegment expression, Map<String, String> expressionTableNames) {
        if (!this.findNotContainsNullLiteralsExpression(expression).isPresent()) {
            return;
        }
        for (ColumnSegment each : ColumnExtractor.extract((ExpressionSegment)expression)) {
            String tableName = expressionTableNames.getOrDefault(each.getExpression(), "");
            Optional<EncryptColumn> encryptColumn = this.encryptRule.findEncryptColumn(tableName, each.getIdentifier().getValue());
            Optional<EncryptCondition> encryptCondition = encryptColumn.isPresent() ? this.createEncryptCondition(expression, tableName) : Optional.empty();
            encryptCondition.ifPresent(encryptConditions::add);
        }
    }

    private Optional<ExpressionSegment> findNotContainsNullLiteralsExpression(ExpressionSegment expression) {
        if (this.isContainsNullLiterals(expression)) {
            return Optional.empty();
        }
        if (expression instanceof BinaryOperationExpression && this.isContainsNullLiterals(((BinaryOperationExpression)expression).getRight())) {
            return Optional.empty();
        }
        return Optional.ofNullable(expression);
    }

    private boolean isContainsNullLiterals(ExpressionSegment expression) {
        if (!(expression instanceof LiteralExpressionSegment)) {
            return false;
        }
        String literals = String.valueOf(((LiteralExpressionSegment)expression).getLiterals());
        return "NULL".equalsIgnoreCase(literals) || "NOT NULL".equalsIgnoreCase(literals);
    }

    private Optional<EncryptCondition> createEncryptCondition(ExpressionSegment expression, String tableName) {
        if (expression instanceof BinaryOperationExpression) {
            return this.createBinaryEncryptCondition((BinaryOperationExpression)expression, tableName);
        }
        if (expression instanceof InExpression) {
            return EncryptConditionEngine.createInEncryptCondition(tableName, (InExpression)expression, ((InExpression)expression).getRight());
        }
        if (expression instanceof BetweenExpression) {
            throw new UnsupportedEncryptSQLException("BETWEEN...AND...");
        }
        return Optional.empty();
    }

    private Optional<EncryptCondition> createBinaryEncryptCondition(BinaryOperationExpression expression, String tableName) {
        String operator = expression.getOperator();
        if (!LOGICAL_OPERATOR.contains(operator)) {
            if (SUPPORTED_COMPARE_OPERATOR.contains(operator)) {
                return this.createCompareEncryptCondition(tableName, expression, expression.getRight());
            }
            throw new UnsupportedEncryptSQLException(operator);
        }
        return Optional.empty();
    }

    private Optional<EncryptCondition> createCompareEncryptCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment compareRightValue) {
        if (!(expression.getLeft() instanceof ColumnSegment) || compareRightValue instanceof SubqueryExpressionSegment) {
            return Optional.empty();
        }
        if (compareRightValue instanceof SimpleExpressionSegment) {
            return Optional.of(this.createEncryptBinaryOperationCondition(tableName, expression, compareRightValue));
        }
        if (compareRightValue instanceof ListExpression) {
            return Optional.of(this.createEncryptBinaryOperationCondition(tableName, expression, (ExpressionSegment)((ListExpression)compareRightValue).getItems().get(0)));
        }
        return Optional.empty();
    }

    private EncryptBinaryCondition createEncryptBinaryOperationCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment compareRightValue) {
        String columnName = ((ColumnSegment)expression.getLeft()).getIdentifier().getValue();
        return new EncryptBinaryCondition(columnName, tableName, expression.getOperator(), compareRightValue.getStartIndex(), expression.getStopIndex(), compareRightValue);
    }

    private static Optional<EncryptCondition> createInEncryptCondition(String tableName, InExpression inExpression, ExpressionSegment inRightValue) {
        if (!(inExpression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        LinkedList<ExpressionSegment> expressionSegments = new LinkedList<ExpressionSegment>();
        for (ExpressionSegment each : inExpression.getExpressionList()) {
            if (!(each instanceof SimpleExpressionSegment)) continue;
            expressionSegments.add(each);
        }
        if (expressionSegments.isEmpty()) {
            return Optional.empty();
        }
        String columnName = ((ColumnSegment)inExpression.getLeft()).getIdentifier().getValue();
        return Optional.of(new EncryptInCondition(columnName, tableName, inRightValue.getStartIndex(), inRightValue.getStopIndex(), expressionSegments));
    }

    @Generated
    public EncryptConditionEngine(EncryptRule encryptRule, Map<String, ShardingSphereSchema> schemas) {
        this.encryptRule = encryptRule;
        this.schemas = schemas;
    }

    static {
        LOGICAL_OPERATOR.add("AND");
        LOGICAL_OPERATOR.add("&&");
        LOGICAL_OPERATOR.add("OR");
        LOGICAL_OPERATOR.add("||");
        SUPPORTED_COMPARE_OPERATOR.add("=");
        SUPPORTED_COMPARE_OPERATOR.add("<>");
        SUPPORTED_COMPARE_OPERATOR.add("!=");
        SUPPORTED_COMPARE_OPERATOR.add(">");
        SUPPORTED_COMPARE_OPERATOR.add("<");
        SUPPORTED_COMPARE_OPERATOR.add(">=");
        SUPPORTED_COMPARE_OPERATOR.add("<=");
        SUPPORTED_COMPARE_OPERATOR.add("IS");
        SUPPORTED_COMPARE_OPERATOR.add("LIKE");
    }
}

