/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptAssignmentParameterRewriter
implements ParameterRewriter<SQLStatementContext<?>>,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isNeedRewrite(SQLStatementContext<?> sqlStatementContext) {
        if (sqlStatementContext instanceof UpdateStatementContext) {
            return true;
        }
        if (sqlStatementContext instanceof InsertStatementContext) {
            return InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent();
        }
        return false;
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext<?> sqlStatementContext, List<Object> params) {
        String tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.databaseName));
        for (AssignmentSegment each : this.getSetAssignmentSegment(sqlStatementContext.getSqlStatement()).getAssignments()) {
            if (!(each.getValue() instanceof ParameterMarkerExpressionSegment) || !this.encryptRule.findEncryptor(tableName, ((ColumnSegment)each.getColumns().get(0)).getIdentifier().getValue()).isPresent()) continue;
            StandardParameterBuilder standardParamBuilder = paramBuilder instanceof StandardParameterBuilder ? (StandardParameterBuilder)paramBuilder : (StandardParameterBuilder)((GroupedParameterBuilder)paramBuilder).getParameterBuilders().get(0);
            this.encryptParameters(standardParamBuilder, schemaName, tableName, each, params);
        }
    }

    private SetAssignmentSegment getSetAssignmentSegment(SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            Optional result = InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)sqlStatement));
            Preconditions.checkState((boolean)result.isPresent());
            return (SetAssignmentSegment)result.get();
        }
        return ((UpdateStatement)sqlStatement).getSetAssignment();
    }

    private void encryptParameters(StandardParameterBuilder paramBuilder, String schemaName, String tableName, AssignmentSegment assignmentSegment, List<Object> params) {
        String columnName = ((ColumnSegment)assignmentSegment.getColumns().get(0)).getIdentifier().getValue();
        int parameterMarkerIndex = ((ParameterMarkerExpressionSegment)assignmentSegment.getValue()).getParameterMarkerIndex();
        Object originalValue = params.get(parameterMarkerIndex);
        Object cipherValue = this.encryptRule.getEncryptValues(this.databaseName, schemaName, tableName, columnName, Collections.singletonList(originalValue)).iterator().next();
        paramBuilder.addReplacedParameters(parameterMarkerIndex, cipherValue);
        LinkedList<Object> addedParams = new LinkedList<Object>();
        if (this.encryptRule.findAssistedQueryColumn(tableName, columnName).isPresent()) {
            Object assistedQueryValue = this.encryptRule.getEncryptAssistedQueryValues(this.databaseName, schemaName, tableName, columnName, Collections.singletonList(originalValue)).iterator().next();
            addedParams.add(assistedQueryValue);
        }
        if (this.encryptRule.findLikeQueryColumn(tableName, columnName).isPresent()) {
            Object likeValue = this.encryptRule.getEncryptLikeQueryValues(this.databaseName, schemaName, tableName, columnName, Collections.singletonList(originalValue)).iterator().next();
            addedParams.add(likeValue);
        }
        if (this.encryptRule.findPlainColumn(tableName, columnName).isPresent()) {
            addedParams.add(originalValue);
        }
        if (!addedParams.isEmpty()) {
            paramBuilder.addAddedParameters(parameterMarkerIndex, addedParams);
        }
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

