/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.api.encrypt.like.LikeEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.OnDuplicateUpdateContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter
implements ParameterRewriter<InsertStatementContext>,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isNeedRewrite(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent();
    }

    public void rewrite(ParameterBuilder paramBuilder, InsertStatementContext insertStatementContext, List<Object> params) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        GroupedParameterBuilder groupedParamBuilder = (GroupedParameterBuilder)paramBuilder;
        OnDuplicateUpdateContext onDuplicateKeyUpdateValueContext = insertStatementContext.getOnDuplicateKeyUpdateValueContext();
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)insertStatementContext.getDatabaseType(), (String)this.databaseName));
        int index = 0;
        while (index < onDuplicateKeyUpdateValueContext.getValueExpressions().size()) {
            int columnIndex = index++;
            String encryptLogicColumnName = onDuplicateKeyUpdateValueContext.getColumn(columnIndex).getIdentifier().getValue();
            EncryptContext encryptContext = EncryptContextBuilder.build(this.databaseName, schemaName, tableName, encryptLogicColumnName);
            Optional<StandardEncryptAlgorithm> encryptor = this.encryptRule.findEncryptor(tableName, encryptLogicColumnName);
            encryptor.ifPresent(optional -> {
                Optional<LikeEncryptAlgorithm> likeQueryEncryptor;
                Object plainColumnValue = onDuplicateKeyUpdateValueContext.getValue(columnIndex);
                if (plainColumnValue instanceof FunctionSegment && "VALUES".equalsIgnoreCase(((FunctionSegment)plainColumnValue).getFunctionName())) {
                    return;
                }
                Object cipherColumnValue = ((StandardEncryptAlgorithm)encryptor.get()).encrypt(plainColumnValue, encryptContext);
                groupedParamBuilder.getGenericParameterBuilder().addReplacedParameters(columnIndex, cipherColumnValue);
                LinkedList<Object> addedParams = new LinkedList<Object>();
                Optional<StandardEncryptAlgorithm> assistedQueryEncryptor = this.encryptRule.findAssistedQueryEncryptor(tableName, encryptLogicColumnName);
                if (assistedQueryEncryptor.isPresent()) {
                    Optional<String> assistedColumnName = this.encryptRule.findAssistedQueryColumn(tableName, encryptLogicColumnName);
                    Preconditions.checkArgument((boolean)assistedColumnName.isPresent(), (Object)"Can not find assisted query Column Name");
                    addedParams.add(assistedQueryEncryptor.get().encrypt(plainColumnValue, encryptContext));
                }
                if ((likeQueryEncryptor = this.encryptRule.findLikeQueryEncryptor(tableName, encryptLogicColumnName)).isPresent()) {
                    Optional<String> likeColumnName = this.encryptRule.findLikeQueryColumn(tableName, encryptLogicColumnName);
                    Preconditions.checkArgument((boolean)likeColumnName.isPresent(), (Object)"Can not find assisted query Column Name");
                    addedParams.add(likeQueryEncryptor.get().encrypt(plainColumnValue, encryptContext));
                }
                if (this.encryptRule.findPlainColumn(tableName, encryptLogicColumnName).isPresent()) {
                    addedParams.add(plainColumnValue);
                }
                if (!addedParams.isEmpty()) {
                    if (!groupedParamBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().containsKey(columnIndex)) {
                        groupedParamBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().put(columnIndex, new LinkedList());
                    }
                    ((Collection)groupedParamBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().get(columnIndex)).addAll(addedParams);
                }
            });
        }
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

