/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.api.encrypt.like.LikeEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptAssistedQueryColumnNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptLikeQueryColumnNotFoundException;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertValueParameterRewriter
implements ParameterRewriter<InsertStatementContext>,
EncryptRuleAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private String databaseName;

    public boolean isNeedRewrite(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent() && null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public void rewrite(ParameterBuilder paramBuilder, InsertStatementContext insertStatementContext, List<Object> params) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        String schemaName = insertStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)insertStatementContext.getDatabaseType(), (String)this.databaseName));
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            EncryptContext encryptContext = EncryptContextBuilder.build(this.databaseName, schemaName, tableName, columnName);
            this.encryptRule.findEncryptor(tableName, columnName).ifPresent(optional -> this.encryptInsertValues((GroupedParameterBuilder)paramBuilder, insertStatementContext, (StandardEncryptAlgorithm)optional, this.encryptRule.findAssistedQueryEncryptor(tableName, columnName).orElse(null), this.encryptRule.findLikeQueryEncryptor(tableName, columnName).orElse(null), encryptContext));
        }
    }

    private void encryptInsertValues(GroupedParameterBuilder paramBuilder, InsertStatementContext insertStatementContext, StandardEncryptAlgorithm encryptAlgorithm, StandardEncryptAlgorithm assistEncryptAlgorithm, LikeEncryptAlgorithm likeEncryptAlgorithm, EncryptContext encryptContext) {
        int columnIndex = this.getColumnIndex(paramBuilder, insertStatementContext, encryptContext.getColumnName());
        int count = 0;
        for (List each : insertStatementContext.getGroupedParameters()) {
            int paramIndex = ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getParameterIndex(columnIndex);
            if (!each.isEmpty()) {
                StandardParameterBuilder standardParamBuilder = (StandardParameterBuilder)paramBuilder.getParameterBuilders().get(count);
                ExpressionSegment expressionSegment = (ExpressionSegment)((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getValueExpressions().get(columnIndex);
                if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
                    Object literalValue = ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getLiteralValue(columnIndex).orElse(null);
                    this.encryptInsertValue(encryptAlgorithm, assistEncryptAlgorithm, likeEncryptAlgorithm, paramIndex, literalValue, standardParamBuilder, encryptContext);
                }
            }
            ++count;
        }
    }

    private int getColumnIndex(GroupedParameterBuilder paramBuilder, InsertStatementContext insertStatementContext, String encryptLogicColumnName) {
        ArrayList columnNames;
        if (paramBuilder.getDerivedColumnName().isPresent()) {
            columnNames = new ArrayList(insertStatementContext.getColumnNames());
            columnNames.remove(paramBuilder.getDerivedColumnName().get());
        } else {
            columnNames = insertStatementContext.getColumnNames();
        }
        return columnNames.indexOf(encryptLogicColumnName);
    }

    private void encryptInsertValue(StandardEncryptAlgorithm encryptor, StandardEncryptAlgorithm assistEncryptor, LikeEncryptAlgorithm likeEncryptor, int paramIndex, Object originalValue, StandardParameterBuilder paramBuilder, EncryptContext encryptContext) {
        paramBuilder.addReplacedParameters(paramIndex, encryptor.encrypt(originalValue, encryptContext));
        LinkedList<Object> addedParams = new LinkedList<Object>();
        if (null != assistEncryptor) {
            Optional<String> assistedColumnName = this.encryptRule.findAssistedQueryColumn(encryptContext.getTableName(), encryptContext.getColumnName());
            ShardingSpherePreconditions.checkState((boolean)assistedColumnName.isPresent(), EncryptAssistedQueryColumnNotFoundException::new);
            addedParams.add(assistEncryptor.encrypt(originalValue, encryptContext));
        }
        if (null != likeEncryptor) {
            Optional<String> likeColumnName = this.encryptRule.findLikeQueryColumn(encryptContext.getTableName(), encryptContext.getColumnName());
            ShardingSpherePreconditions.checkState((boolean)likeColumnName.isPresent(), EncryptLikeQueryColumnNotFoundException::new);
            addedParams.add(likeEncryptor.encrypt(originalValue, encryptContext));
        }
        if (this.encryptRule.findPlainColumn(encryptContext.getTableName(), encryptContext.getColumnName()).isPresent()) {
            addedParams.add(originalValue);
        }
        if (!addedParams.isEmpty()) {
            if (!paramBuilder.getAddedIndexAndParameters().containsKey(paramIndex)) {
                paramBuilder.getAddedIndexAndParameters().put(paramIndex, new LinkedList());
            }
            ((Collection)paramBuilder.getAddedIndexAndParameters().get(paramIndex)).addAll(addedParams);
        }
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

