/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptConditionsAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;

public final class EncryptPredicateParameterRewriter
implements ParameterRewriter<SQLStatementContext<?>>,
EncryptRuleAware,
EncryptConditionsAware,
DatabaseNameAware {
    private EncryptRule encryptRule;
    private Collection<EncryptCondition> encryptConditions;
    private String databaseName;

    public boolean isNeedRewrite(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext<?> sqlStatementContext, List<Object> params) {
        String schemaName = sqlStatementContext.getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.databaseName));
        for (EncryptCondition each : this.encryptConditions) {
            boolean queryWithCipherColumn = this.encryptRule.isQueryWithCipherColumn(each.getTableName(), each.getColumnName());
            if (!queryWithCipherColumn) continue;
            this.encryptParameters(paramBuilder, each.getPositionIndexMap(), this.getEncryptedValues(schemaName, each, each.getValues(params)));
        }
    }

    private List<Object> getEncryptedValues(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues) {
        String tableName = encryptCondition.getTableName();
        String columnName = encryptCondition.getColumnName();
        if (encryptCondition instanceof EncryptBinaryCondition && "LIKE".equals(((EncryptBinaryCondition)encryptCondition).getOperator()) && this.encryptRule.findLikeQueryColumn(tableName, columnName).isPresent()) {
            return this.encryptRule.getEncryptLikeQueryValues(this.databaseName, schemaName, tableName, columnName, originalValues);
        }
        return this.encryptRule.findAssistedQueryColumn(tableName, columnName).isPresent() ? this.encryptRule.getEncryptAssistedQueryValues(this.databaseName, schemaName, tableName, columnName, originalValues) : this.encryptRule.getEncryptValues(this.databaseName, schemaName, tableName, columnName, originalValues);
    }

    private void encryptParameters(ParameterBuilder paramBuilder, Map<Integer, Integer> positionIndexes, List<Object> encryptValues) {
        if (!positionIndexes.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : positionIndexes.entrySet()) {
                ((StandardParameterBuilder)paramBuilder).addReplacedParameters(entry.getValue().intValue(), encryptValues.get(entry.getKey()));
            }
        }
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setEncryptConditions(Collection<EncryptCondition> encryptConditions) {
        this.encryptConditions = encryptConditions;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

