/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.enums.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;

public final class EncryptIndexColumnTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>>,
EncryptRuleAware {
    private EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof IndexAvailable;
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext<?> sqlStatementContext) {
        Preconditions.checkArgument((boolean)(sqlStatementContext instanceof IndexAvailable), (Object)"SQLStatementContext must implementation IndexAvailable interface.");
        if (sqlStatementContext.getTablesContext().getTableNames().isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        String tableName = (String)sqlStatementContext.getTablesContext().getTableNames().iterator().next();
        for (ColumnSegment each : ((IndexAvailable)sqlStatementContext).getIndexColumns()) {
            this.encryptRule.findEncryptor(tableName, each.getIdentifier().getValue()).flatMap(optional -> this.getColumnToken(tableName, each)).ifPresent(result::add);
        }
        return result;
    }

    private Optional<SQLToken> getColumnToken(String tableName, ColumnSegment columnSegment) {
        String columnName = columnSegment.getIdentifier().getValue();
        QuoteCharacter quoteCharacter = columnSegment.getIdentifier().getQuoteCharacter();
        int startIndex = columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        boolean queryWithCipherColumn = this.encryptRule.isQueryWithCipherColumn(tableName, columnName);
        if (queryWithCipherColumn) {
            return this.encryptRule.findAssistedQueryColumn(tableName, columnName).map(optional -> this.getAssistedQueryColumnToken(startIndex, stopIndex, (String)optional, quoteCharacter)).orElseGet(() -> this.getCipherColumnToken(tableName, startIndex, stopIndex, columnName, quoteCharacter));
        }
        return this.getPlainColumnToken(tableName, startIndex, stopIndex, columnName, quoteCharacter);
    }

    private Optional<SQLToken> getAssistedQueryColumnToken(int startIndex, int stopIndex, String columnName, QuoteCharacter quoteCharacter) {
        Collection<ColumnProjection> columnProjections = this.getColumnProjections(columnName);
        return Optional.of(new SubstitutableColumnNameToken(startIndex, stopIndex, columnProjections, quoteCharacter));
    }

    private Optional<SQLToken> getCipherColumnToken(String tableName, int startIndex, int stopIndex, String columnName, QuoteCharacter quoteCharacter) {
        String cipherColumn = this.encryptRule.getCipherColumn(tableName, columnName);
        Collection<ColumnProjection> columnProjections = this.getColumnProjections(cipherColumn);
        return Optional.of(new SubstitutableColumnNameToken(startIndex, stopIndex, columnProjections, quoteCharacter));
    }

    private Optional<SQLToken> getPlainColumnToken(String tableName, int startIndex, int stopIndex, String columnName, QuoteCharacter quoteCharacter) {
        return this.encryptRule.findPlainColumn(tableName, columnName).map(optional -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.getColumnProjections((String)optional), quoteCharacter));
    }

    private Collection<ColumnProjection> getColumnProjections(String columnName) {
        return Collections.singletonList(new ColumnProjection(null, columnName, null));
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

