/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;

public final class EncryptOrderByItemTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>>,
SchemaMetaDataAware,
EncryptRuleAware {
    private String databaseName;
    private Map<String, ShardingSphereSchema> schemas;
    private EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && this.containsOrderByItem(sqlStatementContext);
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext<?> sqlStatementContext) {
        LinkedHashSet<SubstitutableColumnNameToken> result = new LinkedHashSet<SubstitutableColumnNameToken>();
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.databaseName);
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(this.schemas::get).orElseGet(() -> this.schemas.get(defaultSchema));
        for (OrderByItem each : this.getOrderByItems(sqlStatementContext)) {
            if (!(each.getSegment() instanceof ColumnOrderByItemSegment)) continue;
            ColumnSegment columnSegment = ((ColumnOrderByItemSegment)each.getSegment()).getColumn();
            Map columnTableNames = sqlStatementContext.getTablesContext().findTableNamesByColumnSegment(Collections.singletonList(columnSegment), schema);
            result.addAll(this.generateSQLTokensWithColumnSegments(Collections.singletonList(columnSegment), columnTableNames));
        }
        return result;
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokensWithColumnSegments(Collection<ColumnSegment> columnSegments, Map<String, String> columnTableNames) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (ColumnSegment column : columnSegments) {
            Optional<String> plainColumn;
            String tableName = columnTableNames.getOrDefault(column.getExpression(), "");
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(tableName);
            if (!encryptTable.isPresent() || !encryptTable.get().findEncryptorName(column.getIdentifier().getValue()).isPresent()) continue;
            int startIndex = column.getOwner().isPresent() ? ((OwnerSegment)column.getOwner().get()).getStopIndex() + 2 : column.getStartIndex();
            int stopIndex = column.getStopIndex();
            boolean queryWithCipherColumn = this.encryptRule.isQueryWithCipherColumn(tableName, column.getIdentifier().getValue());
            if (!queryWithCipherColumn && (plainColumn = encryptTable.get().findPlainColumn(column.getIdentifier().getValue())).isPresent()) {
                result.add(new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(plainColumn.get())));
                continue;
            }
            Optional<String> assistedQueryColumn = encryptTable.get().findAssistedQueryColumn(column.getIdentifier().getValue());
            SubstitutableColumnNameToken encryptColumnNameToken = assistedQueryColumn.map(optional -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections((String)optional))).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(((EncryptTable)encryptTable.get()).getCipherColumn(column.getIdentifier().getValue()))));
            result.add(encryptColumnNameToken);
        }
        return result;
    }

    private Collection<OrderByItem> getOrderByItems(SQLStatementContext<?> sqlStatementContext) {
        if (!(sqlStatementContext instanceof SelectStatementContext)) {
            return Collections.emptyList();
        }
        LinkedList<OrderByItem> result = new LinkedList<OrderByItem>();
        SelectStatementContext statementContext = (SelectStatementContext)sqlStatementContext;
        result.addAll(statementContext.getOrderByContext().getItems());
        result.addAll(statementContext.getGroupByContext().getItems());
        for (SelectStatementContext each : statementContext.getSubqueryContexts().values()) {
            result.addAll(this.getOrderByItems((SQLStatementContext<?>)each));
        }
        return result;
    }

    private boolean containsOrderByItem(SQLStatementContext<?> sqlStatementContext) {
        if (!(sqlStatementContext instanceof SelectStatementContext)) {
            return false;
        }
        SelectStatementContext statementContext = (SelectStatementContext)sqlStatementContext;
        if (!statementContext.getOrderByContext().getItems().isEmpty() || !statementContext.getGroupByContext().getItems().isEmpty()) {
            return true;
        }
        for (SelectStatementContext each : statementContext.getSubqueryContexts().values()) {
            if (!this.containsOrderByItem((SQLStatementContext<?>)each)) continue;
            return true;
        }
        return false;
    }

    private Collection<ColumnProjection> createColumnProjections(String columnName) {
        return Collections.singletonList(new ColumnProjection(null, columnName, null));
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

