/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptRuleAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;

public final class EncryptPredicateColumnTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext<?>>,
SchemaMetaDataAware,
EncryptRuleAware {
    private String databaseName;
    private Map<String, ShardingSphereSchema> schemas;
    private EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext<?> sqlStatementContext) {
        List<ColumnSegment> columnSegments = Collections.emptyList();
        List<WhereSegment> whereSegments = Collections.emptyList();
        if (sqlStatementContext instanceof WhereAvailable) {
            columnSegments = ((WhereAvailable)sqlStatementContext).getColumnSegments();
            whereSegments = ((WhereAvailable)sqlStatementContext).getWhereSegments();
        }
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)sqlStatementContext.getDatabaseType(), (String)this.databaseName);
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(this.schemas::get).orElseGet(() -> this.schemas.get(defaultSchema));
        Map columnExpressionTableNames = sqlStatementContext.getTablesContext().findTableNamesByColumnSegment(columnSegments, schema);
        return this.generateSQLTokens(columnSegments, columnExpressionTableNames, whereSegments);
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(Collection<ColumnSegment> columnSegments, Map<String, String> columnExpressionTableNames, Collection<WhereSegment> whereSegments) {
        LinkedHashSet<SubstitutableColumnNameToken> result = new LinkedHashSet<SubstitutableColumnNameToken>();
        for (ColumnSegment each : columnSegments) {
            Optional<String> plainColumn;
            String tableName = Optional.ofNullable(columnExpressionTableNames.get(each.getExpression())).orElse("");
            Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(tableName);
            if (!encryptTable.isPresent() || !encryptTable.get().findEncryptColumn(each.getIdentifier().getValue()).isPresent()) continue;
            int startIndex = each.getOwner().isPresent() ? ((OwnerSegment)each.getOwner().get()).getStopIndex() + 2 : each.getStartIndex();
            int stopIndex = each.getStopIndex();
            boolean queryWithCipherColumn = this.encryptRule.isQueryWithCipherColumn(tableName, each.getIdentifier().getValue());
            if (!queryWithCipherColumn && (plainColumn = encryptTable.get().findPlainColumn(each.getIdentifier().getValue())).isPresent()) {
                result.add(new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(plainColumn.get())));
                continue;
            }
            if (this.isColumnSegmentIncludedInLikeExpression(whereSegments, each)) {
                Optional<String> likeQueryColumn = encryptTable.get().findLikeQueryColumn(each.getIdentifier().getValue());
                if (likeQueryColumn.isPresent()) {
                    result.add(new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(likeQueryColumn.get())));
                    continue;
                }
                throw new UnsupportedEncryptSQLException("LIKE");
            }
            Optional<String> assistedQueryColumn = encryptTable.get().findAssistedQueryColumn(each.getIdentifier().getValue());
            SubstitutableColumnNameToken encryptColumnNameToken = assistedQueryColumn.map(columnName -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections((String)columnName))).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(((EncryptTable)encryptTable.get()).getCipherColumn(each.getIdentifier().getValue()))));
            result.add(encryptColumnNameToken);
        }
        return result;
    }

    private boolean isColumnSegmentIncludedInLikeExpression(Collection<WhereSegment> whereSegments, ColumnSegment targetColumnSegment) {
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractUtil.getAndPredicates((ExpressionSegment)each.getExpr());
            for (AndPredicate andPredicate : andPredicates) {
                boolean likeColumnSegment = this.isLikeColumnSegment(andPredicate, targetColumnSegment);
                if (!likeColumnSegment) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLikeColumnSegment(AndPredicate andPredicate, ColumnSegment targetColumnSegment) {
        for (ExpressionSegment each : andPredicate.getPredicates()) {
            if (!(each instanceof BinaryOperationExpression) || !((BinaryOperationExpression)each).getOperator().equalsIgnoreCase("LIKE") || !this.isSameColumnSegment(((BinaryOperationExpression)each).getLeft(), targetColumnSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameColumnSegment(ExpressionSegment columnSegment, ColumnSegment targetColumnSegment) {
        return columnSegment instanceof ColumnSegment && columnSegment.getStartIndex() == targetColumnSegment.getStartIndex() && columnSegment.getStopIndex() == targetColumnSegment.getStopIndex();
    }

    private Collection<ColumnProjection> createColumnProjections(String columnName) {
        return Collections.singletonList(new ColumnProjection(null, columnName, null));
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }

    @Override
    @Generated
    public void setEncryptRule(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

