/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.pojo;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;

public final class EncryptFunctionAssignmentToken
extends EncryptAssignmentToken {
    private final Collection<FunctionAssignment> assignments = new LinkedList<FunctionAssignment>();

    public EncryptFunctionAssignmentToken(int startIndex, int stopIndex) {
        super(startIndex, stopIndex);
    }

    public void addAssignment(String columnName, Object value) {
        this.assignments.add(new FunctionAssignment(columnName, value));
    }

    public Collection<FunctionAssignment> getAssignment() {
        return this.assignments;
    }

    public String toString() {
        return this.assignments.stream().map(FunctionAssignment::toString).collect(Collectors.joining(", "));
    }

    private static final class FunctionAssignment {
        private final String columnName;
        private final Object value;

        public String toString() {
            return String.format("%s = %s", this.columnName, this.toString(this.value));
        }

        private String toString(Object value) {
            return String.class == value.getClass() ? String.format("%s", value) : value.toString();
        }

        @Generated
        public FunctionAssignment(String columnName, Object value) {
            this.columnName = columnName;
            this.value = value;
        }
    }
}

