/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.encrypt.like.LikeEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.context.EncryptContextBuilder;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptAssistedQueryEncryptorNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptEncryptorNotFoundException;
import org.apache.shardingsphere.encrypt.exception.metadata.EncryptLikeQueryEncryptorNotFoundException;
import org.apache.shardingsphere.encrypt.rule.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.rule.identifier.scope.DatabaseRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ColumnContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;

public final class EncryptRule
implements DatabaseRule,
TableContainedRule,
ColumnContainedRule {
    private final RuleConfiguration configuration;
    private final Map<String, StandardEncryptAlgorithm> standardEncryptors = new LinkedHashMap<String, StandardEncryptAlgorithm>();
    private final Map<String, LikeEncryptAlgorithm> likeEncryptors = new LinkedHashMap<String, LikeEncryptAlgorithm>();
    private final Map<String, EncryptTable> tables = new LinkedHashMap<String, EncryptTable>();
    private final boolean queryWithCipherColumn;

    public EncryptRule(EncryptRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        ruleConfig.getEncryptors().forEach((key, value) -> this.putAllEncryptors((String)key, (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (String)value.getType(), (Properties)value.getProps())));
        ruleConfig.getTables().forEach(each -> this.tables.put(each.getName().toLowerCase(), new EncryptTable((EncryptTableRuleConfiguration)each)));
        this.queryWithCipherColumn = ruleConfig.isQueryWithCipherColumn();
    }

    private void putAllEncryptors(String encryptorName, EncryptAlgorithm algorithm) {
        if (algorithm instanceof StandardEncryptAlgorithm) {
            this.standardEncryptors.put(encryptorName, (StandardEncryptAlgorithm)algorithm);
        } else {
            this.likeEncryptors.put(encryptorName, (LikeEncryptAlgorithm)algorithm);
        }
    }

    public Optional<EncryptTable> findEncryptTable(String logicTable) {
        return Optional.ofNullable(this.tables.get(logicTable.toLowerCase()));
    }

    public Optional<EncryptColumn> findEncryptColumn(String logicTable, String columnName) {
        return this.findEncryptTable(logicTable).flatMap(optional -> optional.findEncryptColumn(columnName));
    }

    public Optional<StandardEncryptAlgorithm> findEncryptor(String logicTable, String logicColumn) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).findEncryptorName(logicColumn).map(this.standardEncryptors::get) : Optional.empty();
    }

    public Optional<StandardEncryptAlgorithm> findAssistedQueryEncryptor(String logicTable, String logicColumn) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).findAssistedQueryEncryptorName(logicColumn).map(this.standardEncryptors::get) : Optional.empty();
    }

    public Optional<LikeEncryptAlgorithm> findLikeQueryEncryptor(String logicTable, String logicColumn) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).findLikeQueryEncryptorName(logicColumn).map(this.likeEncryptors::get) : Optional.empty();
    }

    public List<Object> getEncryptValues(String databaseName, String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<StandardEncryptAlgorithm> encryptor = this.findEncryptor(logicTable, logicColumn);
        EncryptContext encryptContext = EncryptContextBuilder.build(databaseName, schemaName, logicTable, logicColumn);
        ShardingSpherePreconditions.checkState((boolean)encryptor.isPresent(), () -> new EncryptEncryptorNotFoundException(String.format("Can not find StandardEncryptAlgorithm by %s.%s.", logicTable, logicColumn)));
        return this.getEncryptValues(encryptor.get(), originalValues, encryptContext);
    }

    private List<Object> getEncryptValues(StandardEncryptAlgorithm encryptor, List<Object> originalValues, EncryptContext encryptContext) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            Object encryptValue = null == each ? null : encryptor.encrypt(each, encryptContext);
            result.add(encryptValue);
        }
        return result;
    }

    public String getCipherColumn(String logicTable, String logicColumn) {
        return this.tables.get(logicTable.toLowerCase()).getCipherColumn(logicColumn);
    }

    public Map<String, String> getLogicAndCipherColumns(String logicTable) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).getLogicAndCipherColumns() : Collections.emptyMap();
    }

    public Optional<String> findAssistedQueryColumn(String logicTable, String logicColumn) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).findAssistedQueryColumn(logicColumn) : Optional.empty();
    }

    public Optional<String> findLikeQueryColumn(String logicTable, String logicColumn) {
        String lowerCaseLogicTable = logicTable.toLowerCase();
        return this.tables.containsKey(lowerCaseLogicTable) ? this.tables.get(lowerCaseLogicTable).findLikeQueryColumn(logicColumn) : Optional.empty();
    }

    public Collection<String> getAssistedQueryColumns(String logicTable) {
        return this.tables.containsKey(logicTable.toLowerCase()) ? this.tables.get(logicTable.toLowerCase()).getAssistedQueryColumns() : Collections.emptyList();
    }

    public List<Object> getEncryptAssistedQueryValues(String databaseName, String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<StandardEncryptAlgorithm> encryptor = this.findAssistedQueryEncryptor(logicTable, logicColumn);
        EncryptContext encryptContext = EncryptContextBuilder.build(databaseName, schemaName, logicTable, logicColumn);
        ShardingSpherePreconditions.checkState((boolean)encryptor.isPresent(), () -> new EncryptAssistedQueryEncryptorNotFoundException(String.format("Can not find assist encryptor by %s.%s.", logicTable, logicColumn)));
        return this.getEncryptAssistedQueryValues(encryptor.get(), originalValues, encryptContext);
    }

    private List<Object> getEncryptAssistedQueryValues(StandardEncryptAlgorithm encryptor, List<Object> originalValues, EncryptContext encryptContext) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            result.add(null == each ? null : encryptor.encrypt(each, encryptContext));
        }
        return result;
    }

    public List<Object> getEncryptLikeQueryValues(String databaseName, String schemaName, String logicTable, String logicColumn, List<Object> originalValues) {
        Optional<LikeEncryptAlgorithm> encryptor = this.findLikeQueryEncryptor(logicTable, logicColumn);
        EncryptContext encryptContext = EncryptContextBuilder.build(databaseName, schemaName, logicTable, logicColumn);
        ShardingSpherePreconditions.checkState((boolean)encryptor.isPresent(), () -> new EncryptLikeQueryEncryptorNotFoundException(String.format("Can not find like encryptor by %s.%s.", logicTable, logicColumn)));
        return this.getEncryptLikeQueryValues(encryptor.get(), originalValues, encryptContext);
    }

    private List<Object> getEncryptLikeQueryValues(LikeEncryptAlgorithm encryptor, List<Object> originalValues, EncryptContext encryptContext) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object each : originalValues) {
            result.add(null == each ? null : encryptor.encrypt(each, encryptContext));
        }
        return result;
    }

    public Optional<String> findPlainColumn(String logicTable, String logicColumn) {
        Optional<String> originColumnName = this.findOriginColumnName(logicTable, logicColumn);
        return originColumnName.isPresent() && this.tables.containsKey(logicTable.toLowerCase()) ? this.tables.get(logicTable.toLowerCase()).findPlainColumn(originColumnName.get()) : Optional.empty();
    }

    public boolean isQueryWithCipherColumn(String logicTable, String logicColumn) {
        return this.findEncryptTable(logicTable).flatMap(encryptTable -> encryptTable.getQueryWithCipherColumn(logicColumn)).orElse(this.queryWithCipherColumn);
    }

    private Optional<String> findOriginColumnName(String logicTable, String logicColumn) {
        for (String each : this.tables.get(logicTable.toLowerCase()).getLogicColumns()) {
            if (!logicColumn.equalsIgnoreCase(each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public Collection<String> getTables() {
        return this.tables.keySet();
    }

    public String getType() {
        return EncryptRule.class.getSimpleName();
    }

    @Generated
    public RuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

