/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.CursorAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.context.cursor.CursorDefinition;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereExtractUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCursorStatement;

public final class CursorStatementContext
extends CommonSQLStatementContext<OpenGaussCursorStatement>
implements CursorAvailable,
TableAvailable,
WhereAvailable,
CursorDefinition {
    private final Collection<WhereSegment> whereSegments = new LinkedList<WhereSegment>();
    private final Collection<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
    private final TablesContext tablesContext = new TablesContext(this.getSimpleTableSegments(), this.getDatabaseType());
    private final SelectStatementContext selectStatementContext;

    public CursorStatementContext(Map<String, ShardingSphereDatabase> databases, List<Object> parameters, OpenGaussCursorStatement sqlStatement, String defaultDatabaseName) {
        super(sqlStatement);
        this.extractWhereSegments(this.whereSegments, sqlStatement.getSelect());
        ColumnExtractor.extractColumnSegments(this.columnSegments, this.whereSegments);
        this.selectStatementContext = new SelectStatementContext(databases, parameters, sqlStatement.getSelect(), defaultDatabaseName);
    }

    private Collection<SimpleTableSegment> getSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect(((OpenGaussCursorStatement)this.getSqlStatement()).getSelect());
        return tableExtractor.getRewriteTables();
    }

    private void extractWhereSegments(Collection<WhereSegment> whereSegments, SelectStatement select) {
        select.getWhere().ifPresent(whereSegments::add);
        whereSegments.addAll(WhereExtractUtil.getSubqueryWhereSegments((SelectStatement)select));
        whereSegments.addAll(WhereExtractUtil.getJoinWhereSegments((SelectStatement)select));
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getTables();
    }

    @Override
    public Optional<CursorNameSegment> getCursorName() {
        return Optional.of(((OpenGaussCursorStatement)this.getSqlStatement()).getCursorName());
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public SelectStatementContext getSelectStatementContext() {
        return this.selectStatementContext;
    }
}

