/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.event.AlterSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterSchemaStatementHandler;

public final class AlterSchemaStatementSchemaRefresher
implements MetaDataRefresher<AlterSchemaStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, AlterSchemaStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Optional<String> renameSchemaName = AlterSchemaStatementHandler.getRenameSchema((AlterSchemaStatement)sqlStatement).map(optional -> optional.getValue().toLowerCase());
        if (!renameSchemaName.isPresent()) {
            return Optional.empty();
        }
        String actualSchemaName = sqlStatement.getSchemaName().getValue().toLowerCase();
        this.putSchemaMetaData(database, actualSchemaName, renameSchemaName.get(), logicDataSourceNames);
        this.removeSchemaMetaData(database, actualSchemaName);
        AlterSchemaEvent event = new AlterSchemaEvent(database.getName(), actualSchemaName, renameSchemaName.get(), database.getSchema(renameSchemaName.get()));
        return Optional.of(event);
    }

    private void removeSchemaMetaData(ShardingSphereDatabase database, String schemaName) {
        ShardingSphereSchema schema = new ShardingSphereSchema(database.getSchema(schemaName).getTables());
        database.removeSchema(schemaName);
        Collection rules = database.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (String each : schema.getAllTableNames()) {
            this.removeDataNode(rules, schemaName, each);
        }
    }

    private void removeDataNode(Collection<MutableDataNodeRule> rules, String schemaName, String tableName) {
        for (MutableDataNodeRule each : rules) {
            each.remove(schemaName, tableName);
        }
    }

    private void putSchemaMetaData(ShardingSphereDatabase database, String schemaName, String renameSchemaName, Collection<String> logicDataSourceNames) {
        ShardingSphereSchema schema = database.getSchema(schemaName);
        database.putSchema(renameSchemaName, schema);
        Collection rules = database.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (String each : schema.getAllTableNames()) {
            if (this.containsInImmutableDataNodeContainedRule(each, database)) continue;
            this.putDataNode(rules, logicDataSourceNames.iterator().next(), renameSchemaName, each);
        }
    }

    private void putDataNode(Collection<MutableDataNodeRule> rules, String dataSourceName, String schemaName, String tableName) {
        for (MutableDataNodeRule each : rules) {
            each.put(dataSourceName, schemaName, tableName);
        }
    }

    private boolean containsInImmutableDataNodeContainedRule(String tableName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public String getType() {
        return AlterSchemaStatement.class.getName();
    }
}

