/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.exception.sql;

import java.sql.SQLException;
import org.apache.shardingsphere.infra.util.exception.ShardingSphereInsideException;
import org.apache.shardingsphere.infra.util.exception.sql.sqlstate.SQLState;

public abstract class ShardingSphereSQLException
extends ShardingSphereInsideException {
    private static final long serialVersionUID = -8238061892944243621L;
    private final String sqlState;
    private final int vendorCode;
    private final String reason;

    public ShardingSphereSQLException(SQLState sqlState, int vendorCode, String reason, String ... messageArguments) {
        this(sqlState.getValue(), vendorCode, reason, messageArguments);
    }

    public ShardingSphereSQLException(String sqlState, int vendorCode, String reason, String ... messageArguments) {
        this.sqlState = sqlState;
        this.vendorCode = vendorCode;
        this.reason = null == reason ? null : String.format(reason, messageArguments);
    }

    public final SQLException toSQLException() {
        return new SQLException(this.reason, this.sqlState, this.vendorCode);
    }
}

