/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.env.Environment;
import org.apache.shiro.guice.ShiroModule;
import org.apache.shiro.guice.web.FilterChainResolverProvider;
import org.apache.shiro.guice.web.GuiceShiroFilter;
import org.apache.shiro.guice.web.PathMatchingFilterProvider;
import org.apache.shiro.guice.web.WebGuiceEnvironment;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.env.WebEnvironment;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.apache.shiro.web.filter.authc.UserFilter;
import org.apache.shiro.web.filter.authz.HttpMethodPermissionFilter;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.apache.shiro.web.filter.authz.PortFilter;
import org.apache.shiro.web.filter.authz.RolesAuthorizationFilter;
import org.apache.shiro.web.filter.authz.SslFilter;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.session.NoSessionCreationFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;

public abstract class ShiroWebModule
extends ShiroModule {
    public static final Key<AnonymousFilter> ANON = Key.get(AnonymousFilter.class);
    public static final Key<FormAuthenticationFilter> AUTHC = Key.get(FormAuthenticationFilter.class);
    public static final Key<BasicHttpAuthenticationFilter> AUTHC_BASIC = Key.get(BasicHttpAuthenticationFilter.class);
    public static final Key<NoSessionCreationFilter> NO_SESSION_CREATION = Key.get(NoSessionCreationFilter.class);
    public static final Key<LogoutFilter> LOGOUT = Key.get(LogoutFilter.class);
    public static final Key<PermissionsAuthorizationFilter> PERMS = Key.get(PermissionsAuthorizationFilter.class);
    public static final Key<PortFilter> PORT = Key.get(PortFilter.class);
    public static final Key<HttpMethodPermissionFilter> REST = Key.get(HttpMethodPermissionFilter.class);
    public static final Key<RolesAuthorizationFilter> ROLES = Key.get(RolesAuthorizationFilter.class);
    public static final Key<SslFilter> SSL = Key.get(SslFilter.class);
    public static final Key<UserFilter> USER = Key.get(UserFilter.class);
    static final String NAME = "SHIRO";
    private final Map<String, FilterConfig<? extends Filter>[]> filterChains = new LinkedHashMap<String, FilterConfig<? extends Filter>[]>();
    private final ServletContext servletContext;

    public ShiroWebModule(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public static void bindGuiceFilter(Binder binder) {
        binder.install((Module)ShiroWebModule.guiceFilterModule());
    }

    public static void bindGuiceFilter(String pattern, Binder binder) {
        binder.install((Module)ShiroWebModule.guiceFilterModule(pattern));
    }

    public static ServletModule guiceFilterModule() {
        return ShiroWebModule.guiceFilterModule("/*");
    }

    public static ServletModule guiceFilterModule(final String pattern) {
        return new ServletModule(){

            protected void configureServlets() {
                this.filter(pattern, new String[0]).through(GuiceShiroFilter.class);
            }
        };
    }

    @Override
    protected final void configureShiro() {
        this.bindBeanType(TypeLiteral.get(ServletContext.class), Key.get(ServletContext.class, (Annotation)Names.named((String)NAME)));
        this.bind(Key.get(ServletContext.class, (Annotation)Names.named((String)NAME))).toInstance((Object)this.servletContext);
        this.bindWebSecurityManager((AnnotatedBindingBuilder<? super WebSecurityManager>)this.bind(WebSecurityManager.class));
        this.bindWebEnvironment((AnnotatedBindingBuilder<? super WebEnvironment>)this.bind(WebEnvironment.class));
        this.bind(GuiceShiroFilter.class).asEagerSingleton();
        this.expose(GuiceShiroFilter.class);
        this.configureShiroWeb();
        this.bind(FilterChainResolver.class).toProvider((Provider)new FilterChainResolverProvider(this.setupFilterChainConfigs()));
    }

    private Map<String, Key<? extends Filter>[]> setupFilterChainConfigs() {
        HashMap filterToPathToConfig = new HashMap();
        LinkedHashMap<String, Key<? extends Filter>[]> resultConfigMap = new LinkedHashMap<String, Key<? extends Filter>[]>();
        for (Map.Entry<String, FilterConfig<? extends Filter>[]> filterChain : this.filterChains.entrySet()) {
            String path = filterChain.getKey();
            ArrayList<Key<? extends Filter>> keysForPath = new ArrayList<Key<? extends Filter>>();
            for (int i = 0; i < filterChain.getValue().length; ++i) {
                FilterConfig<? extends Filter> filterConfig = filterChain.getValue()[i];
                Key<? extends Filter> key = filterConfig.getKey();
                String config = filterConfig.getConfigValue();
                if (filterToPathToConfig.get(key) == null) {
                    filterToPathToConfig.put(key, new HashMap());
                }
                ((Map)filterToPathToConfig.get(key)).put(path, config);
                if (StringUtils.hasText((String)config) && !PathMatchingFilter.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
                    throw new ConfigurationException("Config information requires a PathMatchingFilter - can't apply to " + key.getTypeLiteral().getRawType());
                }
                keysForPath.add(key);
            }
            resultConfigMap.put(path, keysForPath.toArray(new Key[keysForPath.size()]));
        }
        for (Key key : filterToPathToConfig.keySet()) {
            if (PathMatchingFilter.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
                this.bindPathMatchingFilter(this.castToPathMatching((Key<? extends Filter>)key), (Map)filterToPathToConfig.get(key));
                continue;
            }
            this.bind(key);
        }
        return resultConfigMap;
    }

    private <T extends PathMatchingFilter> void bindPathMatchingFilter(Key<T> filterKey, Map<String, String> configs) {
        this.bind(filterKey).toProvider(new PathMatchingFilterProvider<T>(filterKey, configs)).asEagerSingleton();
    }

    private Key<? extends PathMatchingFilter> castToPathMatching(Key<? extends Filter> key) {
        return key;
    }

    protected abstract void configureShiroWeb();

    @Override
    protected final void bindSecurityManager(AnnotatedBindingBuilder<? super SecurityManager> bind) {
        bind.to(WebSecurityManager.class);
    }

    protected void bindWebSecurityManager(AnnotatedBindingBuilder<? super WebSecurityManager> bind) {
        try {
            bind.toConstructor(DefaultWebSecurityManager.class.getConstructor(Collection.class)).asEagerSingleton();
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("This really shouldn't happen.  Either something has changed in Shiro, or there's a bug in ShiroModule.", (Throwable)e);
        }
    }

    @Override
    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
        bind.to(ServletContainerSessionManager.class).asEagerSingleton();
    }

    @Override
    protected final void bindEnvironment(AnnotatedBindingBuilder<Environment> bind) {
        bind.to(WebEnvironment.class);
    }

    protected void bindWebEnvironment(AnnotatedBindingBuilder<? super WebEnvironment> bind) {
        bind.to(WebGuiceEnvironment.class).asEagerSingleton();
    }

    protected final void addFilterChain(String pattern, Key<? extends Filter> key) {
        if (key instanceof FilterConfigKey) {
            this.addLegacyFilterChain(pattern, (FilterConfigKey)key);
        } else {
            this.addFilterChain(pattern, new FilterConfig(key, ""));
        }
    }

    protected final void addFilterChain(String pattern, FilterConfig<? extends Filter> ... filterConfigs) {
        this.filterChains.put(pattern, filterConfigs);
    }

    protected static <T extends Filter> FilterConfig<T> filterConfig(Key<T> baseKey, String configValue) {
        return new FilterConfig(baseKey, configValue);
    }

    protected static <T extends Filter> FilterConfig<T> filterConfig(Key<T> baseKey) {
        return ShiroWebModule.filterConfig(baseKey, "");
    }

    protected static <T extends Filter> FilterConfig<T> filterConfig(TypeLiteral<T> typeLiteral, String configValue) {
        return ShiroWebModule.filterConfig(Key.get(typeLiteral), configValue);
    }

    protected static <T extends Filter> FilterConfig<T> filterConfig(Class<T> type, String configValue) {
        return ShiroWebModule.filterConfig(Key.get(type), configValue);
    }

    static boolean isGuiceVersion3() {
        try {
            Class.forName("com.google.inject.multibindings.MapKey");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    private void addLegacyFilterChain(String pattern, FilterConfigKey filterConfigKey) {
        FilterConfig filterConfig = new FilterConfig(filterConfigKey.getKey(), filterConfigKey.getConfigValue());
        this.addFilterChain(pattern, filterConfig);
    }

    @Deprecated
    protected final void addFilterChain(String pattern, Key<? extends Filter> ... keys) {
        FilterConfig[] filterConfigs = new FilterConfig[keys.length];
        for (int ii = 0; ii < keys.length; ++ii) {
            Key<? extends Filter> key = keys[ii];
            if (key instanceof FilterConfigKey) {
                FilterConfigKey legacyKey = (FilterConfigKey)key;
                filterConfigs[ii] = new FilterConfig(legacyKey.getKey(), legacyKey.getConfigValue());
                continue;
            }
            filterConfigs[ii] = new FilterConfig(key, "");
        }
        this.filterChains.put(pattern, filterConfigs);
    }

    @Deprecated
    protected static <T extends PathMatchingFilter> Key<T> config(Key<T> baseKey, String configValue) {
        if (!ShiroWebModule.isGuiceVersion3()) {
            throw new ConfigurationException("Method ShiroWebModule.config(Key<? extends PathMatchingFilter>, String configValue), is not supported when using Guice 4+");
        }
        return new FilterConfigKey(baseKey, configValue);
    }

    @Deprecated
    protected static <T extends PathMatchingFilter> Key<T> config(TypeLiteral<T> typeLiteral, String configValue) {
        return ShiroWebModule.config(Key.get(typeLiteral), configValue);
    }

    @Deprecated
    protected static <T extends PathMatchingFilter> Key<T> config(Class<T> type, String configValue) {
        return ShiroWebModule.config(Key.get(type), configValue);
    }

    @Deprecated
    private static class FilterConfigKey<T extends PathMatchingFilter>
    extends Key<T> {
        private Key<T> key;
        private String configValue;

        private FilterConfigKey(Key<T> key, String configValue) {
            this.key = key;
            this.configValue = configValue;
        }

        public Key<T> getKey() {
            return this.key;
        }

        public String getConfigValue() {
            return this.configValue;
        }
    }

    public static class FilterConfig<T extends Filter> {
        private Key<T> key;
        private String configValue;

        private FilterConfig(Key<T> key, String configValue) {
            this.key = key;
            this.configValue = configValue;
        }

        public Key<T> getKey() {
            return this.key;
        }

        public String getConfigValue() {
            return this.configValue;
        }
    }
}

