/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;

public class ChunkedOutputFilter
implements OutputFilter {
    protected static final ByteChunk END_CHUNK = new ByteChunk();
    protected OutputBuffer buffer;
    protected final byte[] chunkLength = new byte[10];
    protected final ByteChunk chunkHeader = new ByteChunk();

    public ChunkedOutputFilter() {
        this.chunkLength[8] = 13;
        this.chunkLength[9] = 10;
    }

    @Override
    public int doWrite(ByteChunk chunk) throws IOException {
        int result = chunk.getLength();
        if (result <= 0) {
            return 0;
        }
        int pos = 7;
        for (int current = result; current > 0; current /= 16) {
            int digit = current % 16;
            this.chunkLength[pos--] = HexUtils.getHex(digit);
        }
        this.chunkHeader.setBytes(this.chunkLength, pos + 1, 9 - pos);
        this.buffer.doWrite(this.chunkHeader);
        this.buffer.doWrite(chunk);
        this.chunkHeader.setBytes(this.chunkLength, 8, 2);
        this.buffer.doWrite(this.chunkHeader);
        return result;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public long end() throws IOException {
        this.buffer.doWrite(END_CHUNK);
        return 0L;
    }

    @Override
    public void recycle() {
    }

    static {
        byte[] END_CHUNK_BYTES = new byte[]{48, 13, 10, 13, 10};
        END_CHUNK.setBytes(END_CHUNK_BYTES, 0, END_CHUNK_BYTES.length);
    }
}

