/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.toolkit;

import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.dromara.easyes.annotation.Distance;
import org.dromara.easyes.annotation.HighLight;
import org.dromara.easyes.annotation.IndexField;
import org.dromara.easyes.annotation.IndexId;
import org.dromara.easyes.annotation.IndexName;
import org.dromara.easyes.annotation.InnerIndexField;
import org.dromara.easyes.annotation.Join;
import org.dromara.easyes.annotation.MultiIndexField;
import org.dromara.easyes.annotation.Score;
import org.dromara.easyes.annotation.Settings;
import org.dromara.easyes.annotation.rely.DefaultNestedClass;
import org.dromara.easyes.annotation.rely.DefaultSettingsProvider;
import org.dromara.easyes.annotation.rely.FieldType;
import org.dromara.easyes.annotation.rely.IdType;
import org.dromara.easyes.annotation.rely.JoinField;
import org.dromara.easyes.annotation.rely.RefreshPolicy;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.common.utils.ArrayUtils;
import org.dromara.easyes.common.utils.Assert;
import org.dromara.easyes.common.utils.ClassUtils;
import org.dromara.easyes.common.utils.CollectionUtils;
import org.dromara.easyes.common.utils.FastJsonUtils;
import org.dromara.easyes.common.utils.ReflectionKit;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.core.biz.EntityFieldInfo;
import org.dromara.easyes.core.biz.EntityInfo;
import org.dromara.easyes.core.biz.HighLightParam;
import org.dromara.easyes.core.cache.BaseCache;
import org.dromara.easyes.core.cache.GlobalConfigCache;
import org.dromara.easyes.core.config.GlobalConfig;
import org.dromara.easyes.core.toolkit.IndexUtils;

public class EntityInfoHelper {
    private static final String GET_SETTINGS_METHOD = "getSettings";
    private static final Map<Class<?>, EntityInfo> ENTITY_INFO_CACHE = new ConcurrentHashMap();

    public static EntityInfo getEntityInfo(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        EntityInfo entityInfo = ENTITY_INFO_CACHE.get(ClassUtils.getUserClass(clazz));
        if (null != entityInfo) {
            return entityInfo;
        }
        for (Class<?> currentClass = clazz; null == entityInfo && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
            entityInfo = ENTITY_INFO_CACHE.get(ClassUtils.getUserClass(currentClass));
        }
        if (entityInfo != null) {
            ENTITY_INFO_CACHE.put(ClassUtils.getUserClass(clazz), entityInfo);
        }
        GlobalConfig globalConfig = GlobalConfigCache.getGlobalConfig();
        return EntityInfoHelper.initIndexInfo(globalConfig, clazz);
    }

    public static synchronized EntityInfo initIndexInfo(GlobalConfig globalConfig, Class<?> clazz) {
        EntityInfo entityInfo = ENTITY_INFO_CACHE.get(clazz);
        if (entityInfo != null) {
            return entityInfo;
        }
        entityInfo = new EntityInfo();
        EntityInfoHelper.initIndexName(clazz, globalConfig, entityInfo);
        EntityInfoHelper.initSettings(clazz, entityInfo);
        EntityInfoHelper.initIndexFields(clazz, globalConfig, entityInfo);
        EntityInfoHelper.initJoin(clazz, globalConfig, entityInfo);
        ENTITY_INFO_CACHE.put(clazz, entityInfo);
        return entityInfo;
    }

    private static void initJoin(Class<?> clazz, GlobalConfig globalConfig, EntityInfo entityInfo) {
        Join join = clazz.getAnnotation(Join.class);
        if (join == null || ArrayUtils.isEmpty((Object[])join.nodes())) {
            return;
        }
        boolean camelCase = globalConfig.getDbConfig().isMapUnderscoreToCamelCase();
        String joinFieldName = EntityInfoHelper.camelToUnderline(JoinField.class.getSimpleName(), camelCase);
        entityInfo.setJoinFieldName(joinFieldName);
        String joinAlias = StringUtils.isBlank((CharSequence)join.rootAlias()) ? clazz.getSimpleName() : join.rootAlias();
        String underlineJoinAlias = EntityInfoHelper.camelToUnderline(joinAlias, camelCase);
        entityInfo.setJoinAlias(underlineJoinAlias);
        entityInfo.setEagerGlobalOrdinals(join.eagerGlobalOrdinals());
        Map<String, Object> relationMap = entityInfo.getRelationMap();
        Arrays.stream(join.nodes()).forEach(child -> {
            String parentAlias = StringUtils.isBlank((CharSequence)child.parentAlias()) ? child.parentClass().getSimpleName().toLowerCase() : child.parentAlias();
            String underlineParentAlias = EntityInfoHelper.camelToUnderline(parentAlias, camelCase);
            List childAliases = ArrayUtils.isEmpty((Object[])child.childAliases()) ? Arrays.stream(child.childClasses()).map(Class::getSimpleName).map(i -> EntityInfoHelper.camelToUnderline(i.toLowerCase(), camelCase)).distinct().collect(Collectors.toList()) : Arrays.stream(child.childAliases()).map(i -> EntityInfoHelper.camelToUnderline(i, camelCase)).collect(Collectors.toList());
            List relation = childAliases.size() > BaseEsConstants.ONE ? childAliases : childAliases.get(BaseEsConstants.ZERO);
            relationMap.put(underlineParentAlias, relation);
            AtomicInteger index = new AtomicInteger(BaseEsConstants.ZERO);
            Arrays.stream(child.childClasses()).forEach(childClass -> {
                EntityInfo childEntityInfo = EntityInfoHelper.getEntityInfo(childClass);
                childEntityInfo.setChild(true);
                childEntityInfo.setIndexName(entityInfo.getIndexName());
                childEntityInfo.setJoinFieldName(joinFieldName);
                childEntityInfo.setParentJoinAlias(parentAlias);
                if (CollectionUtils.isNotEmpty(childEntityInfo.getFieldList())) {
                    entityInfo.getChildFieldList().addAll(childEntityInfo.getFieldList());
                }
                childEntityInfo.setJoinAlias((String)childAliases.get(index.getAndIncrement()));
            });
        });
    }

    public static void initIndexFields(Class<?> clazz, GlobalConfig globalConfig, EntityInfo entityInfo) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        List<Field> list = EntityInfoHelper.getAllFields(clazz);
        boolean isReadPK = false;
        boolean existsIndexId = EntityInfoHelper.isExistIndexId(list);
        ArrayList<EntityFieldInfo> fieldList = new ArrayList<EntityFieldInfo>();
        for (Field field : list) {
            if (!isReadPK && (isReadPK = existsIndexId ? EntityInfoHelper.initIndexIdWithAnnotation(dbConfig, entityInfo, field) : EntityInfoHelper.initIndexIdWithoutAnnotation(dbConfig, entityInfo, field)) || EntityInfoHelper.initIndexFieldWithAnnotation(dbConfig, fieldList, field, entityInfo, clazz)) continue;
            EntityInfoHelper.initIndexFieldWithoutAnnotation(dbConfig, fieldList, field, entityInfo, clazz);
        }
        entityInfo.setFieldList(fieldList);
        EntityInfoHelper.addSimplePropertyPreFilter(entityInfo, clazz);
        EntityInfoHelper.addExtraProcessor(entityInfo);
    }

    private static void addSimplePropertyPreFilter(EntityInfo entityInfo, Class<?> clazz) {
        ArrayList<SerializeFilter> preFilters = new ArrayList<SerializeFilter>();
        SimplePropertyPreFilter entityClassPreFilter = FastJsonUtils.getSimplePropertyPreFilter(clazz, entityInfo.getNotSerializeField());
        Optional.ofNullable(entityClassPreFilter).ifPresent(preFilters::add);
        List<SerializeFilter> valueFilters = EntityInfoHelper.getValueFilter(entityInfo, clazz);
        preFilters.addAll(valueFilters);
        entityInfo.getNestedNotSerializeField().forEach((k, v) -> Optional.ofNullable(FastJsonUtils.getSimplePropertyPreFilter((Class)k, (Set)v)).ifPresent(preFilters::add));
        EntityInfoHelper.addNameFilter(entityInfo, preFilters);
        entityInfo.getClassSimplePropertyPreFilterMap().putIfAbsent(clazz, preFilters);
        entityInfo.getNotSerializeField().clear();
        entityInfo.getNestedNotSerializeField().clear();
    }

    private static List<SerializeFilter> getValueFilter(EntityInfo entityInfo, Class<?> clazz) {
        ArrayList<SerializeFilter> serializeFilters = new ArrayList<SerializeFilter>();
        Map<String, String> dateFormatMap = entityInfo.getClassDateFormatMap().get(clazz);
        if (CollectionUtils.isEmpty(dateFormatMap)) {
            return serializeFilters;
        }
        Map<Class<?>, Map<String, String>> nestedClassColumnMappingMap = entityInfo.getNestedClassColumnMappingMap();
        ValueFilter serializeFilter = (object, name, value) -> {
            Map nestedColumnMappingMap = (Map)nestedClassColumnMappingMap.get(object.getClass());
            if (nestedColumnMappingMap != null) {
                Map<String, String> nestedDateFormatMap = entityInfo.getClassDateFormatMap().get(object.getClass());
                if (CollectionUtils.isEmpty(nestedDateFormatMap)) {
                    return value;
                }
                return EntityInfoHelper.formatDate(name, value, nestedColumnMappingMap, nestedDateFormatMap);
            }
            return EntityInfoHelper.formatDate(name, value, entityInfo.getColumnMappingMap(), dateFormatMap);
        };
        serializeFilters.add((SerializeFilter)serializeFilter);
        return serializeFilters;
    }

    private static void addExtraProcessor(EntityInfo entityInfo) {
        Map<String, String> columnMappingMap = entityInfo.getColumnMappingMap();
        Map<Class<?>, Map<String, String>> nestedClassColumnMappingMap = entityInfo.getNestedClassColumnMappingMap();
        ExtraProcessor extraProcessor = (object, key, value) -> {
            Map nestedColumnMappingMap = (Map)nestedClassColumnMappingMap.get(object.getClass());
            if (nestedColumnMappingMap != null) {
                EntityInfoHelper.invokeExtraProcessor(nestedColumnMappingMap, object, key, value, object.getClass());
            } else {
                EntityInfoHelper.invokeExtraProcessor(columnMappingMap, object, key, value, object.getClass());
            }
        };
        entityInfo.setExtraProcessor(extraProcessor);
    }

    private static void invokeExtraProcessor(Map<String, String> columnMappingMap, Object object, String key, Object value, Class<?> clazz) {
        Optional.ofNullable(columnMappingMap.get(key)).flatMap(realMethodName -> Optional.ofNullable(BaseCache.setterMethod(clazz, realMethodName))).ifPresent(method -> {
            try {
                method.invoke(object, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                EntityInfoHelper.reInvokeDate(object, value, method);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    private static void reInvokeDate(Object object, Object value, Method method) {
        if (value instanceof String) {
            String paramTypeName = method.getParameterTypes()[0].getSimpleName();
            Comparable<ChronoLocalDateTime<?>> parsed = null;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if (LocalDateTime.class.getSimpleName().equals(paramTypeName)) {
                parsed = LocalDateTime.parse(value.toString(), formatter);
            } else if (LocalDate.class.getSimpleName().equals(paramTypeName)) {
                parsed = LocalDate.parse(value.toString(), formatter);
            } else if (Date.class.getSimpleName().equals(paramTypeName)) {
                parsed = Date.from(LocalDateTime.parse(value.toString(), formatter).atZone(ZoneId.systemDefault()).toInstant());
            }
            try {
                method.invoke(object, parsed);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static void addNameFilter(EntityInfo entityInfo, List<SerializeFilter> preFilters) {
        Map<String, String> mappingColumnMap = entityInfo.getMappingColumnMap();
        Map<Class<?>, Map<String, String>> nestedClassMappingColumnMap = entityInfo.getNestedClassMappingColumnMap();
        if (!mappingColumnMap.isEmpty()) {
            NameFilter nameFilter = (object, name, value) -> {
                Map nestedMappingColumnMap = (Map)nestedClassMappingColumnMap.get(object.getClass());
                if (Objects.nonNull(nestedMappingColumnMap)) {
                    String nestedMappingColumn = (String)nestedMappingColumnMap.get(name);
                    if (Objects.equals(nestedMappingColumn, name)) {
                        return name;
                    }
                    return nestedMappingColumn;
                }
                String mappingColumn = (String)mappingColumnMap.get(name);
                if (Objects.equals(mappingColumn, name)) {
                    return name;
                }
                return mappingColumn;
            };
            preFilters.add((SerializeFilter)nameFilter);
        }
    }

    private static boolean initIndexFieldWithAnnotation(GlobalConfig.DbConfig dbConfig, List<EntityFieldInfo> fieldList, Field field, EntityInfo entityInfo, Class<?> clazz) {
        boolean hasAnnotation = false;
        if (field.isAnnotationPresent(IndexField.class) || field.isAnnotationPresent(MultiIndexField.class)) {
            EntityInfoHelper.initIndexFieldAnnotation(dbConfig, entityInfo, clazz, field, fieldList);
            hasAnnotation = true;
        }
        if (field.isAnnotationPresent(HighLight.class)) {
            EntityInfoHelper.initHighLightAnnotation(dbConfig, entityInfo, field, entityInfo.getMappingColumnMap(), null);
        }
        if (field.isAnnotationPresent(Score.class)) {
            entityInfo.setScoreField(field.getName());
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.setScoreDecimalPlaces(field.getAnnotation(Score.class).decimalPlaces());
            hasAnnotation = true;
        }
        if (field.isAnnotationPresent(Distance.class)) {
            Distance distance = field.getAnnotation(Distance.class);
            entityInfo.getDistanceFields().add(field.getName());
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.getDistanceDecimalPlaces().add(distance.decimalPlaces());
            hasAnnotation = true;
        }
        return hasAnnotation;
    }

    private static void initIndexFieldAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Class<?> clazz, Field field, List<EntityFieldInfo> fieldList) {
        MultiIndexField multiIndexField = field.getAnnotation(MultiIndexField.class);
        IndexField indexField = Optional.ofNullable(multiIndexField).map(MultiIndexField::mainIndexField).orElse(field.getAnnotation(IndexField.class));
        if (indexField.exist()) {
            String mappingColumn;
            EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, field, indexField);
            if (!StringUtils.isBlank((CharSequence)indexField.value().trim())) {
                entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), indexField.value());
                entityInfo.getColumnMappingMap().putIfAbsent(indexField.value(), field.getName());
                mappingColumn = indexField.value();
            } else {
                mappingColumn = EntityInfoHelper.initMappingColumnMapAndGet(dbConfig, entityInfo, field);
            }
            if (BaseEsConstants.MINUS_ONE.intValue() != indexField.scalingFactor()) {
                entityFieldInfo.setScalingFactor(indexField.scalingFactor());
            }
            String format = StringUtils.isBlank((CharSequence)indexField.dateFormat()) ? "yyyy-MM-dd HH:mm:ss" : indexField.dateFormat();
            EntityInfoHelper.initClassDateFormatMap(indexField.fieldType(), field.getName(), entityInfo, clazz, format);
            FieldType fieldType = FieldType.getByType((String)IndexUtils.getEsFieldType(indexField.fieldType(), field.getType().getSimpleName()));
            if (FieldType.KEYWORD.equals((Object)fieldType)) {
                entityFieldInfo.setIgnoreCase(indexField.ignoreCase());
            }
            if (indexField.ignoreAbove() > BaseEsConstants.ZERO) {
                entityFieldInfo.setIgnoreAbove(indexField.ignoreAbove());
            }
            if (indexField.dims() > BaseEsConstants.ZERO) {
                entityFieldInfo.setDims(indexField.dims());
            }
            entityFieldInfo.setMappingColumn(mappingColumn);
            entityFieldInfo.setAnalyzer(indexField.analyzer());
            entityFieldInfo.setSearchAnalyzer(indexField.searchAnalyzer());
            entityFieldInfo.setFieldType(fieldType);
            entityFieldInfo.setFieldData(indexField.fieldData());
            entityFieldInfo.setColumnType(field.getType().getSimpleName());
            entityInfo.getFieldTypeMap().putIfAbsent(field.getName(), fieldType.getType());
            InnerIndexField[] innerIndexFields = Optional.ofNullable(multiIndexField).map(MultiIndexField::otherIndexFields).orElse(null);
            EntityInfoHelper.processInnerField(innerIndexFields, entityFieldInfo);
            fieldList.add(entityFieldInfo);
            if (DefaultNestedClass.class != indexField.nestedClass()) {
                entityInfo.getPathClassMap().putIfAbsent(field.getName(), indexField.nestedClass());
                EntityInfoHelper.processNested(indexField.nestedClass(), dbConfig, entityInfo);
            }
        } else {
            entityInfo.getNotSerializeField().add(field.getName());
        }
    }

    private static void initHighLightAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field, Map<String, String> mappingColumnMap, Class<?> nestedClass) {
        String customField;
        String realHighLightField;
        HighLight highLight = field.getAnnotation(HighLight.class);
        String mappingField = highLight.mappingField();
        boolean skip = false;
        if (StringUtils.isBlank((CharSequence)mappingField)) {
            mappingField = field.getName();
            skip = true;
        }
        if (!skip) {
            if (nestedClass == null) {
                entityInfo.getNotSerializeField().add(mappingField);
            } else {
                Set nestedNotSerializeFieldSet = Optional.ofNullable(entityInfo.getNestedNotSerializeField().get(nestedClass)).orElse(new HashSet());
                nestedNotSerializeFieldSet.add(mappingField);
                entityInfo.getNestedNotSerializeField().put(nestedClass, nestedNotSerializeFieldSet);
            }
        }
        String string = realHighLightField = Objects.isNull(customField = mappingColumnMap.get(field.getName())) ? field.getName() : customField;
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            realHighLightField = StringUtils.camelToUnderline((String)realHighLightField);
        }
        EntityInfoHelper.addHighlightParam(entityInfo, nestedClass, highLight, realHighLightField, mappingField);
        MultiIndexField multiIndexField = field.getAnnotation(MultiIndexField.class);
        if (multiIndexField != null) {
            for (InnerIndexField innerIndexField : multiIndexField.otherIndexFields()) {
                EntityInfoHelper.addHighlightParam(entityInfo, nestedClass, highLight, realHighLightField + "." + innerIndexField.suffix(), mappingField);
            }
        }
    }

    private static void addHighlightParam(EntityInfo entityInfo, Class<?> nestedClass, HighLight highLight, String realHighLightField, String mappingField) {
        if (nestedClass == null) {
            entityInfo.getHighlightFieldMap().putIfAbsent(realHighLightField, mappingField);
        } else {
            Map nestedHighlightFieldMap = Optional.ofNullable(entityInfo.getNestedHighlightFieldMap().get(nestedClass)).orElse(new HashMap());
            nestedHighlightFieldMap.putIfAbsent(realHighLightField, mappingField);
            entityInfo.getNestedHighlightFieldMap().put(nestedClass, nestedHighlightFieldMap);
        }
        HighLightParam highlightParam = new HighLightParam();
        highlightParam.setFragmentSize(highLight.fragmentSize()).setPreTag(highLight.preTag()).setPostTag(highLight.postTag()).setHighLightField(realHighLightField).setHighLightType(highLight.highLightType()).setRequireFieldMatch(highLight.requireFieldMatch());
        if (BaseEsConstants.MINUS_ONE.intValue() != highLight.numberOfFragments() && highLight.numberOfFragments() > BaseEsConstants.ZERO) {
            highlightParam.setNumberOfFragments(highLight.numberOfFragments());
        }
        if (nestedClass == null) {
            entityInfo.getHighlightParams().add(highlightParam);
        } else {
            List nestedHighlightParams = Optional.ofNullable(entityInfo.getNestedHighLightParamsMap().get(nestedClass)).orElse(new ArrayList());
            nestedHighlightParams.add(highlightParam);
            entityInfo.getNestedHighLightParamsMap().put(nestedClass, nestedHighlightParams);
        }
    }

    private static void processNested(Class<?> nestedClass, GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo) {
        List<Field> allFields = EntityInfoHelper.getAllFields(nestedClass);
        HashMap mappingColumnMap = new HashMap(allFields.size());
        HashMap columnMappingMap = new HashMap(allFields.size());
        HashMap fieldTypeMap = new HashMap();
        ArrayList entityFieldInfoList = new ArrayList();
        HashSet notSerializedFields = new HashSet();
        allFields.forEach(field -> {
            FieldType fieldType;
            String mappingColumn;
            MultiIndexField multiIndexField;
            IndexField indexField;
            if (field.isAnnotationPresent(HighLight.class)) {
                EntityInfoHelper.initHighLightAnnotation(dbConfig, entityInfo, field, mappingColumnMap, nestedClass);
            }
            if (Objects.isNull(indexField = Optional.ofNullable(multiIndexField = field.getAnnotation(MultiIndexField.class)).map(MultiIndexField::mainIndexField).orElse(field.getAnnotation(IndexField.class)))) {
                Set notSerializeFields = Optional.ofNullable(entityInfo.getNestedNotSerializeField().get(nestedClass)).orElse(Collections.emptySet());
                if (notSerializeFields.contains(field.getName())) {
                    return;
                }
                mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
                EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, (Field)field);
                entityFieldInfo.setMappingColumn(mappingColumn);
                fieldType = FieldType.getByType((String)IndexUtils.getEsFieldType(FieldType.NONE, field.getType().getSimpleName()));
                entityFieldInfo.setFieldType(fieldType);
                entityFieldInfo.setColumnType(field.getType().getSimpleName());
                EntityInfoHelper.initClassDateFormatMap(fieldType, field.getName(), entityInfo, nestedClass, "yyyy-MM-dd HH:mm:ss");
                entityFieldInfoList.add(entityFieldInfo);
            } else if (indexField.exist()) {
                if (DefaultNestedClass.class != indexField.nestedClass()) {
                    entityInfo.getPathClassMap().putIfAbsent(field.getName(), indexField.nestedClass());
                    EntityInfoHelper.processNested(indexField.nestedClass(), dbConfig, entityInfo);
                }
                mappingColumn = StringUtils.isNotBlank((CharSequence)indexField.value().trim()) ? indexField.value() : EntityInfoHelper.getMappingColumn(dbConfig, field);
                EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, (Field)field, indexField);
                fieldType = FieldType.NONE.equals((Object)indexField.fieldType()) ? FieldType.KEYWORD_TEXT : indexField.fieldType();
                entityFieldInfo.setMappingColumn(mappingColumn);
                entityFieldInfo.setFieldType(fieldType);
                entityFieldInfo.setFieldData(indexField.fieldData());
                entityFieldInfo.setColumnType(fieldType.getType());
                entityFieldInfo.setAnalyzer(indexField.analyzer());
                entityFieldInfo.setSearchAnalyzer(indexField.searchAnalyzer());
                if (FieldType.KEYWORD.equals((Object)fieldType)) {
                    entityFieldInfo.setIgnoreCase(indexField.ignoreCase());
                }
                String format = StringUtils.isBlank((CharSequence)indexField.dateFormat()) ? "yyyy-MM-dd HH:mm:ss" : indexField.dateFormat();
                EntityInfoHelper.initClassDateFormatMap(indexField.fieldType(), field.getName(), entityInfo, nestedClass, format);
                if (BaseEsConstants.MINUS_ONE.intValue() != indexField.scalingFactor()) {
                    entityFieldInfo.setScalingFactor(indexField.scalingFactor());
                }
                if (indexField.dims() > BaseEsConstants.ZERO) {
                    entityFieldInfo.setDims(indexField.dims());
                }
                InnerIndexField[] innerIndexFields = Optional.ofNullable(multiIndexField).map(MultiIndexField::otherIndexFields).orElse(null);
                EntityInfoHelper.processInnerField(innerIndexFields, entityFieldInfo);
                entityFieldInfoList.add(entityFieldInfo);
            } else {
                mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
                fieldType = FieldType.KEYWORD_TEXT;
                notSerializedFields.add(field.getName());
            }
            columnMappingMap.putIfAbsent(mappingColumn, field.getName());
            mappingColumnMap.putIfAbsent(field.getName(), mappingColumn);
            fieldTypeMap.putIfAbsent(field.getName(), fieldType.getType());
        });
        entityInfo.getNestedNotSerializeField().putIfAbsent(nestedClass, notSerializedFields);
        entityInfo.getNestedClassColumnMappingMap().putIfAbsent(nestedClass, columnMappingMap);
        entityInfo.getNestedClassMappingColumnMap().putIfAbsent(nestedClass, mappingColumnMap);
        entityInfo.getNestedClassFieldTypeMap().putIfAbsent(nestedClass, fieldTypeMap);
        entityInfo.getNestedFieldListMap().put(nestedClass, entityFieldInfoList);
    }

    private static void processInnerField(InnerIndexField[] innerIndexFields, EntityFieldInfo entityFieldInfo) {
        if (ArrayUtils.isNotEmpty((Object[])innerIndexFields)) {
            ArrayList<EntityFieldInfo.InnerFieldInfo> innerFieldInfoList = new ArrayList<EntityFieldInfo.InnerFieldInfo>();
            Arrays.stream(innerIndexFields).forEach(innerField -> {
                Assert.notBlank((String)innerField.suffix(), (String)"The Annotation MultiIndexField.InnerIndexField.value must has text");
                EntityFieldInfo.InnerFieldInfo innerFieldInfo = new EntityFieldInfo.InnerFieldInfo();
                innerFieldInfo.setColumn(innerField.suffix());
                innerFieldInfo.setFieldType(innerField.fieldType());
                innerFieldInfo.setAnalyzer(innerField.analyzer());
                innerFieldInfo.setSearchAnalyzer(innerField.searchAnalyzer());
                if (innerField.ignoreAbove() > BaseEsConstants.ZERO) {
                    innerFieldInfo.setIgnoreAbove(innerField.ignoreAbove());
                }
                innerFieldInfoList.add(innerFieldInfo);
            });
            entityFieldInfo.setInnerFieldInfoList(innerFieldInfoList);
        }
    }

    private static void initIndexFieldWithoutAnnotation(GlobalConfig.DbConfig dbConfig, List<EntityFieldInfo> fieldList, Field field, EntityInfo entityInfo, Class<?> clazz) {
        boolean isNotSerializedField = entityInfo.getNotSerializeField().contains(field.getName());
        if (isNotSerializedField) {
            return;
        }
        EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, field);
        String mappingColumn = EntityInfoHelper.initMappingColumnMapAndGet(dbConfig, entityInfo, field);
        entityFieldInfo.setMappingColumn(mappingColumn);
        FieldType fieldType = FieldType.getByType((String)IndexUtils.getEsFieldType(FieldType.NONE, field.getType().getSimpleName()));
        if (FieldType.DATE.equals((Object)fieldType)) {
            Map<Class<?>, Map<String, String>> classDateFormatMap = entityInfo.getClassDateFormatMap();
            Map dateFormatMap = Optional.ofNullable(classDateFormatMap.get(clazz)).orElse(new HashMap());
            dateFormatMap.putIfAbsent(field.getName(), "yyyy-MM-dd HH:mm:ss");
            classDateFormatMap.putIfAbsent(clazz, dateFormatMap);
        }
        entityInfo.getFieldTypeMap().putIfAbsent(field.getName(), fieldType.getType());
        entityFieldInfo.setColumnType(field.getType().getSimpleName());
        fieldList.add(entityFieldInfo);
    }

    private static boolean initIndexIdWithAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        IndexId tableId = field.getAnnotation(IndexId.class);
        if (tableId != null) {
            if (IdType.NONE == tableId.type()) {
                entityInfo.setIdType(dbConfig.getIdType());
            } else {
                entityInfo.setIdType(tableId.type());
            }
            field.setAccessible(Boolean.TRUE);
            entityInfo.setClazz(field.getDeclaringClass()).setKeyField(field).setIdClass(field.getType()).setKeyProperty(field.getName());
            entityInfo.getNotSerializeField().add("id");
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), "id");
            return true;
        }
        return false;
    }

    private static boolean initIndexIdWithoutAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        String column = field.getName();
        if ("id".equalsIgnoreCase(column) || "_id".equals(column)) {
            field.setAccessible(Boolean.TRUE);
            entityInfo.setIdType(dbConfig.getIdType()).setKeyProperty(field.getName()).setKeyField(field).setIdClass(field.getType()).setClazz(field.getDeclaringClass());
            entityInfo.getNotSerializeField().add("id");
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), "id");
            return true;
        }
        return false;
    }

    public static boolean isExistIndexId(List<Field> list) {
        for (Field field : list) {
            IndexId tableId = field.getAnnotation(IndexId.class);
            if (tableId == null) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz));
    }

    private static void initIndexName(Class<?> clazz, GlobalConfig globalConfig, EntityInfo entityInfo) {
        String indexName;
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        IndexName table = clazz.getAnnotation(IndexName.class);
        String tableName = clazz.getSimpleName().toLowerCase(Locale.ROOT);
        String tablePrefix = dbConfig.getIndexPrefix();
        boolean tablePrefixEffect = true;
        if (Objects.isNull(table)) {
            indexName = tableName;
        } else {
            if (StringUtils.isNotBlank((CharSequence)table.value())) {
                indexName = table.value();
                if (StringUtils.isNotBlank((CharSequence)tablePrefix) && !table.keepGlobalPrefix()) {
                    tablePrefixEffect = false;
                }
            } else {
                indexName = tableName;
            }
            entityInfo.setAliasName(table.aliasName());
            RefreshPolicy refreshPolicy = table.refreshPolicy();
            if (RefreshPolicy.GLOBAL.equals((Object)refreshPolicy)) {
                refreshPolicy = dbConfig.getRefreshPolicy();
            }
            entityInfo.setRefreshPolicy(refreshPolicy);
        }
        String targetIndexName = indexName;
        if (StringUtils.isNotBlank((CharSequence)tablePrefix) && tablePrefixEffect) {
            targetIndexName = tablePrefix + targetIndexName;
        }
        entityInfo.setIndexName(targetIndexName);
    }

    private static void initSettings(Class<?> clazz, EntityInfo entityInfo) {
        Map settingsMap;
        Settings settings = clazz.getAnnotation(Settings.class);
        Optional.ofNullable(settings).ifPresent(i -> {
            entityInfo.getSettingsMap().put("index.number_of_replicas", i.replicasNum());
            entityInfo.getSettingsMap().put("index.number_of_shards", i.shardsNum());
            entityInfo.getSettingsMap().put("index.max_result_window", i.maxResultWindow());
            if (StringUtils.isNotBlank((CharSequence)i.refreshInterval())) {
                entityInfo.getSettingsMap().put("refresh_interval", i.refreshInterval());
            }
        });
        Class provider = settings == null ? DefaultSettingsProvider.class : settings.settingsProvider();
        Object instance = provider.getConstructor(new Class[0]).newInstance(new Object[0]);
        Method method = provider.getDeclaredMethod(GET_SETTINGS_METHOD, new Class[0]);
        Object invoke = method.invoke(instance, new Object[0]);
        if (invoke instanceof Map && CollectionUtils.isNotEmpty((Map)(settingsMap = (Map)invoke))) {
            settingsMap.forEach((k, v) -> entityInfo.getSettingsMap().putIfAbsent((String)k, v));
        }
    }

    private static String initMappingColumnMapAndGet(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        String mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
        entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), mappingColumn);
        entityInfo.getColumnMappingMap().putIfAbsent(mappingColumn, field.getName());
        return mappingColumn;
    }

    private static String getMappingColumn(GlobalConfig.DbConfig dbConfig, Field field) {
        String mappingColumn = field.getName();
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            mappingColumn = StringUtils.camelToUnderline((String)field.getName());
        }
        return mappingColumn;
    }

    private static String camelToUnderline(String origin, boolean camelCase) {
        if (camelCase) {
            origin = StringUtils.camelToUnderline((String)origin);
        }
        return origin;
    }

    private static void initClassDateFormatMap(FieldType fieldType, String fieldName, EntityInfo entityInfo, Class<?> clazz, String dateFormat) {
        if (FieldType.DATE.equals((Object)fieldType)) {
            Map<Class<?>, Map<String, String>> classDateFormatMap = entityInfo.getClassDateFormatMap();
            Map dateFormatMap = Optional.ofNullable(classDateFormatMap.get(clazz)).orElse(new HashMap());
            dateFormatMap.putIfAbsent(fieldName, dateFormat);
            classDateFormatMap.putIfAbsent(clazz, dateFormatMap);
        }
    }

    private static Object formatDate(String name, Object value, Map<String, String> columnMappingMap, Map<String, String> dateFormatMap) {
        return Optional.ofNullable(columnMappingMap.get(name)).flatMap(i -> Optional.ofNullable(dateFormatMap.get(i))).map(pattern -> {
            if (value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat((String)pattern);
                return sdf.format(value);
            }
            if (value instanceof LocalDate) {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern);
                return ((LocalDate)value).format(dtf);
            }
            if (value instanceof LocalDateTime) {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern);
                return ((LocalDateTime)value).format(dtf);
            }
            return value;
        }).orElse(value);
    }
}

