/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.toolkit;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dromara.easyes.annotation.rely.FieldType;
import org.dromara.easyes.common.params.SFunction;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.core.cache.GlobalConfigCache;
import org.dromara.easyes.core.config.GlobalConfig;

public class FieldUtils {
    public static <R> String getFieldName(R func) {
        String fieldName = FieldUtils.getFieldNameNotConvertId(func);
        if ("id".equals(fieldName)) {
            fieldName = "_id";
        }
        return fieldName;
    }

    public static <R> String getFieldNameNotConvertId(R func) {
        if (!(func instanceof SFunction)) {
            throw new RuntimeException("not support this type of column");
        }
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(func, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            return FieldUtils.resolveFieldName(getter);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String val(SFunction<T, ?> func) {
        try {
            String getter;
            if (func instanceof Proxy) {
                InvocationHandler handler = Proxy.getInvocationHandler(func);
                Field field = handler.getClass().getDeclaredField("val$target");
                field.setAccessible(Boolean.TRUE);
                MethodHandle dmh = (MethodHandle)field.get(handler);
                Executable executable = MethodHandles.reflectAs(Executable.class, dmh);
                getter = executable.getName();
            } else {
                Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(Boolean.TRUE);
                SerializedLambda serializedLambda = (SerializedLambda)method.invoke(func, new Object[0]);
                getter = serializedLambda.getImplMethodName();
            }
            return FieldUtils.resolveFieldName(getter);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            throw new RuntimeException("no get method found!");
        }
    }

    public static String resolveFieldName(String getMethodName) {
        if (getMethodName.startsWith("get")) {
            getMethodName = getMethodName.substring(3);
        } else if (getMethodName.startsWith("is")) {
            getMethodName = getMethodName.substring(2);
        }
        return FieldUtils.firstToLowerCase(getMethodName);
    }

    public static String generateGetFunctionName(String fieldName) {
        return "get" + FieldUtils.firstToUpperCase(fieldName);
    }

    public static String generateSetFunctionName(String fieldName) {
        return "set" + FieldUtils.firstToUpperCase(fieldName);
    }

    private static String firstToLowerCase(String param) {
        if (Objects.isNull(param) || "".equals(param)) {
            return "";
        }
        return param.substring(0, 1).toLowerCase() + param.substring(1);
    }

    public static String firstToUpperCase(String param) {
        if (Objects.isNull(param) || "".equals(param)) {
            return "";
        }
        return param.substring(0, 1).toUpperCase() + param.substring(1);
    }

    public static String getRealField(String field, Map<String, String> mappingColumnMap) {
        String customField = mappingColumnMap.get(field);
        if (Objects.nonNull(customField)) {
            return "id".equals(customField) ? "_id" : customField;
        }
        GlobalConfig.DbConfig dbConfig = GlobalConfigCache.getGlobalConfig().getDbConfig();
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            return StringUtils.camelToUnderline((String)field);
        }
        return field;
    }

    public static String getRealFieldAndSuffix(String field, Map<String, String> fieldTypeMap, Map<String, String> mappingColumnMap) {
        boolean addSuffix;
        GlobalConfig.DbConfig dbConfig = GlobalConfigCache.getGlobalConfig().getDbConfig();
        String realField = FieldUtils.getRealField(field, mappingColumnMap);
        String fieldType = fieldTypeMap.get(field);
        boolean bl = addSuffix = dbConfig.isSmartAddKeywordSuffix() && FieldType.KEYWORD_TEXT.getType().equals(fieldType);
        if (addSuffix) {
            return realField + ".keyword";
        }
        return realField;
    }

    public static String getRealFieldNotConvertId(String field, Map<String, String> mappingColumnMap, boolean isMapUnderscoreToCamelCase) {
        String customField = mappingColumnMap.get(field);
        if (Objects.nonNull(customField)) {
            return customField;
        }
        if (isMapUnderscoreToCamelCase) {
            return StringUtils.camelToUnderline((String)field);
        }
        return field;
    }

    public static String[] getRealFields(String[] fields, Map<String, String> mappingColumnMap) {
        return Arrays.stream(fields).map(field -> FieldUtils.getRealField(field, mappingColumnMap)).collect(Collectors.toList()).toArray(new String[0]);
    }

    public static List<String> getRealFields(List<String> fields, Map<String, String> mappingColumnMap) {
        return Arrays.stream(FieldUtils.getRealFields(fields.toArray(new String[0]), mappingColumnMap)).collect(Collectors.toList());
    }

    private FieldUtils() {
    }
}

