/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.toolkit;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.dromara.easyes.annotation.rely.FieldType;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.common.enums.JdkDataTypeEnum;
import org.dromara.easyes.common.enums.ProcessIndexStrategyEnum;
import org.dromara.easyes.common.utils.CollectionUtils;
import org.dromara.easyes.common.utils.ExceptionUtils;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.common.utils.MyOptional;
import org.dromara.easyes.common.utils.NumericUtils;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.core.biz.CreateIndexParam;
import org.dromara.easyes.core.biz.EntityFieldInfo;
import org.dromara.easyes.core.biz.EntityInfo;
import org.dromara.easyes.core.biz.EsIndexInfo;
import org.dromara.easyes.core.biz.EsIndexParam;
import org.dromara.easyes.core.cache.GlobalConfigCache;
import org.dromara.easyes.core.config.GlobalConfig;
import org.dromara.easyes.core.toolkit.EntityInfoHelper;
import org.dromara.easyes.core.toolkit.LockUtils;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class IndexUtils {
    private static final String FIELDS_KEY = "fields";
    private static final int DEFAULT_IGNORE_ABOVE = 256;
    private static final String IGNORE_ABOVE_KEY = "ignore_above";
    private static final String CUSTOM = "custom";
    private static final String LOWERCASE = "lowercase";
    private static final String DIMS_KEY = "dims";
    private static final String EAGER_GLOBAL_ORDINALS = "eager_global_ordinals";

    public static boolean existsIndex(RestHighLevelClient client, String indexName) {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        try {
            return client.indices().exists(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"existsIndex exception indexName: %s", (Throwable)e, (Object[])new Object[]{indexName});
        }
    }

    public static boolean createIndex(RestHighLevelClient client, EntityInfo entityInfo, CreateIndexParam indexParam) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexParam.getIndexName());
        Map<String, Object> settingsMap = entityInfo.getSettingsMap();
        if (Objects.isNull(indexParam.getSettings())) {
            if (CollectionUtils.isNotEmpty(indexParam.getEsIndexParamList())) {
                indexParam.getEsIndexParamList().stream().filter(EsIndexParam::isIgnoreCase).findFirst().ifPresent(i -> {
                    settingsMap.put("index.analysis.normalizer.lowercase_normalizer.type", CUSTOM);
                    settingsMap.put("index.analysis.normalizer.lowercase_normalizer.filter", LOWERCASE);
                });
            }
            createIndexRequest.settings(settingsMap);
        } else {
            createIndexRequest.settings(indexParam.getSettings());
        }
        if (Objects.isNull(indexParam.getMapping())) {
            Map<String, Object> mapping = IndexUtils.initMapping(entityInfo, indexParam.getEsIndexParamList());
            createIndexRequest.mapping(mapping);
        } else {
            createIndexRequest.mapping(indexParam.getMapping());
        }
        Optional.ofNullable(indexParam.getAliasName()).ifPresent(aliasName -> {
            Alias alias = new Alias(aliasName);
            createIndexRequest.alias(alias);
        });
        try {
            CreateIndexResponse createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
            return createIndexResponse.isAcknowledged();
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"create index exception createIndexRequest: %s ", (Throwable)e, (Object[])new Object[]{createIndexRequest.toString()});
        }
    }

    public static boolean createEmptyIndex(RestHighLevelClient client, String indexName) {
        CreateIndexResponse createIndexResponse;
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        try {
            createIndexResponse = client.indices().create(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LogUtils.info((String[])new String[]{"===> distribute lock index has created"});
            return Boolean.TRUE;
        }
        return createIndexResponse.isAcknowledged();
    }

    public static EsIndexInfo getIndexInfo(RestHighLevelClient client, String indexName) {
        GetIndexResponse getIndexResponse = IndexUtils.getIndex(client, indexName);
        return IndexUtils.parseGetIndexResponse(getIndexResponse, indexName);
    }

    public static GetIndexResponse getIndex(RestHighLevelClient client, String indexName) {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        try {
            return client.indices().get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"getIndex exception indexName: %s", (Throwable)e, (Object[])new Object[]{indexName});
        }
    }

    public static void addDefaultAlias(RestHighLevelClient client, String indexName) {
        IndexUtils.addAliases(client, indexName, "ee_default_alias");
    }

    public static Boolean addAliases(RestHighLevelClient client, String indexName, String ... aliases) {
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasActions = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD);
        aliasActions.index(indexName);
        aliasActions.aliases(aliases);
        indicesAliasesRequest.addAliasAction(aliasActions);
        try {
            client.indices().updateAliases(indicesAliasesRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LogUtils.warn((String[])new String[]{"addDefaultAlias exception", e.toString()});
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean reindex(RestHighLevelClient client, String oldIndexName, String releaseIndexName, Integer maxResultWindow) {
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setSourceIndices(new String[]{oldIndexName});
        reindexRequest.setDestIndex(releaseIndexName);
        reindexRequest.setDestOpType("create");
        reindexRequest.setConflicts("proceed");
        reindexRequest.setRefresh(Boolean.TRUE.booleanValue());
        int reindexTimeOutHours = GlobalConfigCache.getGlobalConfig().getReindexTimeOutHours();
        reindexRequest.setTimeout(TimeValue.timeValueHours((long)reindexTimeOutHours));
        if (10000 > maxResultWindow) {
            reindexRequest.setSourceBatchSize(maxResultWindow.intValue());
        }
        try {
            BulkByScrollResponse response = client.reindex(reindexRequest, RequestOptions.DEFAULT);
            List bulkFailures = response.getBulkFailures();
            if (CollectionUtils.isEmpty((Collection)bulkFailures)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"reindex exception oldIndexName:%s, releaseIndexName: %s", (Throwable)e, (Object[])new Object[]{oldIndexName, releaseIndexName});
        }
    }

    public static EsIndexInfo parseGetIndexResponse(GetIndexResponse getIndexResponse, String indexName) {
        EsIndexInfo esIndexInfo = new EsIndexInfo();
        esIndexInfo.setHasDefaultAlias(Boolean.FALSE);
        Optional.ofNullable(getIndexResponse.getAliases()).flatMap(aliases -> Optional.ofNullable(aliases.get(indexName))).ifPresent(aliasMetadataList -> aliasMetadataList.forEach(aliasMetadata -> {
            if ("ee_default_alias".equals(aliasMetadata.alias())) {
                esIndexInfo.setHasDefaultAlias(Boolean.TRUE);
            }
        }));
        Optional.ofNullable(getIndexResponse.getSettings()).flatMap(settingsMap -> Optional.ofNullable(settingsMap.get(indexName))).ifPresent(p -> {
            String shardsNumStr = p.get("index.number_of_shards");
            Optional.ofNullable(shardsNumStr).ifPresent(s -> esIndexInfo.setShardsNum(Integer.parseInt(s)));
            String replicasNumStr = p.get("index.number_of_replicas");
            Optional.ofNullable(replicasNumStr).ifPresent(r -> esIndexInfo.setReplicasNum(Integer.parseInt(r)));
            String maxResultWindowStr = p.get("index.max_result_window");
            Optional.ofNullable(maxResultWindowStr).ifPresent(m -> esIndexInfo.setMaxResultWindow(Integer.parseInt(maxResultWindowStr)));
        });
        Optional.ofNullable(getIndexResponse.getMappings()).flatMap(stringMappingMetadataMap -> Optional.ofNullable(stringMappingMetadataMap.get(indexName)).flatMap(mappingMetadata -> Optional.ofNullable(mappingMetadata.getSourceAsMap()))).ifPresent(esIndexInfo::setMapping);
        return esIndexInfo;
    }

    public static String getEsFieldType(FieldType fieldType, String typeName) {
        String type;
        if (Objects.nonNull(fieldType) && !FieldType.NONE.equals((Object)fieldType)) {
            return fieldType.getType();
        }
        JdkDataTypeEnum jdkDataType = JdkDataTypeEnum.getByType((String)typeName.toLowerCase());
        switch (jdkDataType) {
            case BYTE: {
                type = FieldType.BYTE.getType();
                break;
            }
            case SHORT: {
                type = FieldType.SHORT.getType();
                break;
            }
            case INT: 
            case INTEGER: {
                type = FieldType.INTEGER.getType();
                break;
            }
            case LONG: {
                type = FieldType.LONG.getType();
                break;
            }
            case FLOAT: {
                type = FieldType.FLOAT.getType();
                break;
            }
            case DOUBLE: {
                type = FieldType.DOUBLE.getType();
                break;
            }
            case BIG_DECIMAL: {
                type = FieldType.SCALED_FLOAT.getType();
                break;
            }
            case STRING: 
            case CHAR: {
                type = FieldType.KEYWORD_TEXT.getType();
                break;
            }
            case BOOLEAN: {
                type = FieldType.BOOLEAN.getType();
                break;
            }
            case DATE: 
            case LOCAL_DATE: 
            case LOCAL_DATE_TIME: {
                type = FieldType.DATE.getType();
                break;
            }
            case LIST: {
                type = FieldType.TEXT.getType();
                break;
            }
            default: {
                return FieldType.KEYWORD_TEXT.getType();
            }
        }
        return type;
    }

    public static Map<String, Object> initMapping(EntityInfo entityInfo, List<EsIndexParam> indexParamList) {
        HashMap<String, Object> mapping = new HashMap<String, Object>(2);
        if (CollectionUtils.isEmpty(indexParamList)) {
            return mapping;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(indexParamList.size());
        GlobalConfig.DbConfig dbConfig = Optional.ofNullable(GlobalConfigCache.getGlobalConfig()).map(GlobalConfig::getDbConfig).orElse(new GlobalConfig.DbConfig());
        IndexUtils.initInfo(entityInfo, dbConfig, properties, indexParamList);
        if (CollectionUtils.isNotEmpty(entityInfo.getRelationMap())) {
            HashMap<String, Object> join = new HashMap<String, Object>();
            join.put("type", "join");
            join.put("relations", entityInfo.getRelationMap());
            join.put(EAGER_GLOBAL_ORDINALS, entityInfo.isEagerGlobalOrdinals());
            properties.put(entityInfo.getJoinFieldName(), join);
        }
        mapping.put("properties", properties);
        return mapping;
    }

    private static Map<String, Object> initInfo(EntityInfo entityInfo, GlobalConfig.DbConfig dbConfig, Map<String, Object> properties, List<EsIndexParam> indexParamList) {
        indexParamList.forEach(indexParam -> {
            boolean containsTextType;
            HashMap<String, Object> info = new HashMap<String, Object>();
            Optional.ofNullable(indexParam.getDateFormat()).ifPresent(format -> info.put("format", indexParam.getDateFormat()));
            if (indexParam.isIgnoreCase()) {
                info.put("normalizer", "lowercase_normalizer");
            }
            HashMap fieldsMap = null;
            if (FieldType.KEYWORD_TEXT.getType().equals(indexParam.getFieldType())) {
                info.put("type", FieldType.TEXT.getType());
                fieldsMap = new HashMap();
                HashMap<String, Object> keywordMap = new HashMap<String, Object>();
                keywordMap.put("type", FieldType.KEYWORD.getType());
                int ignoreAbove = Optional.ofNullable(indexParam.getIgnoreAbove()).orElse(DEFAULT_IGNORE_ABOVE);
                keywordMap.put(IGNORE_ABOVE_KEY, ignoreAbove);
                fieldsMap.put(FieldType.KEYWORD.getType(), keywordMap);
                info.put(FIELDS_KEY, fieldsMap);
            } else {
                info.put("type", indexParam.getFieldType());
            }
            boolean bl = containsTextType = FieldType.TEXT.getType().equals(indexParam.getFieldType()) || FieldType.KEYWORD_TEXT.getType().equals(indexParam.getFieldType());
            if (containsTextType) {
                Optional.ofNullable(indexParam.getAnalyzer()).ifPresent(analyzer -> info.put("analyzer", analyzer.toLowerCase()));
                Optional.ofNullable(indexParam.getSearchAnalyzer()).ifPresent(searchAnalyzer -> info.put("search_analyzer", searchAnalyzer.toLowerCase()));
                MyOptional.ofNullable((Object)indexParam.getFieldData()).ifTrue(fieldData -> info.put("fielddata", fieldData));
            }
            if (FieldType.SCALED_FLOAT.getType().equals(indexParam.getFieldType())) {
                Double scalingFactor = Optional.ofNullable(indexParam.getScalingFactor()).map(NumericUtils::formatNumberWithOneDecimal).orElse(BaseEsConstants.DEFAULT_SCALING_FACTOR);
                info.put("scaling_factor", scalingFactor);
            }
            if (FieldType.DENSE_VECTOR.getType().equals(indexParam.getFieldType())) {
                Optional.ofNullable(indexParam.getDims()).ifPresent(dims -> info.put(DIMS_KEY, dims));
            }
            Optional.ofNullable(indexParam.getBoost()).ifPresent(boost -> info.put("boost", indexParam.getBoost()));
            if (FieldType.NESTED.getType().equals(indexParam.getFieldType())) {
                List<EntityFieldInfo> nestedFields = entityInfo.getNestedFieldListMap().get(indexParam.getNestedClass());
                List<EsIndexParam> esIndexParams = IndexUtils.initIndexParam(entityInfo, indexParam.getNestedClass(), nestedFields);
                Map<String, Object> nested = IndexUtils.initInfo(entityInfo, dbConfig, new HashMap<String, Object>(), esIndexParams);
                info.put("properties", nested);
            }
            String fieldName = indexParam.getFieldName();
            if (dbConfig.isMapUnderscoreToCamelCase()) {
                fieldName = StringUtils.camelToUnderline((String)fieldName);
            }
            if (CollectionUtils.isNotEmpty(indexParam.getInnerFieldParamList())) {
                Map finalFieldsMap = Optional.ofNullable(fieldsMap).orElseGet(HashMap::new);
                indexParam.getInnerFieldParamList().forEach(innerFieldParam -> {
                    boolean innerContainsTextType;
                    HashMap<String, String> innerInfo = new HashMap<String, String>();
                    if (FieldType.KEYWORD_TEXT.getType().equals(innerFieldParam.getFieldType())) {
                        throw ExceptionUtils.eee((String)"The fieldType FieldType.KEYWORD_TEXT just for mainIndexField, can not be used in @InnerIndexField");
                    }
                    innerInfo.put("type", innerFieldParam.getFieldType());
                    boolean bl = innerContainsTextType = FieldType.TEXT.getType().equals(innerFieldParam.getFieldType()) || FieldType.KEYWORD_TEXT.getType().equals(innerFieldParam.getFieldType());
                    if (innerContainsTextType) {
                        Optional.ofNullable(innerFieldParam.getAnalyzer()).ifPresent(i -> innerInfo.put("analyzer", (String)i));
                        Optional.ofNullable(innerFieldParam.getSearchAnalyzer()).ifPresent(i -> innerInfo.put("search_analyzer", (String)i));
                    }
                    Optional.ofNullable(innerFieldParam.getIgnoreAbove()).ifPresent(i -> innerInfo.put(IGNORE_ABOVE_KEY, (String)((Object)innerFieldParam.getIgnoreAbove())));
                    finalFieldsMap.putIfAbsent(innerFieldParam.getColumn(), innerInfo);
                });
                info.put(FIELDS_KEY, finalFieldsMap);
            }
            properties.put(fieldName, info);
        });
        return properties;
    }

    public static boolean changeAliasAtomic(RestHighLevelClient client, String oldIndexName, String releaseIndexName) {
        IndicesAliasesRequest.AliasActions addIndexAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(releaseIndexName).alias("ee_default_alias");
        IndicesAliasesRequest.AliasActions removeAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(oldIndexName).alias("ee_default_alias");
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.addAliasAction(addIndexAction);
        indicesAliasesRequest.addAliasAction(removeAction);
        try {
            AcknowledgedResponse acknowledgedResponse = client.indices().updateAliases(indicesAliasesRequest, RequestOptions.DEFAULT);
            return acknowledgedResponse.isAcknowledged();
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"changeAlias exception oldIndexName: %s, releaseIndexName: %s", (Throwable)e, (Object[])new Object[]{oldIndexName, releaseIndexName});
        }
    }

    public static boolean deleteIndex(RestHighLevelClient client, String indexName) {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
        deleteIndexRequest.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        try {
            AcknowledgedResponse acknowledgedResponse = client.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT);
            return acknowledgedResponse.isAcknowledged();
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"deleteIndex exception indexName: %s", (Throwable)e, (Object[])new Object[]{indexName});
        }
    }

    public static CreateIndexParam getCreateIndexParam(EntityInfo entityInfo, Class<?> clazz) {
        List<EsIndexParam> esIndexParamList = IndexUtils.initIndexParam(entityInfo, clazz, entityInfo.getFieldList());
        if (CollectionUtils.isNotEmpty(entityInfo.getChildFieldList())) {
            List<EsIndexParam> childEsIndexParamList = IndexUtils.initIndexParam(entityInfo, clazz, entityInfo.getChildFieldList());
            esIndexParamList.addAll(childEsIndexParamList);
        }
        CreateIndexParam createIndexParam = new CreateIndexParam();
        createIndexParam.setEsIndexParamList(esIndexParamList);
        createIndexParam.setAliasName(entityInfo.getAliasName());
        createIndexParam.setShardsNum(entityInfo.getShardsNum());
        createIndexParam.setReplicasNum(entityInfo.getReplicasNum());
        createIndexParam.setIndexName(entityInfo.getIndexName());
        createIndexParam.setMaxResultWindow(entityInfo.getMaxResultWindow());
        Optional.ofNullable(entityInfo.getReleaseIndexName()).ifPresent(createIndexParam::setIndexName);
        Optional.ofNullable(entityInfo.getSettingsMap()).ifPresent(createIndexParam::setSettingsMap);
        return createIndexParam;
    }

    public static List<EsIndexParam> initIndexParam(EntityInfo entityInfo, Class<?> clazz, List<EntityFieldInfo> fieldList) {
        ArrayList<EntityFieldInfo> copyFieldList = new ArrayList<EntityFieldInfo>();
        copyFieldList.addAll(fieldList);
        ArrayList<EsIndexParam> esIndexParamList = new ArrayList<EsIndexParam>();
        if (CollectionUtils.isNotEmpty(copyFieldList)) {
            Map<String, String> dateFormatMap = entityInfo.getClassDateFormatMap().get(clazz);
            copyFieldList.forEach(field -> {
                EsIndexParam esIndexParam = new EsIndexParam();
                String esFieldType = IndexUtils.getEsFieldType(field.getFieldType(), field.getColumnType());
                esIndexParam.setFieldType(esFieldType);
                if (field.isFieldData()) {
                    esIndexParam.setFieldData(field.isFieldData());
                }
                esIndexParam.setFieldName(field.getMappingColumn());
                esIndexParam.setScalingFactor(field.getScalingFactor());
                esIndexParam.setDims(field.getDims());
                if (FieldType.NESTED.equals((Object)field.getFieldType())) {
                    esIndexParam.setNestedClass(entityInfo.getPathClassMap().get(field.getColumn()));
                }
                if (!"none".equals(field.getAnalyzer())) {
                    esIndexParam.setAnalyzer(field.getAnalyzer());
                }
                if (!"none".equals(field.getSearchAnalyzer()) && !Objects.equals(field.getAnalyzer(), field.getSearchAnalyzer())) {
                    esIndexParam.setSearchAnalyzer(field.getSearchAnalyzer());
                }
                esIndexParam.setIgnoreCase(field.isIgnoreCase());
                Optional.ofNullable(dateFormatMap).flatMap(i -> Optional.ofNullable(i.get(field.getColumn()))).ifPresent(esIndexParam::setDateFormat);
                List<EntityFieldInfo.InnerFieldInfo> innerFieldInfoList = field.getInnerFieldInfoList();
                if (CollectionUtils.isNotEmpty(innerFieldInfoList)) {
                    ArrayList<EsIndexParam.InnerFieldParam> innerFieldParamList = new ArrayList<EsIndexParam.InnerFieldParam>();
                    innerFieldInfoList.forEach(innerFieldInfo -> {
                        EsIndexParam.InnerFieldParam innerFieldParam = new EsIndexParam.InnerFieldParam();
                        innerFieldParam.setColumn(innerFieldInfo.getColumn());
                        if (!"none".equals(innerFieldInfo.getAnalyzer())) {
                            innerFieldParam.setAnalyzer(innerFieldInfo.getAnalyzer());
                        }
                        if (!"none".equals(innerFieldInfo.getSearchAnalyzer())) {
                            innerFieldParam.setSearchAnalyzer(innerFieldInfo.getSearchAnalyzer());
                        }
                        innerFieldParam.setFieldType(innerFieldInfo.getFieldType().getType());
                        innerFieldParamList.add(innerFieldParam);
                    });
                    esIndexParam.setInnerFieldParamList(innerFieldParamList);
                }
                esIndexParamList.add(esIndexParam);
            });
        }
        return esIndexParamList;
    }

    public static boolean isIndexNeedChange(EsIndexInfo esIndexInfo, EntityInfo entityInfo, Class<?> clazz) {
        Map<String, Object> mapping;
        List<EsIndexParam> esIndexParamList = IndexUtils.initIndexParam(entityInfo, clazz, entityInfo.getFieldList());
        if (CollectionUtils.isNotEmpty(entityInfo.getChildFieldList())) {
            List<EsIndexParam> childEsIndexParamList = IndexUtils.initIndexParam(entityInfo, clazz, entityInfo.getChildFieldList());
            esIndexParamList.addAll(childEsIndexParamList);
        }
        return !(mapping = IndexUtils.initMapping(entityInfo, esIndexParamList)).equals(esIndexInfo.getMapping());
    }

    public static boolean existsIndexWithRetryAndSetActiveIndex(EntityInfo entityInfo, RestHighLevelClient client) {
        boolean exists = IndexUtils.existsIndexWithRetry(entityInfo, client);
        Optional.ofNullable(entityInfo.getRetrySuccessIndexName()).ifPresent(entityInfo::setIndexName);
        return exists;
    }

    public static boolean existsIndexWithRetry(EntityInfo entityInfo, RestHighLevelClient client) {
        boolean exists = IndexUtils.existsIndex(client, entityInfo.getIndexName());
        if (exists) {
            entityInfo.setRetrySuccessIndexName(entityInfo.getIndexName());
            return true;
        }
        for (int i = 0; i <= 1; ++i) {
            String retryIndexName = entityInfo.getIndexName() + "_s" + i;
            exists = IndexUtils.existsIndex(client, retryIndexName);
            if (!exists) continue;
            entityInfo.setRetrySuccessIndexName(retryIndexName);
            break;
        }
        return exists;
    }

    public static void saveReleaseIndex(String releaseIndexName, RestHighLevelClient client) {
        IndexRequest indexRequest = new IndexRequest("ee-distribute-lock");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ee_active_index_key", (Object)releaseIndexName);
        jsonObject.put("gmt_modified", (Object)System.currentTimeMillis());
        indexRequest.source(jsonObject.toJSONString(), XContentType.JSON);
        try {
            client.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LogUtils.formatError((String)"saveReleaseIndex error, releaseIndexName:%s, e:%s", (Object[])new Object[]{releaseIndexName, e.toString()});
        }
    }

    public static void activeReleaseIndex(RestHighLevelClient client, Class<?> entityClass, int maxRetry) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"ee-distribute-lock"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.fetchField("ee_active_index_key");
        searchSourceBuilder.sort("gmt_modified", SortOrder.DESC);
        searchSourceBuilder.size(BaseEsConstants.ONE.intValue());
        searchRequest.source(searchSourceBuilder);
        SearchResponse response = null;
        try {
            response = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Throwable e) {
            LogUtils.warn((String[])new String[]{"Active failed, The machine that acquired lock is migrating, will try again later"});
        }
        AtomicBoolean activated = new AtomicBoolean(false);
        Optional.ofNullable(response).ifPresent(r -> Arrays.stream(r.getHits().getHits()).forEach(searchHit -> {
            Map sourceAsMap = searchHit.getSourceAsMap();
            Optional.ofNullable(sourceAsMap.get("ee_active_index_key")).ifPresent(indexName -> {
                if (indexName instanceof String) {
                    String releaseIndexName = (String)indexName;
                    EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
                    entityInfo.setIndexName(releaseIndexName);
                    entityInfo.getRelationClassMap().forEach((k, v) -> {
                        Optional.ofNullable(EntityInfoHelper.getEntityInfo(k)).ifPresent(i -> i.setIndexName(releaseIndexName));
                        if (CollectionUtils.isNotEmpty((Collection)v)) {
                            v.forEach(node -> Optional.ofNullable(EntityInfoHelper.getEntityInfo(node)).ifPresent(i -> i.setIndexName(releaseIndexName)));
                        }
                    });
                    activated.set(Boolean.TRUE);
                }
            });
        }));
        int activeReleaseIndexMaxRetry = GlobalConfigCache.getGlobalConfig().getActiveReleaseIndexMaxRetry();
        if (maxRetry >= activeReleaseIndexMaxRetry) {
            if (activated.get()) {
                LogUtils.info((String[])new String[]{"Current client index has been successfully activated"});
            } else {
                LogUtils.error((String[])new String[]{"Active release index failed after max number of retry, Please check whether the indexing of the first got lock client is successful"});
            }
            throw new RuntimeException();
        }
    }

    public static void supplyAsync(BiFunction<Class<?>, RestHighLevelClient, Boolean> biFunction, Class<?> entityClass, RestHighLevelClient client) {
        CompletionStage completableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            GlobalConfig globalConfig = GlobalConfigCache.getGlobalConfig();
            if (!globalConfig.isDistributed()) {
                return (Boolean)biFunction.apply(entityClass, client);
            }
            try {
                boolean lock = LockUtils.tryLock(client, entityClass.getSimpleName().toLowerCase(), BaseEsConstants.LOCK_MAX_RETRY);
                if (!lock) {
                    AtomicInteger maxTry = new AtomicInteger(BaseEsConstants.ZERO);
                    if (ProcessIndexStrategyEnum.SMOOTHLY.equals((Object)globalConfig.getProcessIndexMode())) {
                        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(() -> IndexUtils.activeReleaseIndex(client, entityClass, maxTry.addAndGet(BaseEsConstants.ONE)), 30L, globalConfig.getActiveReleaseIndexFixedDelay(), TimeUnit.SECONDS);
                    }
                    LogUtils.warn((String[])new String[]{"retry get distribute lock failed, please check whether other resources have been preempted or deadlocked"});
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                Boolean bl = (Boolean)biFunction.apply(entityClass, client);
                return bl;
            }
            finally {
                LockUtils.release(client, entityClass.getSimpleName().toLowerCase(), BaseEsConstants.LOCK_MAX_RETRY);
            }
        }).exceptionally(throwable -> {
            Optional.ofNullable(throwable).ifPresent(e -> {
                e.printStackTrace();
                LogUtils.error((String[])new String[]{"process index exception:", e.toString()});
            });
            return Boolean.FALSE;
        })).whenCompleteAsync((success, throwable) -> {
            if (success.booleanValue()) {
                LogUtils.info((String[])new String[]{"===> Congratulations auto process index by Easy-Es is done !"});
            } else {
                LogUtils.warn((String[])new String[]{"===> Unfortunately, auto process index by Easy-Es failed, please check your configuration"});
                Optional.ofNullable(EntityInfoHelper.getEntityInfo(entityClass).getReleaseIndexName()).ifPresent(releaseIndexName -> IndexUtils.deleteIndex(client, releaseIndexName));
            }
        });
        GlobalConfig globalConfig = GlobalConfigCache.getGlobalConfig();
        if (globalConfig.isAsyncProcessIndexBlocking()) {
            ((CompletableFuture)completableFuture).join();
        }
    }

    private IndexUtils() {
    }
}

