/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.conditions.function;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiPredicate;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.core.toolkit.FieldUtils;
import org.elasticsearch.index.query.Operator;

public interface Compare<Children, R>
extends Serializable {
    default public <V> Children allEq(Map<String, V> params) {
        return this.allEq(true, params);
    }

    public <V> Children allEq(boolean var1, Map<String, V> var2);

    default public <V> Children allEq(BiPredicate<String, V> filter, Map<String, V> params) {
        return this.allEq(true, filter, params);
    }

    public <V> Children allEq(boolean var1, BiPredicate<String, V> var2, Map<String, V> var3);

    default public Children eq(R column, Object val) {
        return this.eq(true, column, val);
    }

    default public Children eq(R column, Object val, Float boost) {
        return this.eq(true, column, val, boost);
    }

    default public Children eq(boolean condition, R column, Object val) {
        return this.eq(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children eq(String column, Object val) {
        return this.eq(true, column, val);
    }

    default public Children eq(String column, Object val, Float boost) {
        return this.eq(true, column, val, boost);
    }

    default public Children eq(boolean condition, String column, Object val) {
        return this.eq(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children eq(boolean condition, R column, Object val, Float boost) {
        return this.eq(condition, FieldUtils.getFieldName(column), val, boost);
    }

    public Children eq(boolean var1, String var2, Object var3, Float var4);

    default public Children match(R column, Object val) {
        return this.match(true, column, val);
    }

    default public Children match(R column, Object val, Float boost) {
        return this.match(true, column, val, boost);
    }

    default public Children match(boolean condition, R column, Object val) {
        return this.match(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children match(String column, Object val) {
        return this.match(true, column, val);
    }

    default public Children match(String column, Object val, Float boost) {
        return this.match(true, column, val, boost);
    }

    default public Children match(boolean condition, String column, Object val) {
        return this.match(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children match(boolean condition, R column, Object val, Float boost) {
        return this.match(condition, FieldUtils.getFieldName(column), val, boost);
    }

    public Children match(boolean var1, String var2, Object var3, Float var4);

    default public Children parentId(Object parentId, String type) {
        return this.parentId(true, parentId, type, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children parentId(boolean condition, Object parentId, String type) {
        return this.parentId(condition, parentId, type, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children parentId(Object parentId, String type, Float boost) {
        return this.parentId(true, parentId, type, boost);
    }

    public Children parentId(boolean var1, Object var2, String var3, Float var4);

    default public Children matchPhrase(R column, Object val) {
        return this.matchPhrase(true, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrase(boolean condition, R column, Object val) {
        return this.matchPhrase(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrase(R column, Object val, Float boost) {
        return this.matchPhrase(true, column, val, boost);
    }

    default public Children matchPhrase(String column, Object val) {
        return this.matchPhrase(true, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrase(boolean condition, String column, Object val) {
        return this.matchPhrase(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrase(String column, Object val, Float boost) {
        return this.matchPhrase(true, column, val, boost);
    }

    default public Children matchPhrase(boolean condition, R column, Object val, Float boost) {
        return this.matchPhrase(condition, FieldUtils.getFieldName(column), val, boost);
    }

    public Children matchPhrase(boolean var1, String var2, Object var3, Float var4);

    default public Children matchAllQuery() {
        return this.matchAllQuery(true, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchAllQuery(Float boost) {
        return this.matchAllQuery(true, boost);
    }

    default public Children matchAllQuery(boolean condition) {
        return this.matchAllQuery(condition, BaseEsConstants.DEFAULT_BOOST);
    }

    public Children matchAllQuery(boolean var1, Float var2);

    default public Children matchPhrasePrefixQuery(R column, Object val) {
        return this.matchPhrasePrefixQuery(true, column, val, 50, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrasePrefixQuery(boolean condition, R column, Object val) {
        return this.matchPhrasePrefixQuery(condition, column, val, 50, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrasePrefixQuery(R column, Object val, Float boost) {
        return this.matchPhrasePrefixQuery(true, column, val, 50, boost);
    }

    default public Children matchPhrasePrefixQuery(R column, Object val, int maxExpansions) {
        return this.matchPhrasePrefixQuery(true, column, val, maxExpansions, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrasePrefixQuery(R column, Object val, int maxExpansions, Float boost) {
        return this.matchPhrasePrefixQuery(true, column, val, maxExpansions, boost);
    }

    default public Children matchPhrasePrefixQuery(String column, Object val) {
        return this.matchPhrasePrefixQuery(true, column, val, 50, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrasePrefixQuery(boolean condition, String column, Object val) {
        return this.matchPhrasePrefixQuery(condition, column, val, 50, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrasePrefixQuery(String column, Object val, Float boost) {
        return this.matchPhrasePrefixQuery(true, column, val, 50, boost);
    }

    default public Children matchPhrasePrefixQuery(String column, Object val, int maxExpansions) {
        return this.matchPhrasePrefixQuery(true, column, val, maxExpansions, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children matchPhrasePrefixQuery(String column, Object val, int maxExpansions, Float boost) {
        return this.matchPhrasePrefixQuery(true, column, val, maxExpansions, boost);
    }

    default public Children matchPhrasePrefixQuery(boolean condition, R column, Object val, int maxExpansions, Float boost) {
        return this.matchPhrasePrefixQuery(condition, FieldUtils.getFieldName(column), val, maxExpansions, boost);
    }

    public Children matchPhrasePrefixQuery(boolean var1, String var2, Object var3, int var4, Float var5);

    default public Children multiMatchQuery(Object val, R ... columns) {
        return this.multiMatchQuery(true, val, columns);
    }

    default public Children multiMatchQuery(boolean condition, Object val, R ... columns) {
        return this.multiMatchQuery(condition, val, Operator.OR, 60, BaseEsConstants.DEFAULT_BOOST, columns);
    }

    default public Children multiMatchQuery(Object val, Float boost, R ... columns) {
        return this.multiMatchQuery(true, val, Operator.OR, 60, boost, columns);
    }

    default public Children multiMatchQuery(Object val, int minimumShouldMatch, R ... columns) {
        return this.multiMatchQuery(true, val, Operator.OR, minimumShouldMatch, BaseEsConstants.DEFAULT_BOOST, columns);
    }

    default public Children multiMatchQuery(Object val, Operator operator, int minimumShouldMatch, R ... columns) {
        return this.multiMatchQuery(true, val, operator, minimumShouldMatch, BaseEsConstants.DEFAULT_BOOST, columns);
    }

    default public Children multiMatchQuery(Object val, Operator operator, R ... columns) {
        return this.multiMatchQuery(true, val, operator, 60, BaseEsConstants.DEFAULT_BOOST, columns);
    }

    default public Children multiMatchQuery(Object val, int minimumShouldMatch, Float boost, R ... columns) {
        return this.multiMatchQuery(true, val, Operator.OR, minimumShouldMatch, boost, columns);
    }

    default public Children multiMatchQuery(Object val, Operator operator, Float boost, R ... columns) {
        return this.multiMatchQuery(true, val, operator, 60, boost, columns);
    }

    default public Children multiMatchQuery(Object val, Operator operator, int minimumShouldMatch, Float boost, R ... columns) {
        return this.multiMatchQuery(true, val, operator, minimumShouldMatch, boost, columns);
    }

    default public Children multiMatchQuery(Object val, String ... columns) {
        return this.multiMatchQuery(true, val, columns);
    }

    default public Children multiMatchQuery(boolean condition, Object val, String ... columns) {
        return this.multiMatchQuery(condition, val, Operator.OR, 60, BaseEsConstants.DEFAULT_BOOST, columns);
    }

    default public Children multiMatchQuery(Object val, Float boost, String ... columns) {
        return this.multiMatchQuery(true, val, Operator.OR, 60, boost, columns);
    }

    default public Children multiMatchQuery(Object val, int minimumShouldMatch, String ... columns) {
        return this.multiMatchQuery(true, val, Operator.OR, minimumShouldMatch, BaseEsConstants.DEFAULT_BOOST, columns);
    }

    default public Children multiMatchQuery(Object val, Operator operator, int minimumShouldMatch, String ... columns) {
        return this.multiMatchQuery(true, val, operator, minimumShouldMatch, BaseEsConstants.DEFAULT_BOOST, columns);
    }

    default public Children multiMatchQuery(Object val, Operator operator, String ... columns) {
        return this.multiMatchQuery(true, val, operator, 60, BaseEsConstants.DEFAULT_BOOST, columns);
    }

    default public Children multiMatchQuery(Object val, int minimumShouldMatch, Float boost, String ... columns) {
        return this.multiMatchQuery(true, val, Operator.OR, minimumShouldMatch, boost, columns);
    }

    default public Children multiMatchQuery(Object val, Operator operator, Float boost, String ... columns) {
        return this.multiMatchQuery(true, val, operator, 60, boost, columns);
    }

    default public Children multiMatchQuery(Object val, Operator operator, int minimumShouldMatch, Float boost, String ... columns) {
        return this.multiMatchQuery(true, val, operator, minimumShouldMatch, boost, columns);
    }

    default public Children multiMatchQuery(boolean condition, Object val, Operator operator, int minimumShouldMatch, Float boost, R ... columns) {
        String[] fields = (String[])Arrays.stream(columns).map(FieldUtils::getFieldName).toArray(String[]::new);
        return this.multiMatchQuery(condition, val, operator, minimumShouldMatch, boost, fields);
    }

    public Children multiMatchQuery(boolean var1, Object var2, Operator var3, int var4, Float var5, String ... var6);

    default public Children queryStringQuery(String queryString) {
        return this.queryStringQuery(true, queryString, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children queryStringQuery(String queryString, Float boost) {
        return this.queryStringQuery(true, queryString, boost);
    }

    public Children queryStringQuery(boolean var1, String var2, Float var3);

    default public Children prefixQuery(R column, String prefix) {
        return this.prefixQuery(true, column, prefix);
    }

    default public Children prefixQuery(boolean condition, R column, String prefix) {
        return this.prefixQuery(true, column, prefix, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children prefixQuery(R column, String prefix, Float boost) {
        return this.prefixQuery(true, column, prefix, boost);
    }

    default public Children prefixQuery(String column, String prefix) {
        return this.prefixQuery(true, column, prefix);
    }

    default public Children prefixQuery(boolean condition, String column, String prefix) {
        return this.prefixQuery(true, column, prefix, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children prefixQuery(String column, String prefix, Float boost) {
        return this.prefixQuery(true, column, prefix, boost);
    }

    default public Children prefixQuery(boolean condition, R column, String prefix, Float boost) {
        return this.prefixQuery(condition, FieldUtils.getFieldName(column), prefix, boost);
    }

    public Children prefixQuery(boolean var1, String var2, String var3, Float var4);

    default public Children gt(R column, Object val) {
        return this.gt(true, column, val);
    }

    default public Children gt(R column, Object val, Float boost) {
        return this.gt(true, column, val, boost);
    }

    default public Children gt(R column, Object val, ZoneId timeZone, String format) {
        return this.gt(true, column, val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children gt(R column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.gt(true, column, val, timeZone, format, boost);
    }

    default public Children gt(boolean condition, R column, Object val) {
        return this.gt(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children gt(String column, Object val) {
        return this.gt(true, column, val);
    }

    default public Children gt(String column, Object val, ZoneId timeZone, String format) {
        return this.gt(true, column, val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children gt(String column, Object val, Float boost) {
        return this.gt(true, column, val, boost);
    }

    default public Children gt(String column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.gt(true, column, val, timeZone, format, boost);
    }

    default public Children gt(boolean condition, String column, Object val) {
        return this.gt(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children gt(boolean condition, R column, Object val, Float boost) {
        return this.gt(condition, FieldUtils.getFieldName(column), val, boost);
    }

    default public Children gt(boolean condition, R column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.gt(condition, FieldUtils.getFieldName(column), val, timeZone, format, boost);
    }

    default public Children gt(boolean condition, String column, Object val, Float boost) {
        return this.gt(condition, column, val, (ZoneId)null, (String)null, boost);
    }

    public Children gt(boolean var1, String var2, Object var3, ZoneId var4, String var5, Float var6);

    default public Children ge(R column, Object val) {
        return this.ge(true, column, val);
    }

    default public Children ge(R column, Object val, ZoneId timeZone, String format) {
        return this.ge(true, FieldUtils.getFieldName(column), val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children ge(R column, Object val, Float boost) {
        return this.ge(true, column, val, boost);
    }

    default public Children ge(boolean condition, R column, Object val) {
        return this.ge(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children ge(String column, Object val, ZoneId timeZone, String format) {
        return this.ge(true, column, val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children ge(String column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.ge(true, column, val, timeZone, format, boost);
    }

    default public Children ge(String column, Object val) {
        return this.ge(true, column, val);
    }

    default public Children ge(String column, Object val, Float boost) {
        return this.ge(true, column, val, boost);
    }

    default public Children ge(boolean condition, String column, Object val) {
        return this.ge(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children ge(boolean condition, R column, Object val, Float boost) {
        return this.ge(condition, FieldUtils.getFieldName(column), val, boost);
    }

    default public Children ge(boolean condition, String column, Object val, Float boost) {
        return this.ge(condition, column, val, null, null, boost);
    }

    default public Children ge(boolean condition, String column, Object val, ZoneId timeZone, String format) {
        return this.ge(condition, column, val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    public Children ge(boolean var1, String var2, Object var3, ZoneId var4, String var5, Float var6);

    default public Children lt(R column, Object val) {
        return this.lt(true, column, val);
    }

    default public Children lt(R column, Object val, Float boost) {
        return this.lt(true, column, val, boost);
    }

    default public Children lt(R column, Object val, ZoneId timeZone, String format) {
        return this.lt(true, column, val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children lt(R column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.lt(true, column, val, timeZone, format, boost);
    }

    default public Children lt(boolean condition, R column, Object val) {
        return this.lt(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children lt(String column, Object val) {
        return this.lt(true, column, val);
    }

    default public Children lt(String column, Object val, Float boost) {
        return this.lt(true, (R)column, val, boost);
    }

    default public Children lt(String column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.lt(true, column, val, timeZone, format, boost);
    }

    default public Children lt(boolean condition, String column, Object val) {
        return this.lt(condition, (R)column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children lt(boolean condition, String column, Object val, Float boost) {
        return this.lt(condition, column, val, (ZoneId)null, (String)null, boost);
    }

    default public Children lt(boolean condition, R column, Object val, Float boost) {
        return this.lt(condition, FieldUtils.getFieldName(column), val, (ZoneId)null, (String)null, boost);
    }

    default public Children lt(boolean condition, R column, Object val, ZoneId timeZone, String format) {
        return this.lt(condition, FieldUtils.getFieldName(column), val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children lt(boolean condition, R column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.lt(condition, FieldUtils.getFieldName(column), val, timeZone, format, boost);
    }

    public Children lt(boolean var1, String var2, Object var3, ZoneId var4, String var5, Float var6);

    default public Children le(R column, Object val) {
        return this.le(true, column, val);
    }

    default public Children le(R column, Object val, Float boost) {
        return this.le(true, column, val, boost);
    }

    default public Children le(R column, Object val, ZoneId timeZone, String format) {
        return this.le(true, FieldUtils.getFieldName(column), val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children le(R column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.le(true, FieldUtils.getFieldName(column), val, timeZone, format, boost);
    }

    default public Children le(boolean condition, R column, Object val) {
        return this.le(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children le(boolean condition, R column, Object val, ZoneId timeZone, String format) {
        return this.le(condition, FieldUtils.getFieldName(column), val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children le(String column, Object val) {
        return this.le(true, column, val);
    }

    default public Children le(String column, Object val, Float boost) {
        return this.le(true, column, val, boost);
    }

    default public Children le(String column, Object val, ZoneId timeZone, String format) {
        return this.le(true, column, val, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children le(String column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.le(true, column, val, timeZone, format, boost);
    }

    default public Children le(boolean condition, String column, Object val) {
        return this.le(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children le(boolean condition, R column, Object val, Float boost) {
        return this.le(condition, FieldUtils.getFieldName(column), val, boost);
    }

    default public Children le(boolean condition, R column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.le(condition, FieldUtils.getFieldName(column), val, timeZone, format, boost);
    }

    default public Children le(boolean condition, String column, Object val, Float boost) {
        return this.le(condition, column, val, (ZoneId)null, (String)null, boost);
    }

    default public Children le(boolean condition, String column, Object val, ZoneId timeZone, String format) {
        return this.le(condition, column, val, timeZone, format, (Float)null);
    }

    public Children le(boolean var1, String var2, Object var3, ZoneId var4, String var5, Float var6);

    default public Children between(R column, Object from, Object to) {
        return this.between(true, column, from, to);
    }

    default public Children between(R column, Object from, Object to, Float boost) {
        return this.between(true, column, from, to, boost);
    }

    default public Children between(R column, Object from, Object to, ZoneId timeZone, String format) {
        return this.between(true, column, from, to, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children between(R column, Object from, Object to, ZoneId timeZone, String format, Float boost) {
        return this.between(true, column, from, to, timeZone, format, boost);
    }

    default public Children between(boolean condition, R column, Object from, Object to) {
        return this.between(condition, column, from, to, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children between(String column, Object from, Object to) {
        return this.between(true, column, from, to);
    }

    default public Children between(String column, Object from, Object to, Float boost) {
        return this.between(true, column, from, to, boost);
    }

    default public Children between(boolean condition, String column, Object from, Object to) {
        return this.between(condition, column, from, to, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children between(boolean condition, R column, Object from, Object to, Float boost) {
        return this.between(condition, FieldUtils.getFieldName(column), from, to, boost);
    }

    default public Children between(boolean condition, R column, Object from, Object to, ZoneId timeZone, String format) {
        return this.between(condition, FieldUtils.getFieldName(column), from, to, timeZone, format, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children between(boolean condition, R column, Object from, Object to, ZoneId timeZone, String format, Float boost) {
        return this.between(condition, FieldUtils.getFieldName(column), from, to, timeZone, format, boost);
    }

    default public Children between(boolean condition, String column, Object from, Object to, Float boost) {
        return this.between(condition, column, from, to, (ZoneId)null, (String)null, boost);
    }

    public Children between(boolean var1, String var2, Object var3, Object var4, ZoneId var5, String var6, Float var7);

    default public Children like(R column, Object val) {
        return this.like(true, column, val);
    }

    default public Children like(R column, Object val, Float boost) {
        return this.like(true, column, val, boost);
    }

    default public Children like(boolean condition, R column, Object val) {
        return this.like(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children like(String column, Object val) {
        return this.like(true, column, val);
    }

    default public Children like(String column, Object val, Float boost) {
        return this.like(true, column, val, boost);
    }

    default public Children like(boolean condition, String column, Object val) {
        return this.like(condition, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children like(boolean condition, R column, Object val, Float boost) {
        return this.like(condition, FieldUtils.getFieldName(column), val, boost);
    }

    public Children like(boolean var1, String var2, Object var3, Float var4);

    default public Children likeLeft(R column, Object val) {
        return this.likeLeft(true, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children likeLeft(R column, Object val, Float boost) {
        return this.likeLeft(true, column, val, boost);
    }

    default public Children likeLeft(String column, Object val) {
        return this.likeLeft(true, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children likeLeft(String column, Object val, Float boost) {
        return this.likeLeft(true, column, val, boost);
    }

    default public Children likeLeft(boolean condition, R column, Object val, Float boost) {
        return this.likeLeft(condition, FieldUtils.getFieldName(column), val, boost);
    }

    public Children likeLeft(boolean var1, String var2, Object var3, Float var4);

    default public Children likeRight(R column, Object val) {
        return this.likeRight(true, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children likeRight(R column, Object val, Float boost) {
        return this.likeRight(true, column, val, boost);
    }

    default public Children likeRight(String column, Object val) {
        return this.likeRight(true, column, val, BaseEsConstants.DEFAULT_BOOST);
    }

    default public Children likeRight(String column, Object val, Float boost) {
        return this.likeRight(true, column, val, boost);
    }

    default public Children likeRight(boolean condition, R column, Object val, Float boost) {
        return this.likeRight(condition, FieldUtils.getFieldName(column), val, boost);
    }

    public Children likeRight(boolean var1, String var2, Object var3, Float var4);
}

