/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.index;

import org.dromara.easyes.common.enums.ProcessIndexStrategyEnum;
import org.dromara.easyes.common.strategy.AutoProcessIndexStrategy;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.core.biz.CreateIndexParam;
import org.dromara.easyes.core.biz.EntityInfo;
import org.dromara.easyes.core.biz.EsIndexInfo;
import org.dromara.easyes.core.toolkit.EntityInfoHelper;
import org.dromara.easyes.core.toolkit.IndexUtils;
import org.elasticsearch.client.RestHighLevelClient;

public class AutoProcessIndexNotSmoothlyStrategy
implements AutoProcessIndexStrategy {
    public Integer getStrategyType() {
        return ProcessIndexStrategyEnum.NOT_SMOOTHLY.getStrategyType();
    }

    public void processIndexAsync(Class<?> entityClass, RestHighLevelClient client) {
        LogUtils.info((String[])new String[]{"===> Not smoothly process index mode activated"});
        IndexUtils.supplyAsync(this::process, entityClass, client);
    }

    private boolean process(Class<?> entityClass, RestHighLevelClient client) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
        boolean existsIndex = IndexUtils.existsIndexWithRetry(entityInfo, client);
        if (existsIndex) {
            LogUtils.info((String[])new String[]{"===> Index exists, automatically updating index by easy-es..."});
            return this.doUpdateIndex(entityInfo, entityClass, client);
        }
        LogUtils.info((String[])new String[]{"===> Index not exists, automatically creating index by easy-es..."});
        return this.doCreateIndex(entityInfo, entityClass, client);
    }

    private boolean doUpdateIndex(EntityInfo entityInfo, Class<?> clazz, RestHighLevelClient client) {
        EsIndexInfo esIndexInfo = IndexUtils.getIndexInfo(client, entityInfo.getRetrySuccessIndexName());
        boolean isIndexNeedChange = IndexUtils.isIndexNeedChange(esIndexInfo, entityInfo, clazz);
        if (!isIndexNeedChange) {
            LogUtils.info((String[])new String[]{"===> index has nothing changed"});
            entityInfo.setIndexName(entityInfo.getRetrySuccessIndexName());
            return Boolean.TRUE;
        }
        IndexUtils.deleteIndex(client, entityInfo.getRetrySuccessIndexName());
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam(entityInfo, clazz);
        return IndexUtils.createIndex(client, entityInfo, createIndexParam);
    }

    private boolean doCreateIndex(EntityInfo entityInfo, Class<?> clazz, RestHighLevelClient client) {
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam(entityInfo, clazz);
        return IndexUtils.createIndex(client, entityInfo, createIndexParam);
    }
}

