/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.index;

import org.dromara.easyes.common.enums.ProcessIndexStrategyEnum;
import org.dromara.easyes.common.strategy.AutoProcessIndexStrategy;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.core.biz.CreateIndexParam;
import org.dromara.easyes.core.biz.EntityInfo;
import org.dromara.easyes.core.biz.EsIndexInfo;
import org.dromara.easyes.core.toolkit.EntityInfoHelper;
import org.dromara.easyes.core.toolkit.IndexUtils;
import org.elasticsearch.client.RestHighLevelClient;

public class AutoProcessIndexSmoothlyStrategy
implements AutoProcessIndexStrategy {
    public Integer getStrategyType() {
        return ProcessIndexStrategyEnum.SMOOTHLY.getStrategyType();
    }

    public void processIndexAsync(Class<?> entityClass, RestHighLevelClient client) {
        LogUtils.info((String[])new String[]{"===> Smoothly process index mode activated"});
        IndexUtils.supplyAsync(this::process, entityClass, client);
    }

    private synchronized boolean process(Class<?> entityClass, RestHighLevelClient client) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
        boolean existsIndex = IndexUtils.existsIndexWithRetryAndSetActiveIndex(entityInfo, client);
        if (existsIndex) {
            LogUtils.info((String[])new String[]{"===> Index exists, automatically updating index by easy-es..."});
            return this.doUpdateIndex(entityInfo, entityClass, client);
        }
        LogUtils.info((String[])new String[]{"===> Index not exists, automatically creating index by easy-es..."});
        return this.doCreateIndex(entityInfo, entityClass, client);
    }

    private boolean doUpdateIndex(EntityInfo entityInfo, Class<?> clazz, RestHighLevelClient client) {
        boolean isIndexNeedChange;
        EsIndexInfo esIndexInfo = IndexUtils.getIndexInfo(client, entityInfo.getIndexName());
        if (!esIndexInfo.getHasDefaultAlias().booleanValue()) {
            IndexUtils.addDefaultAlias(client, entityInfo.getIndexName());
        }
        if (!(isIndexNeedChange = IndexUtils.isIndexNeedChange(esIndexInfo, entityInfo, clazz))) {
            LogUtils.info((String[])new String[]{"===> index has nothing changed"});
            return Boolean.TRUE;
        }
        String releaseIndexName = this.generateReleaseIndexName(entityInfo.getIndexName());
        entityInfo.setReleaseIndexName(releaseIndexName);
        boolean isCreateIndexSuccess = this.doCreateIndex(entityInfo, clazz, client);
        if (!isCreateIndexSuccess) {
            LogUtils.error((String[])new String[]{"create release index failed", "releaseIndex:" + releaseIndexName});
            return Boolean.FALSE;
        }
        boolean isDataMigrationSuccess = this.doDataMigration(entityInfo.getIndexName(), releaseIndexName, entityInfo.getMaxResultWindow(), client);
        if (!isDataMigrationSuccess) {
            LogUtils.error((String[])new String[]{"migrate data failed", "oldIndex:" + entityInfo.getIndexName(), "releaseIndex:" + releaseIndexName});
            return Boolean.FALSE;
        }
        boolean isChangeAliasSuccess = IndexUtils.changeAliasAtomic(client, entityInfo.getIndexName(), releaseIndexName);
        if (!isChangeAliasSuccess) {
            LogUtils.error((String[])new String[]{"change alias atomically failed", "oldIndex:" + entityInfo.getIndexName(), "releaseIndex:" + releaseIndexName});
            return Boolean.FALSE;
        }
        boolean isDeletedIndexSuccess = IndexUtils.deleteIndex(client, entityInfo.getIndexName());
        if (!isDeletedIndexSuccess) {
            LogUtils.error((String[])new String[]{"delete old index failed", "oldIndex:" + entityInfo.getIndexName()});
            return Boolean.FALSE;
        }
        entityInfo.setIndexName(releaseIndexName);
        IndexUtils.saveReleaseIndex(releaseIndexName, client);
        return Boolean.TRUE;
    }

    private String generateReleaseIndexName(String oldIndexName) {
        if (oldIndexName.endsWith("_s0")) {
            return oldIndexName.split("_s0")[0] + "_s1";
        }
        if (oldIndexName.endsWith("_s1")) {
            return oldIndexName.split("_s1")[0] + "_s0";
        }
        return oldIndexName + "_s0";
    }

    private boolean doDataMigration(String oldIndexName, String releaseIndexName, Integer maxResultWindow, RestHighLevelClient client) {
        return IndexUtils.reindex(client, oldIndexName, releaseIndexName, maxResultWindow);
    }

    private boolean doCreateIndex(EntityInfo entityInfo, Class<?> clazz, RestHighLevelClient client) {
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam(entityInfo, clazz);
        return IndexUtils.createIndex(client, entityInfo, createIndexParam);
    }
}

