/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.kernel;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.lucene.search.join.ScoreMode;
import org.dromara.easyes.annotation.rely.FieldType;
import org.dromara.easyes.common.enums.AggregationTypeEnum;
import org.dromara.easyes.common.enums.EsQueryTypeEnum;
import org.dromara.easyes.common.enums.OrderTypeEnum;
import org.dromara.easyes.common.utils.ArrayUtils;
import org.dromara.easyes.common.utils.Assert;
import org.dromara.easyes.common.utils.CollectionUtils;
import org.dromara.easyes.common.utils.ExceptionUtils;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.core.biz.AggregationParam;
import org.dromara.easyes.core.biz.BaseSortParam;
import org.dromara.easyes.core.biz.EntityFieldInfo;
import org.dromara.easyes.core.biz.EsIndexParam;
import org.dromara.easyes.core.biz.EsUpdateParam;
import org.dromara.easyes.core.biz.OrderByParam;
import org.dromara.easyes.core.biz.Param;
import org.dromara.easyes.core.conditions.function.Compare;
import org.dromara.easyes.core.conditions.function.Func;
import org.dromara.easyes.core.conditions.function.Geo;
import org.dromara.easyes.core.conditions.function.Index;
import org.dromara.easyes.core.conditions.function.Join;
import org.dromara.easyes.core.conditions.function.Nested;
import org.dromara.easyes.core.conditions.function.Query;
import org.dromara.easyes.core.conditions.function.Update;
import org.dromara.easyes.core.kernel.Wrapper;
import org.dromara.easyes.core.toolkit.EntityInfoHelper;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public abstract class AbstractWrapper<T, R, Children extends AbstractWrapper<T, R, Children>>
extends Wrapper<T>
implements Compare<Children, R>,
Nested<Children, Children>,
Func<Children, R>,
Join<Children>,
Geo<Children, R>,
Query<Children, T, R>,
Update<Children, R>,
Index<Children, R> {
    protected final Children typedThis = this;
    protected int level;
    protected String parentId;
    protected EsQueryTypeEnum prevQueryType;
    protected Stack<String> parentIdStack;
    protected LinkedList<EsQueryTypeEnum> prevQueryTypeQueue;

    public Children setEntity(T entity) {
        this.entity = entity;
        this.initEntityClass();
        return this.typedThis;
    }

    public Children setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
        this.initEntityClass();
        return this.typedThis;
    }

    protected void initEntityClass() {
        if (this.entityClass == null && this.entity != null) {
            this.entityClass = this.entity.getClass();
        }
    }

    protected Class<T> getCheckEntityClass() {
        Assert.notNull((Object)this.entityClass, (String)"entityClass must not null,please set entity before use this method!");
        return this.entityClass;
    }

    protected final void initNeed() {
        this.baseSortParams = new ArrayList();
        this.aggregationParamList = new ArrayList();
        this.paramQueue = new LinkedList();
        this.prevQueryType = EsQueryTypeEnum.NESTED_AND;
        this.parentIdStack = new Stack();
        this.prevQueryTypeQueue = new LinkedList();
    }

    @Override
    public <V> Children allEq(boolean condition, Map<String, V> params) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach(this::eq);
        }
        return this.typedThis;
    }

    @Override
    public <V> Children allEq(boolean condition, BiPredicate<String, V> filter, Map<String, V> params) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (filter.test((String)k, (Object)v) && StringUtils.checkValNotNull((Object)v)) {
                    this.eq((String)k, v);
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public Children eq(boolean condition, String column, Object val, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.TERM, column, val, boost);
    }

    @Override
    public Children and(boolean condition, Consumer<Children> consumer) {
        return this.addNested(condition, EsQueryTypeEnum.NESTED_AND, consumer);
    }

    @Override
    public Children or(boolean condition, Consumer<Children> consumer) {
        return this.addNested(condition, EsQueryTypeEnum.NESTED_OR, consumer);
    }

    @Override
    public Children or(boolean condition) {
        for (int i = this.paramQueue.size() - 1; i >= 0; --i) {
            Param param = (Param)this.paramQueue.get(i);
            if (!Objects.equals(this.level, param.getLevel())) continue;
            param.setPrevQueryType(EsQueryTypeEnum.NESTED_OR);
            break;
        }
        return this.addParam(condition, EsQueryTypeEnum.OR, null, null, null);
    }

    @Override
    public Children must(boolean condition, Consumer<Children> consumer) {
        return this.addNested(condition, EsQueryTypeEnum.NESTED_AND, consumer);
    }

    @Override
    public Children should(boolean condition, Consumer<Children> consumer) {
        return this.addNested(condition, EsQueryTypeEnum.NESTED_OR, consumer);
    }

    @Override
    public Children filter(boolean condition, Consumer<Children> consumer) {
        return this.addNested(condition, EsQueryTypeEnum.NESTED_FILTER, consumer);
    }

    @Override
    public Children filter(boolean condition) {
        return this.addParam(condition, EsQueryTypeEnum.FILTER, null, null, null);
    }

    @Override
    public Children not(boolean condition) {
        return this.addParam(condition, EsQueryTypeEnum.NOT, null, null, null);
    }

    @Override
    public Children not(boolean condition, Consumer<Children> consumer) {
        return this.addNested(condition, EsQueryTypeEnum.NESTED_NOT, consumer);
    }

    @Override
    public Children nested(boolean condition, String path, Consumer<Children> consumer, ScoreMode scoreMode) {
        return this.addNested(condition, path, scoreMode, consumer);
    }

    @Override
    public Children match(boolean condition, String column, Object val, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.MATCH, column, val, boost);
    }

    @Override
    public Children hasChild(boolean condition, String type, Consumer<Children> consumer, ScoreMode scoreMode) {
        return this.addJoin(condition, EsQueryTypeEnum.HAS_CHILD, type, scoreMode, consumer);
    }

    @Override
    public Children hasParent(boolean condition, String parentType, Consumer<Children> consumer, boolean score) {
        return this.addJoin(condition, EsQueryTypeEnum.HAS_PARENT, parentType, score, consumer);
    }

    @Override
    public Children parentId(boolean condition, Object parentId, String type, Float boost) {
        if (condition) {
            Assert.notNull((Object)parentId, (String)"parentId could not be null");
        }
        return this.addParam(condition, EsQueryTypeEnum.PARENT_ID, type, parentId, boost);
    }

    @Override
    public Children matchPhrase(boolean condition, String column, Object val, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.MATCH_PHRASE, column, val, boost);
    }

    @Override
    public Children matchAllQuery(boolean condition, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.MATCH_ALL, null, null, boost);
    }

    @Override
    public Children matchPhrasePrefixQuery(boolean condition, String column, Object val, int maxExpansions, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.MATCH_PHRASE_PREFIX, column, val, (Object)maxExpansions, null, boost);
    }

    @Override
    @SafeVarargs
    public final Children multiMatchQuery(boolean condition, Object val, Operator operator, int minimumShouldMatch, Float boost, String ... columns) {
        return this.addParam(condition, val, operator, minimumShouldMatch, boost, columns);
    }

    @Override
    public Children queryStringQuery(boolean condition, String queryString, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.QUERY_STRING, queryString, null, boost);
    }

    @Override
    public Children prefixQuery(boolean condition, String column, String prefix, Float boost) {
        if (condition) {
            Assert.notBlank((String)prefix, (String)"prefix can't be blank");
        }
        return this.addParam(condition, EsQueryTypeEnum.PREFIX, column, prefix, boost);
    }

    @Override
    public Children gt(boolean condition, String column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.GT, column, val, (Object)timeZone, (Object)format, boost);
    }

    @Override
    public Children ge(boolean condition, String column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.GE, column, val, (Object)timeZone, (Object)format, boost);
    }

    @Override
    public Children lt(boolean condition, String column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.LT, column, val, (Object)timeZone, (Object)format, boost);
    }

    @Override
    public Children le(boolean condition, String column, Object val, ZoneId timeZone, String format, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.LE, column, val, (Object)timeZone, (Object)format, boost);
    }

    @Override
    public Children between(boolean condition, String column, Object from, Object to, ZoneId timeZone, String format, Float boost) {
        return this.addParam(condition, column, from, to, (Object)timeZone, (Object)format, boost);
    }

    @Override
    public Children like(boolean condition, String column, Object val, Float boost) {
        val = Optional.ofNullable(val).map(v -> "*" + v + "*").orElse("*");
        return this.addParam(condition, EsQueryTypeEnum.WILDCARD, column, val, boost);
    }

    @Override
    public Children likeLeft(boolean condition, String column, Object val, Float boost) {
        val = Optional.ofNullable(val).map(v -> "*" + v).orElse("*");
        return this.addParam(condition, EsQueryTypeEnum.WILDCARD, column, val, boost);
    }

    @Override
    public Children likeRight(boolean condition, String column, Object val, Float boost) {
        val = Optional.ofNullable(val).map(v -> v + "*").orElse("*");
        return this.addParam(condition, EsQueryTypeEnum.WILDCARD, column, val, boost);
    }

    @Override
    public Children in(boolean condition, String column, Collection<?> coll, Float boost) {
        if (CollectionUtils.isEmpty(coll)) {
            return this.typedThis;
        }
        return this.addParam(condition, EsQueryTypeEnum.TERMS, column, coll, boost);
    }

    @Override
    public Children exists(boolean condition, String column, Float boost) {
        return this.addParam(condition, EsQueryTypeEnum.EXISTS, column, null, boost);
    }

    @Override
    public Children geoBoundingBox(boolean condition, String column, String topLeft, String bottomRight, Float boost) {
        if (condition) {
            Assert.notBlank((String)topLeft, (String)"TopLeft must not be null in geoBoundingBox query");
            Assert.notBlank((String)bottomRight, (String)"BottomRight must not be null in geoBoundingBox query");
            return (Children)this.geoBoundingBox(true, column, new GeoPoint(topLeft), new GeoPoint(bottomRight), boost);
        }
        return this.typedThis;
    }

    @Override
    public Children geoBoundingBox(boolean condition, String column, GeoPoint topLeft, GeoPoint bottomRight, Float boost) {
        if (condition) {
            Assert.notNull((Object)topLeft, (String)"TopLeft point must not be null in geoBoundingBox query");
            Assert.notNull((Object)bottomRight, (String)"BottomRight point must not be null in geoBoundingBox query");
        }
        return this.addParam(condition, EsQueryTypeEnum.GEO_BOUNDING_BOX, column, null, (Object)topLeft, (Object)bottomRight, boost);
    }

    @Override
    public Children geoDistance(boolean condition, String column, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint, Float boost) {
        if (condition) {
            Assert.notNull((Object)distance, (String)"Distance must not be null in geoDistance query");
            Assert.notNull((Object)distanceUnit, (String)"Distance unit must not be null in geoDistance query");
            Assert.notNull((Object)centralGeoPoint, (String)"CentralGeoPoint must not be null in geoDistance query");
        }
        return this.addParam(condition, EsQueryTypeEnum.GEO_DISTANCE, column, (Object)distance, (Object)distanceUnit, (Object)centralGeoPoint, boost);
    }

    @Override
    public Children geoDistance(boolean condition, String column, Double distance, DistanceUnit distanceUnit, String centralGeoPoint, Float boost) {
        if (condition) {
            Assert.notBlank((String)centralGeoPoint, (String)"centralGeoPoint must not be null in geoDistance query");
            return (Children)this.geoDistance(true, column, distance, distanceUnit, new GeoPoint(centralGeoPoint), boost);
        }
        return this.typedThis;
    }

    @Override
    public Children geoDistance(boolean condition, String column, String distance, GeoPoint centralGeoPoint, Float boost) {
        if (condition) {
            Assert.notBlank((String)distance, (String)"Distance must not be null in geoDistance query");
            Assert.notNull((Object)centralGeoPoint, (String)"CentralGeoPoint must not be null in geoDistance query");
        }
        return this.addParam(condition, EsQueryTypeEnum.GEO_DISTANCE, column, (Object)distance, null, (Object)centralGeoPoint, boost);
    }

    @Override
    public Children geoDistance(boolean condition, String column, String distance, String centralGeoPoint, Float boost) {
        if (condition) {
            Assert.notBlank((String)centralGeoPoint, (String)"centralGeoPoint must not be null in geoDistance query");
            return (Children)this.geoDistance(true, column, distance, new GeoPoint(centralGeoPoint), boost);
        }
        return this.typedThis;
    }

    @Override
    public Children geoPolygon(boolean condition, String column, List<GeoPoint> geoPoints, Float boost) {
        if (condition) {
            Assert.notEmpty(geoPoints, (String)"GeoPoints must not be null in geoPolygon query");
        }
        return this.addParam(condition, EsQueryTypeEnum.GEO_POLYGON, column, geoPoints, boost);
    }

    @Override
    public Children geoShape(boolean condition, String column, String indexedShapeId, Float boost) {
        if (condition) {
            Assert.notNull((Object)indexedShapeId, (String)"IndexedShapeId must not be null in geoShape query");
        }
        return this.addParam(condition, EsQueryTypeEnum.GEO_SHAPE_ID, column, indexedShapeId, boost);
    }

    @Override
    public Children geoShape(boolean condition, String column, Geometry geometry, ShapeRelation shapeRelation, Float boost) {
        if (condition) {
            Assert.notNull((Object)geometry, (String)"Geometry must not be null in geoShape query");
            Assert.notNull((Object)geometry, (String)"ShapeRelation must not be null in geoShape query");
        }
        return this.addParam(condition, EsQueryTypeEnum.GEO_SHAPE, column, (Object)geometry, (Object)shapeRelation, null, boost);
    }

    @Override
    public final Children orderBy(boolean condition, boolean isAsc, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        if (condition) {
            Arrays.stream(columns).forEach(column -> {
                BaseSortParam baseSortParam = BaseSortParam.builder().sortField((String)column).sortOrder(isAsc ? SortOrder.ASC : SortOrder.DESC).orderTypeEnum(OrderTypeEnum.FIELD).build();
                this.baseSortParams.add(baseSortParam);
            });
        }
        return this.typedThis;
    }

    @Override
    public Children orderBy(boolean condition, List<OrderByParam> orderByParams) {
        if (CollectionUtils.isNotEmpty(orderByParams)) {
            this.orderByParams = orderByParams;
        }
        return this.typedThis;
    }

    @Override
    public Children orderByDistanceAsc(boolean condition, String column, DistanceUnit unit, GeoDistance geoDistance, GeoPoint ... geoPoints) {
        if (ArrayUtils.isNotEmpty((Object[])geoPoints) && condition) {
            BaseSortParam baseSortParam = BaseSortParam.builder().sortField(column).sortOrder(SortOrder.ASC).orderTypeEnum(OrderTypeEnum.GEO).geoPoints(geoPoints).unit(unit).geoDistance(geoDistance).build();
            this.baseSortParams.add(baseSortParam);
        }
        return this.typedThis;
    }

    @Override
    public Children orderByDistanceDesc(boolean condition, String column, DistanceUnit unit, GeoDistance geoDistance, GeoPoint ... geoPoints) {
        if (ArrayUtils.isNotEmpty((Object[])geoPoints) && condition) {
            BaseSortParam baseSortParam = BaseSortParam.builder().sortField(column).sortOrder(SortOrder.DESC).orderTypeEnum(OrderTypeEnum.GEO).geoPoints(geoPoints).unit(unit).geoDistance(geoDistance).build();
            this.baseSortParams.add(baseSortParam);
        }
        return this.typedThis;
    }

    @Override
    public Children sort(boolean condition, List<SortBuilder<?>> sortBuilders) {
        if (CollectionUtils.isEmpty(sortBuilders)) {
            return this.typedThis;
        }
        if (condition) {
            sortBuilders.forEach(sortBuilder -> {
                BaseSortParam baseSortParam = BaseSortParam.builder().orderTypeEnum(OrderTypeEnum.CUSTOMIZE).sortBuilder((SortBuilder<?>)sortBuilder).build();
                this.baseSortParams.add(baseSortParam);
            });
        }
        return this.typedThis;
    }

    @Override
    public Children sortByScore(boolean condition, SortOrder sortOrder) {
        if (condition) {
            BaseSortParam baseSortParam = BaseSortParam.builder().sortOrder(sortOrder).orderTypeEnum(OrderTypeEnum.SCORE).build();
            this.baseSortParams.add(baseSortParam);
        }
        return this.typedThis;
    }

    @Override
    public final Children groupBy(boolean condition, boolean enablePipeline, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        Arrays.stream(columns).forEach(column -> this.doIt(condition, enablePipeline, AggregationTypeEnum.TERMS, (String)column));
        return this.typedThis;
    }

    @Override
    public Children termsAggregation(boolean condition, boolean enablePipeline, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        Arrays.stream(columns).forEach(column -> this.doIt(condition, enablePipeline, AggregationTypeEnum.TERMS, (String)column));
        return this.typedThis;
    }

    @Override
    public Children avg(boolean condition, boolean enablePipeline, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        Arrays.stream(columns).forEach(column -> this.doIt(condition, enablePipeline, AggregationTypeEnum.AVG, (String)column));
        return this.typedThis;
    }

    @Override
    public Children min(boolean condition, boolean enablePipeline, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        Arrays.stream(columns).forEach(column -> this.doIt(condition, enablePipeline, AggregationTypeEnum.MIN, (String)column));
        return this.typedThis;
    }

    @Override
    public Children max(boolean condition, boolean enablePipeline, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        Arrays.stream(columns).forEach(column -> this.doIt(condition, enablePipeline, AggregationTypeEnum.MAX, (String)column));
        return this.typedThis;
    }

    @Override
    public Children sum(boolean condition, boolean enablePipeline, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        Arrays.stream(columns).forEach(column -> this.doIt(condition, enablePipeline, AggregationTypeEnum.SUM, (String)column));
        return this.typedThis;
    }

    @Override
    public Children distinct(boolean condition, String column) {
        if (condition) {
            this.distinctField = column;
        }
        return this.typedThis;
    }

    @Override
    public Children from(Integer from) {
        this.from = from;
        return this.typedThis;
    }

    @Override
    public Children size(Integer size) {
        this.size = size;
        return this.typedThis;
    }

    @Override
    public Children limit(Integer m) {
        this.size = m;
        return this.typedThis;
    }

    @Override
    public Children limit(Integer m, Integer n) {
        this.from = m;
        this.size = n;
        return this.typedThis;
    }

    @Override
    public Children index(boolean condition, String ... indexNames) {
        if (condition) {
            if (ArrayUtils.isEmpty((Object[])indexNames)) {
                throw ExceptionUtils.eee((String)"indexNames can not be empty");
            }
            this.indexNames = indexNames;
        }
        return this.typedThis;
    }

    @Override
    public Children routing(boolean condition, String routing) {
        if (condition) {
            this.routing = routing;
        }
        return this.typedThis;
    }

    @Override
    public Children preference(boolean condition, String preference) {
        if (condition) {
            if (StringUtils.isBlank((CharSequence)preference)) {
                return this.typedThis;
            }
            this.preference = preference;
        }
        return this.typedThis;
    }

    @Override
    public Children setSearchSourceBuilder(boolean condition, SearchSourceBuilder searchSourceBuilder) {
        if (condition) {
            this.searchSourceBuilder = searchSourceBuilder;
        }
        return this.typedThis;
    }

    @Override
    public Children mix(boolean condition, QueryBuilder queryBuilder) {
        return this.addParam(condition, queryBuilder);
    }

    @Override
    public Children bucketOrder(boolean condition, List<BucketOrder> bucketOrders) {
        if (condition) {
            this.bucketOrders = bucketOrders;
        }
        return this.typedThis;
    }

    @Override
    public Children select(String ... columns) {
        this.include = columns;
        return this.typedThis;
    }

    @Override
    public Children select(Predicate<EntityFieldInfo> predicate) {
        return (Children)this.select(this.entityClass, (Predicate)predicate);
    }

    @Override
    public Children select(Class<T> entityClass, Predicate<EntityFieldInfo> predicate) {
        this.entityClass = entityClass;
        List<String> list = EntityInfoHelper.getEntityInfo(this.getCheckEntityClass()).chooseSelect(predicate);
        this.include = list.toArray(this.include);
        return this.typedThis;
    }

    @Override
    public Children minScore(Float score) {
        this.minScore = score;
        return this.typedThis;
    }

    @Override
    public Children trackScores() {
        this.trackScores = Boolean.TRUE;
        return this.typedThis;
    }

    @Override
    public Children notSelect(String ... columns) {
        this.exclude = columns;
        return this.typedThis;
    }

    @Override
    public Children set(boolean condition, String column, Object val) {
        if (condition) {
            EsUpdateParam esUpdateParam = new EsUpdateParam();
            esUpdateParam.setField(column);
            esUpdateParam.setValue(val);
            this.updateParamList.add(esUpdateParam);
        }
        return this.typedThis;
    }

    @Override
    public Children indexName(String ... indexNames) {
        if (ArrayUtils.isEmpty((Object[])indexNames)) {
            throw new RuntimeException("indexNames can not be empty");
        }
        this.indexNames = indexNames;
        return this.typedThis;
    }

    @Override
    public Children maxResultWindow(Integer maxResultWindow) {
        Optional.ofNullable(maxResultWindow).ifPresent(max -> {
            this.maxResultWindow = maxResultWindow;
        });
        return this.typedThis;
    }

    @Override
    public Children settings(Integer shards, Integer replicas) {
        if (Objects.nonNull(shards)) {
            this.shardsNum = shards;
        }
        if (Objects.nonNull(replicas)) {
            this.replicasNum = replicas;
        }
        return this.typedThis;
    }

    @Override
    public Children settings(Settings settings) {
        this.settings = settings;
        return this.typedThis;
    }

    @Override
    public Children mapping(Map<String, Object> mapping) {
        this.mapping = mapping;
        return this.typedThis;
    }

    @Override
    public Children mapping(String column, FieldType fieldType, String analyzer, String searchAnalyzer, String dateFormat, Boolean fieldData, Float boost) {
        this.addEsIndexParam(column, fieldType, analyzer, searchAnalyzer, dateFormat, fieldData, boost);
        return this.typedThis;
    }

    @Override
    public Children createAlias(String aliasName) {
        if (ArrayUtils.isEmpty((Object[])this.indexNames)) {
            throw new RuntimeException("indexNames can not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)aliasName)) {
            throw new RuntimeException("aliasName can not be empty");
        }
        this.aliasName = aliasName;
        return this.typedThis;
    }

    @Override
    public Children join(String column, String parentName, String childName) {
        EsIndexParam esIndexParam = new EsIndexParam();
        esIndexParam.setFieldName(column);
        esIndexParam.setFieldType(FieldType.JOIN.getType());
        this.esIndexParamList.add(esIndexParam);
        return this.typedThis;
    }

    protected abstract Children instance();

    private void addBaseParam(Param param, EsQueryTypeEnum queryTypeEnum, String column, Object val, Float boost) {
        param.setId(UUID.randomUUID().toString());
        Optional.ofNullable(this.parentId).ifPresent(param::setParentId);
        param.setPrevQueryType(this.prevQueryType);
        param.setQueryTypeEnum(queryTypeEnum);
        param.setVal(val);
        param.setColumn(column);
        param.setBoost(boost);
        param.setLevel(this.level);
        this.processJoin(param);
        this.paramQueue.add(param);
    }

    private void addBaseNested(Param param, EsQueryTypeEnum queryTypeEnum, Consumer<Children> consumer) {
        param.setId(UUID.randomUUID().toString());
        Optional.ofNullable(this.parentId).ifPresent(param::setParentId);
        param.setQueryTypeEnum(queryTypeEnum);
        param.setLevel(this.level);
        param.setPrevQueryType(queryTypeEnum);
        this.processJoin(param);
        this.paramQueue.add(param);
        this.parentId = param.getId();
        this.parentIdStack.push(this.parentId);
        ++this.level;
        consumer.accept(this.instance());
        --this.level;
        if (!this.parentIdStack.isEmpty()) {
            this.parentIdStack.pop();
            this.parentId = this.parentIdStack.isEmpty() ? null : this.parentIdStack.peek();
        }
    }

    private void processJoin(Param param) {
        if (!this.paramQueue.isEmpty()) {
            Param prev = (Param)this.paramQueue.peekLast();
            if (EsQueryTypeEnum.OR.equals((Object)prev.getQueryTypeEnum())) {
                param.setPrevQueryType(EsQueryTypeEnum.NESTED_OR);
            } else if (EsQueryTypeEnum.NOT.equals((Object)prev.getQueryTypeEnum())) {
                param.setPrevQueryType(EsQueryTypeEnum.NESTED_NOT);
            } else if (EsQueryTypeEnum.FILTER.equals((Object)prev.getPrevQueryType())) {
                param.setPrevQueryType(EsQueryTypeEnum.NESTED_FILTER);
            }
        }
    }

    private Children addParam(boolean condition, QueryBuilder queryBuilder) {
        if (condition) {
            Param param = new Param();
            param.setQueryBuilder(queryBuilder);
            this.addBaseParam(param, EsQueryTypeEnum.MIX, null, null, null);
        }
        return this.typedThis;
    }

    private Children addParam(boolean condition, EsQueryTypeEnum queryTypeEnum, String column, Object val, Float boost) {
        if (condition) {
            Param param = new Param();
            this.addBaseParam(param, queryTypeEnum, column, val, boost);
        }
        return this.typedThis;
    }

    private Children addParam(boolean condition, EsQueryTypeEnum queryTypeEnum, String column, Object val, Object var1, Object var2, Float boost) {
        if (condition) {
            Param param = new Param();
            param.setExt1(var1);
            param.setExt2(var2);
            this.addBaseParam(param, queryTypeEnum, column, val, boost);
        }
        return this.typedThis;
    }

    private Children addParam(boolean condition, String column, Object var1, Object var2, Object var3, Object var4, Float boost) {
        if (condition) {
            Assert.notNull((Object)var1, (String)"from must not be null in between query");
            Assert.notNull((Object)var2, (String)"to must not be null in between query");
            Param param = new Param();
            param.setExt1(var1);
            param.setExt2(var2);
            param.setExt3(var3);
            param.setExt4(var4);
            this.addBaseParam(param, EsQueryTypeEnum.BETWEEN, column, null, boost);
        }
        return this.typedThis;
    }

    private Children addParam(boolean condition, Object val, Operator operator, int minimumShouldMatch, Float boost, String ... columns) {
        if (condition) {
            Param param = new Param();
            param.setExt1(operator);
            param.setExt2(minimumShouldMatch);
            param.setColumns(columns);
            this.addBaseParam(param, EsQueryTypeEnum.MULTI_MATCH, null, val, boost);
        }
        return this.typedThis;
    }

    private Children addNested(boolean condition, EsQueryTypeEnum queryTypeEnum, Consumer<Children> consumer) {
        if (condition) {
            Param param = new Param();
            this.addBaseNested(param, queryTypeEnum, consumer);
        }
        return this.typedThis;
    }

    private Children addJoin(boolean condition, EsQueryTypeEnum queryTypeEnum, String path, Object ext, Consumer<Children> consumer) {
        if (condition) {
            Param param = new Param();
            param.setColumn(path);
            param.setVal(ext);
            this.addBaseNested(param, queryTypeEnum, consumer);
        }
        return this.typedThis;
    }

    private Children addNested(boolean condition, String path, ScoreMode scoreMode, Consumer<Children> consumer) {
        if (condition) {
            Param param = new Param();
            param.setColumn(path);
            param.setVal(scoreMode);
            this.addBaseNested(param, EsQueryTypeEnum.NESTED, consumer);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, boolean enablePipeline, AggregationTypeEnum aggregationTypeEnum, String column) {
        if (condition) {
            AggregationParam aggregationParam = new AggregationParam();
            aggregationParam.setEnablePipeline(enablePipeline);
            aggregationParam.setName(column);
            aggregationParam.setField(column);
            aggregationParam.setAggregationType(aggregationTypeEnum);
            this.aggregationParamList.add(aggregationParam);
        }
        return this.typedThis;
    }

    private void addEsIndexParam(String fieldName, FieldType fieldType, String analyzer, String searchAnalyzer, String dateFormat, Boolean fieldData, Float boost) {
        EsIndexParam esIndexParam = new EsIndexParam();
        esIndexParam.setFieldName(fieldName);
        esIndexParam.setFieldType(fieldType.getType());
        esIndexParam.setAnalyzer(analyzer);
        esIndexParam.setSearchAnalyzer(searchAnalyzer);
        esIndexParam.setDateFormat(dateFormat);
        esIndexParam.setFieldData(fieldData);
        esIndexParam.setBoost(boost);
        this.esIndexParamList.add(esIndexParam);
    }
}

