/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.kernel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.dromara.easyes.annotation.rely.FieldStrategy;
import org.dromara.easyes.annotation.rely.IdType;
import org.dromara.easyes.annotation.rely.JoinField;
import org.dromara.easyes.annotation.rely.RefreshPolicy;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.common.enums.MethodEnum;
import org.dromara.easyes.common.enums.OrderTypeEnum;
import org.dromara.easyes.common.property.GlobalConfig;
import org.dromara.easyes.common.utils.ArrayUtils;
import org.dromara.easyes.common.utils.Assert;
import org.dromara.easyes.common.utils.CollectionUtils;
import org.dromara.easyes.common.utils.ExceptionUtils;
import org.dromara.easyes.common.utils.FastJsonUtils;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.common.utils.NumericUtils;
import org.dromara.easyes.common.utils.ReflectionKit;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.core.biz.BaseSortParam;
import org.dromara.easyes.core.biz.CreateIndexParam;
import org.dromara.easyes.core.biz.EntityFieldInfo;
import org.dromara.easyes.core.biz.EntityInfo;
import org.dromara.easyes.core.biz.EsIndexParam;
import org.dromara.easyes.core.biz.EsPageInfo;
import org.dromara.easyes.core.biz.EsUpdateParam;
import org.dromara.easyes.core.biz.SAPageInfo;
import org.dromara.easyes.core.cache.BaseCache;
import org.dromara.easyes.core.cache.GlobalConfigCache;
import org.dromara.easyes.core.kernel.BaseEsMapper;
import org.dromara.easyes.core.kernel.Wrapper;
import org.dromara.easyes.core.kernel.WrapperProcessor;
import org.dromara.easyes.core.toolkit.EntityInfoHelper;
import org.dromara.easyes.core.toolkit.FieldUtils;
import org.dromara.easyes.core.toolkit.IndexUtils;
import org.dromara.easyes.core.toolkit.PageHelper;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;

public class BaseEsMapperImpl<T>
implements BaseEsMapper<T> {
    private RestHighLevelClient client;
    private Class<T> entityClass;

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Boolean existsIndex(String indexName) {
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw ExceptionUtils.eee((String)"indexName can not be empty");
        }
        return IndexUtils.existsIndex(this.client, indexName);
    }

    @Override
    public GetIndexResponse getIndex() {
        return IndexUtils.getIndex(this.client, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public GetIndexResponse getIndex(String indexName) {
        return IndexUtils.getIndex(this.client, this.getIndexName(indexName));
    }

    @Override
    public Boolean createIndex() {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam(entityInfo, this.entityClass);
        return IndexUtils.createIndex(this.client, entityInfo, createIndexParam);
    }

    @Override
    public Boolean createIndex(String indexName) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam(entityInfo, this.entityClass);
        if (StringUtils.isNotBlank((CharSequence)indexName)) {
            createIndexParam.setIndexName(indexName);
        }
        return IndexUtils.createIndex(this.client, entityInfo, createIndexParam);
    }

    @Override
    public Boolean createIndex(Wrapper<T> wrapper) {
        Arrays.stream(wrapper.indexNames).forEach(indexName -> this.doCreateIndex(wrapper, (String)indexName));
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateIndex(Wrapper<T> wrapper) {
        Arrays.stream(wrapper.indexNames).forEach(indexName -> this.doUpdateIndex(wrapper, (String)indexName));
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteIndex(String ... indexNames) {
        Assert.notEmpty((Object[])indexNames, (String)"indexNames can not be empty");
        Arrays.stream(indexNames).forEach(indexName -> {
            boolean success = IndexUtils.deleteIndex(this.client, indexName);
            Assert.isTrue((boolean)success, (String)String.format("delete index: %s failed,", indexName));
        });
        return Boolean.TRUE;
    }

    @Override
    public Integer refresh() {
        return this.refresh(EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer refresh(String ... indexNames) {
        RefreshRequest request = new RefreshRequest(indexNames);
        try {
            RefreshResponse refresh = this.client.indices().refresh(request, this.getRequestOptions());
            return refresh.getSuccessfulShards();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw ExceptionUtils.eee((String)"refresh index exception e", (Throwable)e, (Object[])new Object[0]);
        }
    }

    @Override
    public String executeSQL(String sql) {
        Request request = new Request(MethodEnum.POST.name(), "/_xpack/sql?format=json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("query", (Object)sql);
        request.setJsonEntity(jsonObject.toJSONString());
        Response response = this.client.getLowLevelClient().performRequest(request);
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    @Override
    public String executeDSL(String dsl) {
        return this.executeDSL(dsl, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public String executeDSL(String dsl, String indexName) {
        Assert.notNull((Object)indexName, (String)"indexName must not null");
        Request request = new Request(MethodEnum.GET.name(), indexName + "/_search");
        request.setJsonEntity(dsl);
        Response response = this.client.getLowLevelClient().performRequest(request);
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    @Override
    public SearchResponse search(Wrapper<T> wrapper) {
        return this.getSearchResponse(wrapper, null);
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest, RequestOptions requestOptions) throws IOException {
        this.printDSL(searchRequest);
        SearchResponse response = this.client.search(searchRequest, requestOptions);
        this.printResponseErrors(response);
        return response;
    }

    @Override
    public SearchResponse scroll(SearchScrollRequest searchScrollRequest, RequestOptions requestOptions) throws IOException {
        SearchResponse response = this.client.scroll(searchScrollRequest, requestOptions);
        this.printResponseErrors(response);
        return response;
    }

    @Override
    public SearchSourceBuilder getSearchSourceBuilder(Wrapper<T> wrapper) {
        return WrapperProcessor.buildSearchSourceBuilder(wrapper, this.entityClass);
    }

    @Override
    public String getSource(Wrapper<T> wrapper) {
        SearchRequest searchRequest = new SearchRequest(this.getIndexNames(wrapper.indexNames));
        Optional.ofNullable(wrapper.preference).ifPresent(arg_0 -> ((SearchRequest)searchRequest).preference(arg_0));
        Optional.ofNullable(wrapper.routing).ifPresent(arg_0 -> ((SearchRequest)searchRequest).routing(arg_0));
        SearchSourceBuilder searchSourceBuilder = WrapperProcessor.buildSearchSourceBuilder(wrapper, this.entityClass);
        searchRequest.source(searchSourceBuilder);
        return Optional.ofNullable(searchRequest.source()).map(SearchSourceBuilder::toString).orElseThrow(() -> ExceptionUtils.eee((String)"get search source exception"));
    }

    @Override
    public EsPageInfo<T> pageQuery(Wrapper<T> wrapper, Integer pageNum, Integer pageSize) {
        pageNum = pageNum == null || pageNum <= BaseEsConstants.ZERO ? BaseEsConstants.PAGE_NUM : pageNum;
        pageSize = pageSize == null || pageSize <= BaseEsConstants.ZERO ? BaseEsConstants.PAGE_SIZE : pageSize;
        wrapper.from = (pageNum - 1) * pageSize;
        wrapper.size = pageSize;
        SearchResponse response = this.getSearchResponse(wrapper);
        SearchHit[] searchHits = this.parseSearchHitArray(response);
        List dataList = Arrays.stream(searchHits).map(searchHit -> this.parseOne((SearchHit)searchHit, wrapper)).collect(Collectors.toList());
        long count = this.parseCount(response, Objects.nonNull(wrapper.distinctField));
        return PageHelper.getPageInfo(dataList, count, pageNum, pageSize);
    }

    @Override
    public SAPageInfo<T> searchAfterPage(Wrapper<T> wrapper, List<Object> searchAfter, Integer pageSize) {
        boolean notSort;
        boolean illegalArg;
        boolean bl = illegalArg = Objects.nonNull(wrapper.from) && (!wrapper.from.equals(BaseEsConstants.ZERO) || !wrapper.from.equals(BaseEsConstants.MINUS_ONE));
        if (illegalArg) {
            throw ExceptionUtils.eee((String)"The wrapper.from in searchAfter must be 0 or -1 or null, null is recommended");
        }
        boolean bl2 = notSort = CollectionUtils.isEmpty(wrapper.baseSortParams) && CollectionUtils.isEmpty(wrapper.orderByParams);
        if (notSort) {
            List sorts;
            List list = sorts = Objects.nonNull(wrapper.searchSourceBuilder) ? wrapper.searchSourceBuilder.sorts() : Collections.emptyList();
            if (CollectionUtils.isEmpty((Collection)sorts)) {
                throw ExceptionUtils.eee((String)"sortParamList cannot be empty");
            }
        }
        wrapper.size = pageSize = pageSize == null || pageSize <= BaseEsConstants.ZERO ? BaseEsConstants.PAGE_SIZE : pageSize;
        SearchResponse response = CollectionUtils.isEmpty(searchAfter) ? this.getSearchResponse(wrapper) : this.getSearchResponse(wrapper, searchAfter.toArray());
        SearchHit[] searchHits = this.parseSearchHitArray(response);
        List dataList = Arrays.stream(searchHits).map(searchHit -> this.parseOne((SearchHit)searchHit, wrapper)).collect(Collectors.toList());
        Object[] nextSearchAfter = Arrays.stream(searchHits).map(SearchHit::getSortValues).reduce((first, second) -> second).orElse(null);
        long count = this.parseCount(response, Objects.nonNull(wrapper.distinctField));
        return PageHelper.getSAPageInfo(dataList, count, searchAfter, nextSearchAfter == null ? null : Arrays.asList(nextSearchAfter), pageSize);
    }

    @Override
    public Long selectCount(Wrapper<T> wrapper) {
        return this.selectCount(wrapper, Objects.nonNull(wrapper.distinctField));
    }

    @Override
    public Long selectCount(Wrapper<T> wrapper, boolean distinct) {
        CountResponse count;
        if (distinct) {
            Object clone = wrapper.clone();
            ((Wrapper)clone).include = new String[]{"_id"};
            SearchResponse response = this.getSearchResponse((Wrapper<T>)clone);
            return this.parseCount(response, Objects.nonNull(((Wrapper)clone).distinctField));
        }
        CountRequest countRequest = new CountRequest(this.getIndexNames(wrapper.indexNames));
        Optional.ofNullable(wrapper.routing).ifPresent(arg_0 -> ((CountRequest)countRequest).routing(arg_0));
        Optional.ofNullable(wrapper.preference).ifPresent(arg_0 -> ((CountRequest)countRequest).preference(arg_0));
        QueryBuilder queryBuilder = Optional.ofNullable(wrapper.searchSourceBuilder).map(SearchSourceBuilder::query).orElseGet(() -> WrapperProcessor.initBoolQueryBuilder(wrapper.paramQueue, this.entityClass));
        countRequest.query(queryBuilder);
        try {
            this.printCountDSL(countRequest);
            count = this.client.count(countRequest, this.getRequestOptions());
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"selectCount exception", (Throwable)e, (Object[])new Object[0]);
        }
        return count.getCount();
    }

    @Override
    public Integer insert(T entity) {
        return this.insert(null, null, entity, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer insert(String routing, T entity) {
        return this.insert(routing, null, entity, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer insert(String routing, String parentId, T entity) {
        return this.insert(routing, parentId, entity, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer insert(T entity, String ... indexNames) {
        return this.insert(null, null, entity, indexNames);
    }

    @Override
    public Integer insert(String routing, T entity, String ... indexNames) {
        return this.insert(routing, null, entity, indexNames);
    }

    @Override
    public Integer insert(String routing, String parentId, T entity, String ... indexNames) {
        Assert.notNull(entity, (String)"insert entity must not be null");
        return Arrays.stream(this.getIndexNames(indexNames)).mapToInt(indexName -> this.doInsert(entity, routing, parentId, (String)indexName)).sum();
    }

    @Override
    public Integer insertBatch(Collection<T> entityList) {
        return this.insertBatch(null, null, entityList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer insertBatch(String routing, Collection<T> entityList) {
        return this.insertBatch(routing, entityList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer insertBatch(String routing, String parentId, Collection<T> entityList) {
        return this.insertBatch(routing, parentId, entityList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer insertBatch(Collection<T> entityList, String ... indexNames) {
        return this.insertBatch(null, null, entityList, indexNames);
    }

    @Override
    public Integer insertBatch(String routing, Collection<T> entityList, String ... indexNames) {
        return this.insertBatch(routing, null, entityList, indexNames);
    }

    @Override
    public Integer insertBatch(String routing, String parentId, Collection<T> entityList, String ... indexNames) {
        if (CollectionUtils.isEmpty(entityList)) {
            return BaseEsConstants.ZERO;
        }
        return Arrays.stream(this.getIndexNames(indexNames)).mapToInt(indexName -> this.doInsertBatch(entityList, routing, parentId, (String)indexName)).sum();
    }

    @Override
    public Integer deleteById(Serializable id) {
        return this.deleteById(null, id, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer deleteById(String routing, Serializable id) {
        return this.deleteById(routing, id, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer deleteById(Serializable id, String ... indexNames) {
        return this.deleteById(null, id, indexNames);
    }

    @Override
    public Integer deleteById(String routing, Serializable id, String ... indexNames) {
        return Arrays.stream(this.getIndexNames(indexNames)).mapToInt(indexName -> this.doDeleteById(id, routing, (String)indexName)).sum();
    }

    @Override
    public Integer deleteBatchIds(Collection<? extends Serializable> idList) {
        return this.deleteBatchIds(null, idList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer deleteBatchIds(String routing, Collection<? extends Serializable> idList) {
        return this.deleteBatchIds(routing, idList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer deleteBatchIds(Collection<? extends Serializable> idList, String ... indexNames) {
        return this.deleteBatchIds(null, idList, indexNames);
    }

    @Override
    public Integer deleteBatchIds(String routing, Collection<? extends Serializable> idList, String ... indexNames) {
        Assert.notEmpty(idList, (String)"the collection of id must not empty");
        return Arrays.stream(this.getIndexNames(indexNames)).mapToInt(indexName -> this.doDeleteBatchIds(idList, routing, (String)indexName)).sum();
    }

    @Override
    public Integer delete(Wrapper<T> wrapper) {
        BulkByScrollResponse bulkResponse;
        DeleteByQueryRequest request = new DeleteByQueryRequest(this.getIndexNames(wrapper.indexNames));
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        Optional.ofNullable(entityInfo).flatMap(i -> Optional.ofNullable(i.getMaxResultWindow())).ifPresent(arg_0 -> ((DeleteByQueryRequest)request).setBatchSize(arg_0));
        if (RefreshPolicy.IMMEDIATE.getValue().equals(this.getRefreshPolicy())) {
            request.setRefresh(true);
        }
        Optional.ofNullable(wrapper.routing).ifPresent(arg_0 -> ((DeleteByQueryRequest)request).setRouting(arg_0));
        BoolQueryBuilder boolQueryBuilder = WrapperProcessor.initBoolQueryBuilder(wrapper.paramQueue, this.entityClass);
        request.setQuery((QueryBuilder)boolQueryBuilder);
        try {
            bulkResponse = this.client.deleteByQuery(request, this.getRequestOptions());
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"delete error, dsl:%s", (Throwable)e, (Object[])new Object[]{boolQueryBuilder.toString()});
        }
        return (int)bulkResponse.getDeleted();
    }

    @Override
    public Integer updateById(T entity) {
        return this.updateById(null, entity, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer updateById(String routing, T entity) {
        return this.updateById(routing, entity, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer updateById(T entity, String ... indexNames) {
        return this.updateById(null, entity, indexNames);
    }

    @Override
    public Integer updateById(String routing, T entity, String ... indexNames) {
        Assert.notNull(entity, (String)"entity must not be null");
        String idValue = this.getIdValue(entity);
        return Arrays.stream(this.getIndexNames(indexNames)).mapToInt(indexName -> this.doUpdateById(entity, idValue, routing, (String)indexName)).sum();
    }

    @Override
    public Integer updateBatchByIds(Collection<T> entityList) {
        return this.updateBatchByIds(null, entityList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer updateBatchByIds(String routing, Collection<T> entityList) {
        return this.updateBatchByIds(routing, entityList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer updateBatchByIds(Collection<T> entityList, String ... indexNames) {
        return this.updateBatchByIds(null, entityList, indexNames);
    }

    @Override
    public Integer updateBatchByIds(String routing, Collection<T> entityList, String ... indexNames) {
        if (CollectionUtils.isEmpty(entityList)) {
            return BaseEsConstants.ZERO;
        }
        return Arrays.stream(this.getIndexNames(indexNames)).mapToInt(indexName -> this.doUpdateBatchByIds(entityList, routing, (String)indexName)).sum();
    }

    @Override
    public Integer update(T entity, Wrapper<T> updateWrapper) {
        if (Objects.isNull(entity) && CollectionUtils.isEmpty(updateWrapper.updateParamList)) {
            return BaseEsConstants.ZERO;
        }
        return Arrays.stream(this.getIndexNames(updateWrapper.indexNames)).mapToInt(indexName -> this.doUpdate(entity, updateWrapper, (String)indexName)).sum();
    }

    @Override
    public T selectById(Serializable id) {
        return this.selectById(null, id, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public T selectById(String routing, Serializable id) {
        return this.selectById(routing, id, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public T selectById(Serializable id, String ... indexNames) {
        return this.selectById(null, id, indexNames);
    }

    @Override
    public T selectById(String routing, Serializable id, String ... indexNames) {
        if (Objects.isNull(id) || StringUtils.isEmpty((CharSequence)id.toString())) {
            throw ExceptionUtils.eee((String)"id must not be null or empty");
        }
        return Arrays.stream(this.getIndexNames(indexNames)).map(indexName -> this.doSelectById(id, routing, (String)indexName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public List<T> selectBatchIds(Collection<? extends Serializable> idList) {
        return this.selectBatchIds(null, idList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public List<T> selectBatchIds(String routing, Collection<? extends Serializable> idList) {
        return this.selectBatchIds(routing, idList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public List<T> selectBatchIds(Collection<? extends Serializable> idList, String ... indexNames) {
        return this.selectBatchIds(null, idList, indexNames);
    }

    @Override
    public List<T> selectBatchIds(String routing, Collection<? extends Serializable> idList, String ... indexNames) {
        Assert.notEmpty(idList, (String)"id collection must not be null or empty");
        ArrayList result = new ArrayList();
        Arrays.stream(this.getIndexNames(indexNames)).forEach(indexName -> result.addAll(this.doSelectBatchIds(idList, routing, (String)indexName)));
        return result;
    }

    @Override
    public T selectOne(Wrapper<T> wrapper) {
        boolean invalid;
        SearchResponse searchResponse = this.getSearchResponse(wrapper);
        long count = this.parseCount(searchResponse, Objects.nonNull(wrapper.distinctField));
        boolean bl = invalid = count > (long)BaseEsConstants.ONE.intValue() && Objects.nonNull(wrapper.size) && wrapper.size > BaseEsConstants.ONE || count > (long)BaseEsConstants.ONE.intValue() && Objects.isNull(wrapper.size);
        if (invalid) {
            LogUtils.error((String[])new String[]{"found more than one result:" + count, "please use wrapper.limit to limit 1"});
            throw ExceptionUtils.eee((String)"found more than one result: %d, please use wrapper.limit to limit 1", (Object[])new Object[]{count});
        }
        Object[] searchHits = this.parseSearchHitArray(searchResponse);
        if (ArrayUtils.isEmpty((Object[])searchHits)) {
            return null;
        }
        return this.parseOne((SearchHit)searchHits[0], wrapper);
    }

    @Override
    public List<T> selectList(Wrapper<T> wrapper) {
        Object[] searchHits = this.getSearchHitArray(wrapper);
        if (ArrayUtils.isEmpty((Object[])searchHits)) {
            return Collections.emptyList();
        }
        return Arrays.stream(searchHits).map(searchHit -> this.parseOne((SearchHit)searchHit, wrapper)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setCurrentActiveIndex(String indexName) {
        BaseEsMapperImpl baseEsMapperImpl = this;
        synchronized (baseEsMapperImpl) {
            EntityInfoHelper.getEntityInfo(this.entityClass).setIndexName(indexName);
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setRequestOptions(RequestOptions requestOptions) {
        BaseEsMapperImpl baseEsMapperImpl = this;
        synchronized (baseEsMapperImpl) {
            EntityInfoHelper.getEntityInfo(this.entityClass).setRequestOptions(requestOptions);
        }
        return Boolean.TRUE;
    }

    private void doCreateIndex(Wrapper<T> wrapper, String indexName) {
        CreateIndexParam createIndexParam = new CreateIndexParam();
        createIndexParam.setIndexName(indexName);
        Optional.ofNullable(wrapper.shardsNum).ifPresent(createIndexParam::setShardsNum);
        Optional.ofNullable(wrapper.replicasNum).ifPresent(createIndexParam::setReplicasNum);
        Optional.ofNullable(wrapper.maxResultWindow).ifPresent(createIndexParam::setMaxResultWindow);
        Optional.ofNullable(wrapper.settings).ifPresent(createIndexParam::setSettings);
        List<EsIndexParam> indexParamList = wrapper.esIndexParamList;
        createIndexParam.setEsIndexParamList(indexParamList);
        Optional.ofNullable(wrapper.mapping).ifPresent(createIndexParam::setMapping);
        Optional.ofNullable(wrapper.aliasName).ifPresent(createIndexParam::setAliasName);
        boolean success = IndexUtils.createIndex(this.client, EntityInfoHelper.getEntityInfo(this.entityClass), createIndexParam);
        Assert.isTrue((boolean)success, (String)String.format("create index:%s failed", indexName));
    }

    private void doUpdateIndex(Wrapper<T> wrapper, String indexName) {
        boolean existsIndex = this.existsIndex(indexName);
        Assert.isTrue((boolean)existsIndex, (String)String.format("update index: %s failed, because of this index not exists", indexName));
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName});
        if (Objects.isNull(wrapper.mapping)) {
            Assert.notEmpty(wrapper.esIndexParamList, (String)String.format("update index: %s failed, because of empty update args", indexName));
            Map<String, Object> mapping = IndexUtils.initMapping(EntityInfoHelper.getEntityInfo(this.entityClass), wrapper.esIndexParamList);
            putMappingRequest.source(mapping);
        } else {
            putMappingRequest.source(wrapper.mapping);
        }
        try {
            AcknowledgedResponse acknowledgedResponse = this.client.indices().putMapping(putMappingRequest, this.getRequestOptions());
            Assert.isTrue((boolean)acknowledgedResponse.isAcknowledged(), (String)String.format("update index failed, index: %s", indexName));
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"update index exception", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private Integer doInsert(T entity, String routing, String parentId, String indexName) {
        IndexRequest indexRequest = this.buildIndexRequest(entity, routing, parentId, indexName);
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((IndexRequest)indexRequest).routing(arg_0));
        indexRequest.setRefreshPolicy(this.getRefreshPolicy());
        try {
            IndexResponse indexResponse = this.client.index(indexRequest, this.getRequestOptions());
            if (Objects.equals(indexResponse.status(), RestStatus.CREATED)) {
                this.setId(entity, indexResponse.getId());
                return BaseEsConstants.ONE;
            }
            if (Objects.equals(indexResponse.status(), RestStatus.OK)) {
                return BaseEsConstants.ZERO;
            }
            throw ExceptionUtils.eee((String)"insert failed, result:%s entity:%s", (Object[])new Object[]{indexResponse.getResult(), entity});
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"insert entity:%s exception", (Throwable)e, (Object[])new Object[]{entity.toString()});
        }
    }

    private Integer doInsertBatch(Collection<T> entityList, String routing, String parentId, String indexName) {
        BulkRequest bulkRequest = new BulkRequest();
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((BulkRequest)bulkRequest).routing(arg_0));
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        entityList.forEach(entity -> {
            IndexRequest indexRequest = this.buildIndexRequest(entity, routing, parentId, indexName);
            bulkRequest.add(indexRequest);
        });
        return this.doBulkRequest(bulkRequest, this.getRequestOptions(), entityList);
    }

    private Integer doDeleteById(Serializable id, String routing, String indexName) {
        DeleteRequest deleteRequest = this.generateDelRequest(id, indexName);
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((DeleteRequest)deleteRequest).routing(arg_0));
        deleteRequest.setRefreshPolicy(this.getRefreshPolicy());
        try {
            DeleteResponse deleteResponse = this.client.delete(deleteRequest, this.getRequestOptions());
            if (Objects.equals(deleteResponse.status(), RestStatus.OK)) {
                return BaseEsConstants.ONE;
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"deleteById exception, id:%s", (Throwable)e, (Object[])new Object[]{id.toString()});
        }
        return BaseEsConstants.ZERO;
    }

    private Integer doDeleteBatchIds(Collection<? extends Serializable> idList, String routing, String indexName) {
        BulkRequest bulkRequest = new BulkRequest();
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((BulkRequest)bulkRequest).routing(arg_0));
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        idList.forEach(id -> {
            DeleteRequest deleteRequest = this.generateDelRequest((Serializable)id, indexName);
            bulkRequest.add(deleteRequest);
        });
        return this.doBulkRequest(bulkRequest, this.getRequestOptions());
    }

    private Integer doUpdateById(T entity, String idValue, String routing, String indexName) {
        UpdateRequest updateRequest = this.buildUpdateRequest(entity, idValue, indexName);
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((UpdateRequest)updateRequest).routing(arg_0));
        updateRequest.setRefreshPolicy(this.getRefreshPolicy());
        try {
            UpdateResponse updateResponse = this.client.update(updateRequest, this.getRequestOptions());
            if (Objects.equals(updateResponse.status(), RestStatus.OK)) {
                return BaseEsConstants.ONE;
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"updateById exception,entity:%s", (Throwable)e, (Object[])new Object[]{entity.toString()});
        }
        return BaseEsConstants.ZERO;
    }

    private Integer doUpdateBatchByIds(Collection<T> entityList, String routing, String indexName) {
        BulkRequest bulkRequest = new BulkRequest();
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((BulkRequest)bulkRequest).routing(arg_0));
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        entityList.forEach(entity -> {
            String idValue = this.getIdValue(entity);
            UpdateRequest updateRequest = this.buildUpdateRequest(entity, idValue, indexName);
            bulkRequest.add(updateRequest);
        });
        return this.doBulkRequest(bulkRequest, this.getRequestOptions());
    }

    private Integer doUpdate(T entity, Wrapper<T> updateWrapper, String indexName) {
        List<Object> list = this.selectListByUpdateWrapper(updateWrapper, indexName);
        if (CollectionUtils.isEmpty(list)) {
            return BaseEsConstants.ZERO;
        }
        String jsonData = Optional.ofNullable(entity).map(this::buildJsonIndexSource).orElseGet(() -> this.buildJsonDoc(updateWrapper));
        BulkRequest bulkRequest = new BulkRequest();
        Optional.ofNullable(updateWrapper.routing).ifPresent(arg_0 -> ((BulkRequest)bulkRequest).routing(arg_0));
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        Method getId = BaseCache.getterMethod(this.entityClass, this.getRealIdFieldName());
        list.forEach(item -> {
            UpdateRequest updateRequest = new UpdateRequest();
            try {
                Object invoke = getId.invoke(item, new Object[0]);
                Optional.ofNullable(invoke).ifPresent(id -> updateRequest.id(id.toString()));
            }
            catch (Exception e) {
                throw ExceptionUtils.eee((String)"update exception", (Throwable)e, (Object[])new Object[0]);
            }
            updateRequest.index(indexName);
            updateRequest.doc(jsonData, XContentType.JSON);
            Optional.ofNullable(updateWrapper.routing).ifPresent(arg_0 -> ((UpdateRequest)updateRequest).routing(arg_0));
            bulkRequest.add(updateRequest);
        });
        return this.doBulkRequest(bulkRequest, this.getRequestOptions());
    }

    private List<T> doSelectBatchIds(Collection<? extends Serializable> idList, String routing, String indexName) {
        List stringIdList = idList.stream().map(Object::toString).collect(Collectors.toList());
        SearchRequest searchRequest = new SearchRequest(this.getIndexNames(indexName));
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((SearchRequest)searchRequest).routing(arg_0));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termsQuery((String)"_id", stringIdList));
        sourceBuilder.size(idList.size());
        searchRequest.source(sourceBuilder);
        Object[] searchHitArray = this.getSearchHitArray(searchRequest);
        if (ArrayUtils.isEmpty((Object[])searchHitArray)) {
            return Collections.emptyList();
        }
        return Arrays.stream(searchHitArray).map(this::parseOne).collect(Collectors.toList());
    }

    private T doSelectById(Serializable id, String routing, String indexName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((SearchRequest)searchRequest).routing(arg_0));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"_id", (Object)id));
        searchRequest.source(searchSourceBuilder);
        Object[] searchHits = this.getSearchHitArray(searchRequest);
        if (ArrayUtils.isEmpty((Object[])searchHits)) {
            return null;
        }
        return this.parseOne((SearchHit)searchHits[0]);
    }

    private SearchResponse getSearchResponse(Wrapper<T> wrapper, Object[] searchAfter) {
        SearchResponse response;
        SearchRequest searchRequest = new SearchRequest(this.getIndexNames(wrapper.indexNames));
        Optional.ofNullable(wrapper.routing).ifPresent(arg_0 -> ((SearchRequest)searchRequest).routing(arg_0));
        Optional.ofNullable(wrapper.preference).ifPresent(arg_0 -> ((SearchRequest)searchRequest).preference(arg_0));
        SearchSourceBuilder searchSourceBuilder = Optional.ofNullable(wrapper.searchSourceBuilder).map(builder -> {
            Optional.ofNullable(wrapper.from).ifPresent(arg_0 -> ((SearchSourceBuilder)builder).from(arg_0));
            Optional.ofNullable(wrapper.size).ifPresent(arg_0 -> ((SearchSourceBuilder)builder).size(arg_0));
            return builder;
        }).orElseGet(() -> WrapperProcessor.buildSearchSourceBuilder(wrapper, this.entityClass));
        searchRequest.source(searchSourceBuilder);
        Optional.ofNullable(searchAfter).ifPresent(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).searchAfter(arg_0));
        this.printDSL(searchRequest);
        try {
            response = this.client.search(searchRequest, this.getRequestOptions());
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"search exception", (Throwable)e, (Object[])new Object[0]);
        }
        this.printResponseErrors(response);
        return response;
    }

    private DeleteRequest generateDelRequest(Serializable id, String indexName) {
        if (Objects.isNull(id) || StringUtils.isEmpty((CharSequence)id.toString())) {
            throw ExceptionUtils.eee((String)"id must not be null or empty");
        }
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.id(id.toString());
        deleteRequest.index(indexName);
        return deleteRequest;
    }

    private List<T> selectListByUpdateWrapper(Wrapper<T> wrapper, String indexName) {
        SearchSourceBuilder searchSourceBuilder;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        Optional.ofNullable(wrapper.routing).ifPresent(arg_0 -> ((SearchRequest)searchRequest).routing(arg_0));
        Optional.ofNullable(wrapper.preference).ifPresent(arg_0 -> ((SearchRequest)searchRequest).preference(arg_0));
        if (Objects.isNull(wrapper.searchSourceBuilder)) {
            searchSourceBuilder = new SearchSourceBuilder();
            String[] includes = new String[]{"_id"};
            EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
            searchSourceBuilder.fetchSource(includes, null);
            searchSourceBuilder.trackTotalHits(true);
            int size = Optional.ofNullable(entityInfo).map(EntityInfo::getMaxResultWindow).orElse(GlobalConfigCache.getGlobalConfig().getDbConfig().getBatchUpdateThreshold());
            searchSourceBuilder.size(size);
            BoolQueryBuilder boolQueryBuilder = WrapperProcessor.initBoolQueryBuilder(wrapper.paramQueue, this.entityClass);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else {
            searchSourceBuilder = wrapper.searchSourceBuilder;
        }
        searchRequest.source(searchSourceBuilder);
        this.printDSL(searchRequest);
        try {
            SearchResponse response = this.client.search(searchRequest, this.getRequestOptions());
            this.printResponseErrors(response);
            SearchHit[] searchHits = this.parseSearchHitArray(response);
            return Arrays.stream(searchHits).map(this::parseOne).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"selectIdList exception", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private IndexRequest buildIndexRequest(T entity, String routing, String parentId, String indexName) {
        IndexRequest indexRequest = new IndexRequest();
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        if (IdType.UUID.equals((Object)entityInfo.getIdType())) {
            indexRequest.id(UUID.randomUUID().toString());
        } else if (IdType.CUSTOMIZE.equals((Object)entityInfo.getIdType())) {
            indexRequest.id(this.getIdValue(entity));
        }
        String jsonData = this.buildJsonIndexSource(entity);
        if (StringUtils.isNotBlank((CharSequence)entityInfo.getJoinAlias())) {
            JSONObject jsonObject = JSON.parseObject((String)jsonData);
            JoinField joinField = new JoinField();
            joinField.setName(entityInfo.getJoinAlias());
            if (entityInfo.isChild()) {
                joinField.setParent(parentId);
            }
            jsonObject.put(entityInfo.getJoinFieldName(), (Object)joinField);
            jsonData = jsonObject.toJSONString();
        }
        Optional.ofNullable(routing).ifPresent(arg_0 -> ((IndexRequest)indexRequest).routing(arg_0));
        indexRequest.index(indexName);
        indexRequest.source(jsonData, XContentType.JSON);
        return indexRequest;
    }

    private UpdateRequest buildUpdateRequest(T entity, String idValue, String indexName) {
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.id(idValue);
        updateRequest.index(indexName);
        String jsonData = this.buildJsonIndexSource(entity);
        updateRequest.doc(jsonData, XContentType.JSON);
        return updateRequest;
    }

    private long parseCount(SearchResponse response, boolean distinct) {
        AtomicLong repeatNum = new AtomicLong(0L);
        if (distinct) {
            Optional.ofNullable(response.getAggregations()).ifPresent(aggregations -> {
                ParsedCardinality parsedCardinality = (ParsedCardinality)aggregations.get("repeat_num");
                Optional.ofNullable(parsedCardinality).ifPresent(p -> repeatNum.getAndAdd(p.getValue()));
            });
        } else {
            Optional.ofNullable(response.getHits()).flatMap(searchHits -> Optional.ofNullable(searchHits.getTotalHits())).ifPresent(totalHits -> repeatNum.getAndAdd(totalHits.value));
        }
        return repeatNum.get();
    }

    private T parseOne(SearchHit searchHit) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        Object entity = JSON.parseObject((String)searchHit.getSourceAsString(), this.entityClass, (ParseProcess)entityInfo.getExtraProcessor(), (Feature[])new Feature[0]);
        this.setId(entity, searchHit.getId());
        this.setScore(entity, searchHit.getScore(), entityInfo);
        this.setDistance(entity, searchHit.getSortValues(), entityInfo);
        return (T)entity;
    }

    private T parseOne(SearchHit searchHit, Wrapper<T> wrapper) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        Object entity = JSON.parseObject((String)searchHit.getSourceAsString(), this.entityClass, (ParseProcess)entityInfo.getExtraProcessor(), (Feature[])new Feature[0]);
        Map highlightFields = searchHit.getHighlightFields();
        if (CollectionUtils.isNotEmpty(entityInfo.getHighlightParams()) && CollectionUtils.isNotEmpty((Map)highlightFields)) {
            Map<String, String> highlightFieldMap = this.getHighlightFieldMap();
            highlightFields.forEach((key, value) -> {
                String highLightValue = Arrays.stream(value.getFragments()).map(Text::string).collect(Collectors.joining());
                this.setHighlightValue(entity, (String)highlightFieldMap.get(key), highLightValue);
            });
        }
        this.setInnerHighlight(searchHit, entity, entityInfo.getNestedHighlightFieldMap());
        this.setScore(entity, searchHit.getScore(), entityInfo);
        this.setDistance(entity, searchHit.getSortValues(), entityInfo, wrapper.baseSortParams);
        boolean includeId = WrapperProcessor.includeId(this.getRealIdFieldName(), wrapper);
        if (includeId) {
            this.setId(entity, searchHit.getId());
        }
        return (T)entity;
    }

    private void setInnerHighlight(SearchHit searchHit, T root, Map<Class<?>, Map<String, String>> nestedHighlightFieldMap) {
        if (CollectionUtils.isEmpty((Map)searchHit.getInnerHits())) {
            return;
        }
        searchHit.getInnerHits().forEach((k, v) -> {
            SearchHit[] hits = v.getHits();
            Arrays.stream(hits).forEach(hit -> {
                SearchHit.NestedIdentity nestedIdentity = hit.getNestedIdentity();
                Map highlightFields = hit.getHighlightFields();
                if (CollectionUtils.isNotEmpty((Map)highlightFields) && nestedIdentity != null) {
                    highlightFields.forEach((k1, v1) -> {
                        String highLightContent = Arrays.stream(v1.getFragments()).map(Text::string).collect(Collectors.joining());
                        ArrayList pathList = new ArrayList();
                        for (SearchHit.NestedIdentity tmpNestedIdentity = nestedIdentity; tmpNestedIdentity != null; tmpNestedIdentity = tmpNestedIdentity.getChild()) {
                            Optional.ofNullable(tmpNestedIdentity.getField()).ifPresent(field -> pathList.add(field.toString()));
                        }
                        String highLightField = k1.replace(String.join((CharSequence)".", pathList) + ".", "");
                        this.processInnerHighlight(nestedIdentity.getField().string(), root, nestedIdentity, highLightField, highLightContent, nestedHighlightFieldMap);
                    });
                }
            });
        });
    }

    private void processInnerHighlight(String path, Object root, SearchHit.NestedIdentity nestedIdentity, String highlightField, String highlightContent, Map<Class<?>, Map<String, String>> nestedHighlightFieldMap) {
        Method method = BaseCache.getterMethod(root.getClass(), nestedIdentity.getField().string());
        Object invoke = null;
        try {
            invoke = method.invoke(root, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LogUtils.error((String[])new String[]{"processInnerHighlight invoke error, class:%s,methodName:%s", root.getClass().getSimpleName(), nestedIdentity.getField().string()});
        }
        if (invoke instanceof Collection) {
            Collection coll = (Collection)invoke;
            Iterator iterator = coll.iterator();
            int i2 = 0;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (i2 == nestedIdentity.getOffset() && path.equals(nestedIdentity.getField().string())) {
                    SearchHit.NestedIdentity child = nestedIdentity.getChild();
                    if (child != null) {
                        this.processInnerHighlight(child.getField().string(), next, child, highlightField, highlightContent, nestedHighlightFieldMap);
                    } else {
                        String realHighlightField = Optional.ofNullable(nestedHighlightFieldMap.get(next.getClass())).map(highlightFieldMap -> (String)highlightFieldMap.get(highlightField)).orElse(highlightField);
                        this.setHighlightValue(next, realHighlightField, highlightContent);
                    }
                }
                ++i2;
            }
        } else {
            Object finalInvoke = invoke;
            Optional.ofNullable(finalInvoke).ifPresent(i -> {
                String realHighlightField = Optional.ofNullable(nestedHighlightFieldMap.get(finalInvoke.getClass())).map(highlightFieldMap -> (String)highlightFieldMap.get(highlightField)).orElse(highlightField);
                this.setHighlightValue(i, realHighlightField, highlightContent);
            });
        }
    }

    private void setDistance(T entity, Object[] sortValues, EntityInfo entityInfo) {
        this.setDistance(entity, sortValues, entityInfo, null);
    }

    private void setDistance(T entity, Object[] sortValues, EntityInfo entityInfo, List<BaseSortParam> baseSortParams) {
        List<String> distanceFields = entityInfo.getDistanceFields();
        if (CollectionUtils.isEmpty(distanceFields) || ArrayUtils.isEmpty((Object[])sortValues) || CollectionUtils.isEmpty(baseSortParams)) {
            return;
        }
        int i = 0;
        int geoFieldIndex = 0;
        while (i < sortValues.length) {
            if (OrderTypeEnum.GEO != baseSortParams.get(i).getOrderTypeEnum()) {
                --geoFieldIndex;
            } else {
                double distance;
                Object sortValue = sortValues[i];
                if (sortValue instanceof Double && !Double.isNaN(distance = ((Double)sortValue).doubleValue())) {
                    Integer distanceDecimalPlaces = entityInfo.getDistanceDecimalPlaces().get(geoFieldIndex);
                    if (distanceDecimalPlaces > BaseEsConstants.ZERO) {
                        distance = NumericUtils.setDecimalPlaces((double)distance, (int)distanceDecimalPlaces);
                    }
                    try {
                        Method invokeMethod = BaseCache.setterMethod(entity.getClass(), distanceFields.get(geoFieldIndex));
                        invokeMethod.invoke(entity, distance);
                    }
                    catch (Throwable e) {
                        LogUtils.formatError((String)"set distance error, entity:%s,sortValues:%s,distanceField:%s,e:%s", (Object[])new Object[]{entity, JSON.toJSONString((Object)sortValues), distanceFields, e});
                    }
                }
            }
            ++i;
            ++geoFieldIndex;
        }
    }

    private void setScore(T entity, float score, EntityInfo entityInfo) {
        String scoreField = entityInfo.getScoreField();
        if (Objects.isNull(scoreField) || Float.isNaN(score)) {
            return;
        }
        if (entityInfo.getScoreDecimalPlaces() > BaseEsConstants.ZERO) {
            score = NumericUtils.setDecimalPlaces((float)score, (int)entityInfo.getScoreDecimalPlaces());
        }
        try {
            Method invokeMethod = BaseCache.setterMethod(entity.getClass(), scoreField);
            invokeMethod.invoke(entity, Float.valueOf(score));
        }
        catch (Throwable e) {
            LogUtils.formatError((String)"set score error, entity:%s,score:%s,scoreField:%s,e:%s", (Object[])new Object[]{entity, Float.valueOf(score), scoreField, e});
        }
    }

    private SearchResponse getSearchResponse(Wrapper<T> wrapper) {
        return this.search(wrapper);
    }

    private SearchHit[] getSearchHitArray(SearchRequest searchRequest) {
        SearchResponse response;
        this.printDSL(searchRequest);
        try {
            response = this.client.search(searchRequest, this.getRequestOptions());
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"getSearchHitArray exception,searchRequest:%s", (Throwable)e, (Object[])new Object[]{searchRequest.toString()});
        }
        this.printResponseErrors(response);
        return this.parseSearchHitArray(response);
    }

    private SearchHit[] getSearchHitArray(Wrapper<T> wrapper) {
        SearchResponse response;
        SearchRequest searchRequest = new SearchRequest(this.getIndexNames(wrapper.indexNames));
        Optional.ofNullable(wrapper.routing).ifPresent(arg_0 -> ((SearchRequest)searchRequest).routing(arg_0));
        Optional.ofNullable(wrapper.preference).ifPresent(arg_0 -> ((SearchRequest)searchRequest).preference(arg_0));
        SearchSourceBuilder searchSourceBuilder = Objects.isNull(wrapper.searchSourceBuilder) ? WrapperProcessor.buildSearchSourceBuilder(wrapper, this.entityClass) : wrapper.searchSourceBuilder;
        searchRequest.source(searchSourceBuilder);
        this.printDSL(searchRequest);
        try {
            response = this.client.search(searchRequest, this.getRequestOptions());
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"getSearchHitArray IOException, searchRequest:%s", (Throwable)e, (Object[])new Object[]{searchRequest.toString()});
        }
        this.printResponseErrors(response);
        return this.parseSearchHitArray(response);
    }

    private String buildJsonIndexSource(T entity) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        List<EntityFieldInfo> fieldList = entityInfo.getFieldList();
        HashSet excludeColumn = new HashSet();
        fieldList.forEach(field -> {
            String column = field.getColumn();
            Method invokeMethod = BaseCache.getterMethod(this.entityClass, column);
            FieldStrategy fieldStrategy = field.getFieldStrategy();
            try {
                if (FieldStrategy.NOT_NULL.equals((Object)fieldStrategy)) {
                    Object invoke = invokeMethod.invoke(entity, new Object[0]);
                    if (Objects.isNull(invoke)) {
                        excludeColumn.add(column);
                    }
                } else if (FieldStrategy.NOT_EMPTY.equals((Object)fieldStrategy)) {
                    String strValue;
                    Object invoke = invokeMethod.invoke(entity, new Object[0]);
                    if (Objects.isNull(invoke)) {
                        excludeColumn.add(column);
                    } else if (invoke instanceof String && StringUtils.isEmpty((CharSequence)(strValue = (String)invoke))) {
                        excludeColumn.add(column);
                    }
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.eee((String)"buildJsonIndexSource exception, entity:%s", (Throwable)e, (Object[])new Object[]{entity.toString()});
            }
        });
        ArrayList serializeFilters = new ArrayList();
        Optional.ofNullable(entityInfo.getClassSimplePropertyPreFilterMap().get(this.entityClass)).ifPresent(serializeFilters::addAll);
        SimplePropertyPreFilter simplePropertyPreFilter = FastJsonUtils.getSimplePropertyPreFilter(entity.getClass(), excludeColumn);
        Optional.ofNullable(simplePropertyPreFilter).ifPresent(serializeFilters::add);
        return JSON.toJSONString(entity, (SerializeFilter[])serializeFilters.toArray(new SerializeFilter[0]), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    private String buildJsonDoc(Wrapper<T> updateWrapper) {
        List<EsUpdateParam> updateParamList = updateWrapper.updateParamList;
        JSONObject jsonObject = new JSONObject();
        updateParamList.forEach(esUpdateParam -> {
            String realField = FieldUtils.getRealFieldNotConvertId(esUpdateParam.getField(), EntityInfoHelper.getEntityInfo(this.entityClass).getMappingColumnMap(), GlobalConfigCache.getGlobalConfig().getDbConfig().isMapUnderscoreToCamelCase());
            jsonObject.put(realField, esUpdateParam.getValue());
        });
        return JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    private int doBulkRequest(BulkRequest bulkRequest, RequestOptions requestOptions) {
        int totalSuccess = 0;
        try {
            BulkResponse bulkResponse = this.client.bulk(bulkRequest, requestOptions);
            if (bulkResponse.hasFailures()) {
                LogUtils.error((String[])new String[]{bulkResponse.buildFailureMessage()});
            }
            Iterator iterator = bulkResponse.iterator();
            while (iterator.hasNext()) {
                if (!Objects.equals(((BulkItemResponse)iterator.next()).status(), RestStatus.OK)) continue;
                ++totalSuccess;
            }
        }
        catch (IOException e) {
            LogUtils.error((String[])new String[]{"bulk request exception", JSON.toJSONString((Object)e)});
        }
        return totalSuccess;
    }

    private int doBulkRequest(BulkRequest bulkRequest, RequestOptions requestOptions, Collection<T> entityList) {
        int totalSuccess = 0;
        try {
            BulkResponse bulkResponse = this.client.bulk(bulkRequest, requestOptions);
            if (bulkResponse.hasFailures()) {
                LogUtils.error((String[])new String[]{bulkResponse.buildFailureMessage()});
            }
            for (BulkItemResponse next : bulkResponse) {
                if (!Objects.equals(next.status(), RestStatus.CREATED)) continue;
                this.setId(entityList.toArray()[totalSuccess], next.getId());
                ++totalSuccess;
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"bulkRequest exception", (Throwable)e, (Object[])new Object[0]);
        }
        return totalSuccess;
    }

    private SearchHit[] parseSearchHitArray(SearchResponse searchResponse) {
        return Optional.ofNullable(searchResponse).map(SearchResponse::getHits).map(SearchHits::getHits).orElseThrow(() -> ExceptionUtils.eee((String)"parseSearchHitArray exception"));
    }

    private String getIndexName(String indexName) {
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName();
        }
        return indexName;
    }

    private String[] getIndexNames(String ... indexNames) {
        if (ArrayUtils.isEmpty((Object[])indexNames)) {
            return new String[]{EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName()};
        }
        return (String[])Arrays.stream(indexNames).map(this::getIndexName).toArray(String[]::new);
    }

    private String getRealIdFieldName() {
        return EntityInfoHelper.getEntityInfo(this.entityClass).getKeyProperty();
    }

    private Map<String, String> getHighlightFieldMap() {
        return EntityInfoHelper.getEntityInfo(this.entityClass).getHighlightFieldMap();
    }

    private void setHighlightValue(Object entity, String highlightField, String value) {
        try {
            Method invokeMethod = BaseCache.setterMethod(entity.getClass(), highlightField);
            invokeMethod.invoke(entity, value);
        }
        catch (Throwable e) {
            LogUtils.formatError((String)"setHighlightValue error,entity:%s,highlightField:%s,value:%s,e:%s", (Object[])new Object[]{entity.toString(), highlightField, value, e.toString()});
        }
    }

    private void setId(Object entity, String id) {
        try {
            Method invokeMethod = BaseCache.setterMethod(entity.getClass(), this.getRealIdFieldName());
            Class<?> idClass = EntityInfoHelper.getEntityInfo(entity.getClass()).getIdClass();
            Object val = ReflectionKit.getVal((String)id, idClass);
            invokeMethod.invoke(entity, val);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String getIdValue(T entity) {
        try {
            EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
            Field keyField = Optional.ofNullable(entityInfo.getKeyField()).orElseThrow(() -> ExceptionUtils.eee((String)"the entity id field not found"));
            Object value = keyField.get(entity);
            return Optional.ofNullable(value).map(Object::toString).orElseThrow(() -> ExceptionUtils.eee((String)"the entity id must not be null"));
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.eee((String)"get id value exception", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void printCountDSL(CountRequest countRequest) {
        Optional.ofNullable(countRequest.query()).ifPresent(i -> this.doPrint(i.toString(), countRequest.routing(), countRequest.indices()));
    }

    private void printDSL(SearchRequest searchRequest) {
        Optional.ofNullable(searchRequest.source()).ifPresent(i -> this.doPrint(i.toString(), searchRequest.routing(), searchRequest.indices()));
    }

    private void doPrint(String source, String routing, String[] indices) {
        GlobalConfig globalConfig = GlobalConfigCache.getGlobalConfig();
        if (globalConfig.isPrintDsl()) {
            String prefix = globalConfig.isIKunMode() ? "===> \u9e21\u4f60\u592a\u7f8e\u63d0\u9192\u60a8, \u4ee5\u4e0b\u5185\u5bb9\u7531Easy-Es\u6267\u884c:" : "===> Execute By Easy-Es: ";
            LogUtils.info((String[])new String[]{prefix + "\nrouting: " + routing + "\nindex-name: " + String.join((CharSequence)",", indices) + "\nDSL\uff1a" + source});
        }
    }

    private void printResponseErrors(SearchResponse searchResponse) {
        if (Objects.nonNull(searchResponse) && searchResponse.getShardFailures() != null && searchResponse.getShardFailures().length > BaseEsConstants.ZERO) {
            String errorMsg = searchResponse.getShardFailures()[0].toString();
            throw ExceptionUtils.eee((String)("search response failed ,failedShards: " + errorMsg));
        }
    }

    private String getRefreshPolicy() {
        RefreshPolicy refreshPolicy = Optional.ofNullable(EntityInfoHelper.getEntityInfo(this.entityClass).getRefreshPolicy()).orElse(RefreshPolicy.NONE);
        return RefreshPolicy.GLOBAL.equals((Object)refreshPolicy) ? RefreshPolicy.NONE.getValue() : refreshPolicy.getValue();
    }

    private RequestOptions getRequestOptions() {
        return EntityInfoHelper.getEntityInfo(this.entityClass).getRequestOptions();
    }

    public void setClient(RestHighLevelClient client) {
        this.client = client;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }
}

