/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.proxy;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.dromara.easyes.core.cache.BaseCache;
import org.dromara.easyes.core.kernel.BaseEsMapperImpl;

public class EsMapperProxy<T>
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ALLOWED_MODES = 15;
    private static final Method privateLookupInMethod;
    private static final Constructor<MethodHandles.Lookup> lookupConstructor;
    private final Map<Method, EsMapperMethodInvoker> methodCache;
    private Class<T> mapperInterface;

    public EsMapperProxy(Class<T> mapperInterface, Map<Method, EsMapperMethodInvoker> methodCache) {
        this.mapperInterface = mapperInterface;
        this.methodCache = methodCache;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BaseEsMapperImpl<?> baseEsMapperInstance = BaseCache.getBaseEsMapperInstance(this.mapperInterface);
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke(baseEsMapperInstance, args);
        }
        return this.cachedInvoker(method, baseEsMapperInstance).invoke(proxy, method, args);
    }

    private EsMapperMethodInvoker cachedInvoker(Method method, BaseEsMapperImpl<?> baseEsMapperInstance) throws Throwable {
        try {
            return this.methodCache.computeIfAbsent(method, m -> {
                if (!m.isDefault()) {
                    return new PlainMethodInvoker(baseEsMapperInstance);
                }
                try {
                    if (privateLookupInMethod == null) {
                        return new DefaultMethodInvoker(this.getMethodHandleJava8(method));
                    }
                    return new DefaultMethodInvoker(this.getMethodHandleJava9(method));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            throw cause == null ? re : cause;
        }
    }

    private MethodHandle getMethodHandleJava9(Method method) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> declaringClass = method.getDeclaringClass();
        return ((MethodHandles.Lookup)privateLookupInMethod.invoke(null, declaringClass, MethodHandles.lookup())).findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
    }

    private MethodHandle getMethodHandleJava8(Method method) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> declaringClass = method.getDeclaringClass();
        return lookupConstructor.newInstance(declaringClass, 15).unreflectSpecial(method, declaringClass);
    }

    static {
        Method privateLookupIn;
        try {
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            privateLookupIn = null;
        }
        privateLookupInMethod = privateLookupIn;
        Constructor lookup = null;
        if (privateLookupInMethod == null) {
            try {
                lookup = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookup.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("There is neither 'privateLookupIn(Class, Lookup)' nor 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
            }
            catch (Exception e) {
                lookup = null;
            }
        }
        lookupConstructor = lookup;
    }

    private static class DefaultMethodInvoker
    implements EsMapperMethodInvoker {
        private final MethodHandle methodHandle;

        public DefaultMethodInvoker(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.methodHandle.bindTo(proxy).invokeWithArguments(args);
        }
    }

    private static class PlainMethodInvoker
    implements EsMapperMethodInvoker {
        private final BaseEsMapperImpl<?> baseEsMapperInstance;

        public PlainMethodInvoker(BaseEsMapperImpl<?> baseEsMapperInstance) {
            this.baseEsMapperInstance = baseEsMapperInstance;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.baseEsMapperInstance, args);
        }
    }

    static interface EsMapperMethodInvoker {
        public Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;
    }
}

