/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.toolkit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.core.config.GeneratorConfig;

public class EntityGenerator {
    private static final String UNDERLINE = "_";
    private static final String USER_DIR = "user.dir";
    private static final String SRC = "src";
    private static final String MAIN = "main";
    private static final String JAVA = "java";
    private static final String PACKAGE = "package %s;\n\n";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String LOMBOK_IMPORT = "import lombok.Data;\n";
    private static final String EE_IMPORT = "import org.dromara.easyes.annotation.*;\n\n";
    private static final Pattern ILLEGAL_FIELD_NAME_PATTERN = Pattern.compile("^[^a-zA-Z_$]|[\\W&&[^_]]");
    private static final String LOMBOK_TEMPLATE = "public class %s {\n    // Fields\n%s}\n";
    private static final String TEMPLATE = "public class %s {\n    // Fields\n%s\n    // Getters and Setters\n%s\n%s\n}\n";
    private static final String CLASS_ANNOTATION = "@IndexName(\"%s\")\n@Settings(shardsNum = %d, replicasNum = %d)\n";
    private static final String LOMBOK_ANNOTATION = "@Data\n";
    private static final String FIELD_TEMPLATE = "    private %s %s;\n";
    private static final String GETTER_TEMPLATE = "    public %s get%s() {\n        return this.%s;\n    }\n";
    private static final String SETTER_TEMPLATE = "    public void set%s(%s %s) {\n        this.%s = %s;\n    }\n";
    private static final String JAVA_SUFFIX = ".java";

    public static void generateEntity(GeneratorConfig config, Map<String, String> fields, String className, Integer shardsNum, Integer replicasNum) throws IOException {
        className = config.isEnableUnderlineToCamelCase() ? EntityGenerator.capitalize(StringUtils.underlineToCamel((String)className)) : EntityGenerator.capitalize(className);
        String indexName = config.isEnableUnderlineToCamelCase() ? EntityGenerator.capitalize(StringUtils.underlineToCamel((String)config.getIndexName())) : EntityGenerator.capitalize(config.getIndexName());
        boolean mainClass = Objects.equals(className, indexName);
        String wholePath = System.getProperty(USER_DIR) + File.separator + SRC + File.separator + MAIN + File.separator + JAVA + File.separator + EntityGenerator.packageToPath(config.getDestPackage());
        Path outputPath = Paths.get(wholePath, className + JAVA_SUFFIX);
        if (!Files.exists(outputPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        StringBuilder fieldBuilder = new StringBuilder();
        StringBuilder getterBuilder = new StringBuilder();
        StringBuilder setterBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            if (config.isEnableUnderlineToCamelCase()) {
                fieldName = StringUtils.underlineToCamel((String)fieldName);
            }
            fieldName = EntityGenerator.sanitizeFieldName(fieldName);
            String fieldType = entry.getValue();
            fieldBuilder.append(String.format(FIELD_TEMPLATE, fieldType, fieldName));
            if (config.isEnableLombok()) continue;
            getterBuilder.append(String.format(GETTER_TEMPLATE, fieldType, EntityGenerator.capitalize(fieldName), fieldName));
            setterBuilder.append(String.format(SETTER_TEMPLATE, EntityGenerator.capitalize(fieldName), fieldType, fieldName, fieldName, fieldName));
        }
        String content = config.isEnableLombok() ? String.format(PACKAGE, config.getDestPackage()) + LOMBOK_IMPORT + EE_IMPORT + EntityGenerator.addIndexAnnotation(indexName, shardsNum, replicasNum, mainClass) + LOMBOK_ANNOTATION + String.format(LOMBOK_TEMPLATE, className, fieldBuilder) : String.format(PACKAGE, config.getDestPackage()) + EE_IMPORT + EntityGenerator.addIndexAnnotation(indexName, shardsNum, replicasNum, mainClass) + String.format(TEMPLATE, className, fieldBuilder, getterBuilder, setterBuilder);
        try (FileWriter writer = new FileWriter(outputPath.toFile());){
            writer.write(content);
            LogUtils.info((String[])new String[]{"Generated entity class: " + outputPath});
        }
    }

    private static String packageToPath(String packageName) {
        return packageName.replace('.', File.separatorChar);
    }

    private static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(BaseEsConstants.ZERO)) + str.substring(BaseEsConstants.ONE);
    }

    private static String sanitizeFieldName(String fieldName) {
        String sanitized = ILLEGAL_FIELD_NAME_PATTERN.matcher(fieldName).replaceAll("");
        if (Character.isDigit(sanitized.charAt(BaseEsConstants.ZERO))) {
            sanitized = UNDERLINE + sanitized;
        }
        return sanitized;
    }

    private static String addIndexAnnotation(String indexName, Integer shardsNum, Integer replicasNum, boolean mainClass) {
        if (mainClass) {
            return String.format(CLASS_ANNOTATION, indexName, shardsNum, replicasNum);
        }
        return "";
    }
}

