/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.toolkit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.common.utils.CollectionUtils;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.core.biz.EsIndexInfo;
import org.dromara.easyes.core.config.GeneratorConfig;
import org.dromara.easyes.core.toolkit.EntityGenerator;
import org.dromara.easyes.core.toolkit.FieldUtils;
import org.dromara.easyes.core.toolkit.IndexUtils;
import org.elasticsearch.client.RestHighLevelClient;

public abstract class Generator {
    private static final String PROPERTIES = "properties";
    private static final String TYPE = "type";
    private static final String NESTED = "nested";
    private static final String NESTED_SUFFIX1 = "s";
    private static final String NESTED_SUFFIX2 = "List";
    private static final Set<String> SKIP_TYPE = new HashSet<String>(Arrays.asList("join"));

    public abstract Boolean generate(GeneratorConfig var1);

    public void generateEntity(GeneratorConfig config, RestHighLevelClient client) {
        EsIndexInfo esIndexInfo = IndexUtils.getIndexInfo(client, config.getIndexName());
        Map<String, Object> mapping = esIndexInfo.getMapping();
        if (CollectionUtils.isEmpty(mapping)) {
            return;
        }
        LinkedHashMap properties = (LinkedHashMap)mapping.get(PROPERTIES);
        this.executeGenerate(properties, config, esIndexInfo, config.getIndexName());
    }

    private void executeGenerate(LinkedHashMap<String, LinkedHashMap<String, Object>> properties, GeneratorConfig config, EsIndexInfo esIndexInfo, String className) {
        HashMap<String, String> modelMap = new HashMap<String, String>(properties.size());
        properties.forEach((k, v) -> Optional.ofNullable(v.get(TYPE)).ifPresent(esType -> {
            if (SKIP_TYPE.contains(esType.toString())) {
                return;
            }
            if (NESTED.equals(esType.toString())) {
                this.executeGenerate((LinkedHashMap)v.get(PROPERTIES), config, esIndexInfo, Generator.parseClassName(k));
            }
            String javaType = Generator.getJavaType(esType.toString(), k);
            modelMap.put((String)k, javaType);
        }));
        EntityGenerator.generateEntity(config, modelMap, className, esIndexInfo.getShardsNum(), esIndexInfo.getReplicasNum());
    }

    private static String parseClassName(String origin) {
        if (StringUtils.isEmpty((CharSequence)origin)) {
            return origin;
        }
        if (origin.endsWith(NESTED_SUFFIX1)) {
            return FieldUtils.firstToUpperCase(origin.substring(BaseEsConstants.ZERO, origin.lastIndexOf(NESTED_SUFFIX1)));
        }
        if (origin.endsWith(NESTED_SUFFIX2)) {
            return FieldUtils.firstToUpperCase(origin.substring(BaseEsConstants.ZERO, origin.lastIndexOf(NESTED_SUFFIX2)));
        }
        return origin;
    }

    private static String getJavaType(String esType, String key) {
        if (StringUtils.isNotBlank((CharSequence)esType)) {
            switch (esType) {
                case "long": {
                    return "Long";
                }
                case "integer": {
                    return "Integer";
                }
                case "short": {
                    return "Short";
                }
                case "byte": {
                    return "Byte";
                }
                case "double": {
                    return "Double";
                }
                case "float": {
                    return "Float";
                }
                case "boolean": {
                    return "Boolean";
                }
                case "date": {
                    return "Date";
                }
                case "keyword": 
                case "text": 
                case "ip": 
                case "geo_shape": 
                case "geo_point": {
                    return "String";
                }
                case "scaled_float": {
                    return "BigDecimal";
                }
                case "nested": {
                    return String.format("List<%s>", Generator.parseClassName(key));
                }
            }
            return "Object";
        }
        return "String";
    }
}

