/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.core.toolkit;

import java.io.IOException;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.core.toolkit.IndexUtils;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;

public class LockUtils {
    private static final String ID_FIELD = "_id";
    private static final Integer WAIT_SECONDS = 1;

    public static synchronized boolean tryLock(RestHighLevelClient client, String idValue, Integer maxRetry) {
        boolean existsIndex = IndexUtils.existsIndex(client, "ee-distribute-lock");
        if (!existsIndex) {
            IndexUtils.createEmptyIndex(client, "ee-distribute-lock");
        }
        if (maxRetry <= BaseEsConstants.ZERO) {
            return Boolean.FALSE;
        }
        if (LockUtils.getCount(client, idValue) > BaseEsConstants.ZERO) {
            try {
                Thread.sleep(WAIT_SECONDS / maxRetry);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            maxRetry = maxRetry - 1;
            return LockUtils.tryLock(client, idValue, maxRetry);
        }
        return LockUtils.createLock(client, idValue);
    }

    private static boolean createLock(RestHighLevelClient client, String idValue) {
        IndexResponse response;
        IndexRequest indexRequest = new IndexRequest("ee-distribute-lock");
        indexRequest.id(idValue);
        indexRequest.source("{\"tip\":\"Do not delete unless deadlock occurs\"}", XContentType.JSON);
        try {
            response = client.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        return response.status().equals((Object)RestStatus.CREATED);
    }

    public static synchronized boolean release(RestHighLevelClient client, String idValue, Integer maxRetry) {
        DeleteResponse response;
        DeleteRequest deleteRequest = new DeleteRequest("ee-distribute-lock");
        deleteRequest.id(idValue);
        if (maxRetry <= BaseEsConstants.ZERO) {
            return Boolean.FALSE;
        }
        try {
            response = client.delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            maxRetry = maxRetry - 1;
            return LockUtils.retryRelease(client, idValue, maxRetry);
        }
        if (RestStatus.OK.equals((Object)response.status())) {
            return Boolean.TRUE;
        }
        return LockUtils.retryRelease(client, idValue, maxRetry);
    }

    private static boolean retryRelease(RestHighLevelClient client, String idValue, Integer maxRetry) {
        try {
            Thread.sleep(WAIT_SECONDS / maxRetry);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        maxRetry = maxRetry - 1;
        return LockUtils.release(client, idValue, maxRetry);
    }

    private static Integer getCount(RestHighLevelClient client, String idValue) {
        SearchResponse response;
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{"ee-distribute-lock"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)ID_FIELD, (String)idValue));
        searchRequest.source(searchSourceBuilder);
        try {
            response = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
            return BaseEsConstants.ONE;
        }
        return (int)response.getHits().getTotalHits().value;
    }
}

