/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.spring.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.easyes.annotation.EsDS;
import org.dromara.easyes.annotation.Intercepts;
import org.dromara.easyes.common.constants.BaseEsConstants;
import org.dromara.easyes.common.enums.ProcessIndexStrategyEnum;
import org.dromara.easyes.common.property.EasyEsProperties;
import org.dromara.easyes.common.property.GlobalConfig;
import org.dromara.easyes.common.strategy.AutoProcessIndexStrategy;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.common.utils.RestHighLevelClientUtils;
import org.dromara.easyes.common.utils.TypeUtils;
import org.dromara.easyes.core.biz.EntityInfo;
import org.dromara.easyes.core.cache.BaseCache;
import org.dromara.easyes.core.cache.GlobalConfigCache;
import org.dromara.easyes.core.proxy.EsMapperProxy;
import org.dromara.easyes.core.toolkit.EntityInfoHelper;
import org.dromara.easyes.extension.context.Interceptor;
import org.dromara.easyes.extension.context.InterceptorChain;
import org.dromara.easyes.extension.context.InterceptorChainHolder;
import org.dromara.easyes.spring.factory.IndexStrategyFactory;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MapperFactoryBean<T>
implements FactoryBean<T> {
    private Class<T> mapperInterface;
    @Autowired
    private ApplicationContext applicationContext;

    public MapperFactoryBean() {
    }

    public MapperFactoryBean(Class<T> mapperInterface) {
        this.mapperInterface = mapperInterface;
    }

    public T getObject() throws Exception {
        EsMapperProxy esMapperProxy = new EsMapperProxy(this.mapperInterface, new ConcurrentHashMap());
        Class entityClass = TypeUtils.getInterfaceT(this.mapperInterface, (int)BaseEsConstants.ZERO);
        EasyEsProperties easyEsProperties = (EasyEsProperties)this.applicationContext.getBean(EasyEsProperties.class);
        GlobalConfig globalConfig = easyEsProperties.getGlobalConfig();
        GlobalConfigCache.setGlobalConfig((GlobalConfig)globalConfig);
        String restHighLevelClientId = Optional.ofNullable(this.mapperInterface.getAnnotation(EsDS.class)).map(EsDS::value).orElse("DEFAULT_DS");
        RestHighLevelClient client = ((RestHighLevelClientUtils)this.applicationContext.getBean(RestHighLevelClientUtils.class)).getClient(restHighLevelClientId);
        BaseCache.initCache(this.mapperInterface, (Class)entityClass, (RestHighLevelClient)client);
        Object t = Proxy.newProxyInstance(this.mapperInterface.getClassLoader(), new Class[]{this.mapperInterface}, (InvocationHandler)esMapperProxy);
        InterceptorChain interceptorChain = this.initInterceptorChain();
        if (!ProcessIndexStrategyEnum.MANUAL.equals((Object)globalConfig.getProcessIndexMode())) {
            EntityInfo entityInfo = EntityInfoHelper.getEntityInfo((Class)entityClass);
            boolean isChild = entityInfo.isChild();
            if (!isChild) {
                AutoProcessIndexStrategy autoProcessIndexService = ((IndexStrategyFactory)this.applicationContext.getBean(IndexStrategyFactory.class)).getByStrategyType(globalConfig.getProcessIndexMode().getStrategyType());
                autoProcessIndexService.processIndexAsync(entityClass, client);
            }
        } else {
            LogUtils.info((String[])new String[]{"===> manual index mode activated"});
        }
        return (T)interceptorChain.pluginAll(t);
    }

    public Class<?> getObjectType() {
        return this.mapperInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterceptorChain initInterceptorChain() {
        InterceptorChainHolder interceptorChainHolder = InterceptorChainHolder.getInstance();
        InterceptorChain interceptorChain = interceptorChainHolder.getInterceptorChain();
        if (interceptorChain == null) {
            MapperFactoryBean mapperFactoryBean = this;
            synchronized (mapperFactoryBean) {
                interceptorChainHolder.initInterceptorChain();
                Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(Intercepts.class);
                beansWithAnnotation.forEach((key, val) -> {
                    if (val instanceof Interceptor) {
                        Interceptor interceptor = (Interceptor)val;
                        interceptorChainHolder.addInterceptor(interceptor);
                    }
                });
            }
        }
        return interceptorChainHolder.getInterceptorChain();
    }
}

