/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.annotation.PropIgnore;
import org.dromara.hutool.core.bean.BeanException;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.ModifierType;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.ReflectUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;

public class PropDesc {
    private Field field;
    private final String fieldName;
    protected Method getter;
    protected Method setter;

    public PropDesc(Field field, Method getter, Method setter) {
        this(FieldUtil.getFieldName(field), getter, setter);
        this.field = field;
    }

    public PropDesc(String fieldName, Method getter, Method setter) {
        this.fieldName = fieldName;
        this.getter = ReflectUtil.setAccessible(getter);
        this.setter = ReflectUtil.setAccessible(setter);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getRawFieldName() {
        return null == this.field ? null : this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return TypeUtil.getType(this.field);
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.field) {
            return TypeUtil.getClass(this.field);
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        if (null == this.getter && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForGet()) {
            return false;
        }
        return !this.isIgnoreGet();
    }

    public Object getValue(Object bean) {
        if (null != this.getter) {
            return MethodUtil.invoke(bean, this.getter, new Object[0]);
        }
        if (ModifierUtil.isPublic(this.field)) {
            return FieldUtil.getFieldValue(bean, this.field);
        }
        return null;
    }

    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.getValue(bean);
            }
            catch (Exception e) {
                if (ignoreError) break block3;
                throw new BeanException(e, "Get value of [{}] error!", this.getFieldName());
            }
        }
        if (null != result && null != targetType) {
            return ConvertUtil.convertWithCheck(targetType, result, null, ignoreError);
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        if (null == this.setter && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForSet()) {
            return false;
        }
        return !this.isIgnoreSet();
    }

    public PropDesc setValue(Object bean, Object value) {
        if (null != this.setter) {
            MethodUtil.invoke(bean, this.setter, value);
        } else if (ModifierUtil.isPublic(this.field)) {
            FieldUtil.setFieldValue(bean, this.field, value);
        }
        return this;
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        return this.setValue(bean, value, ignoreNull, ignoreError, true);
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError, boolean override) {
        block6: {
            Class<?> propClass;
            if (null == value && ignoreNull) {
                return this;
            }
            if (!override && null != this.getValue(bean)) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = ConvertUtil.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean, value);
                }
                catch (Exception e) {
                    if (ignoreError) break block6;
                    throw new BeanException(e, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    public String toString() {
        return "PropDesc{field=" + this.field + ", fieldName=" + this.fieldName + ", getter=" + this.getter + ", setter=" + this.setter + '}';
    }

    private Type findPropType(Method getter, Method setter) {
        Type type = null;
        if (null != getter) {
            type = TypeUtil.getReturnType(getter);
        }
        if (null == type && null != setter) {
            type = TypeUtil.getParamType(setter, 0);
        }
        return type;
    }

    private Class<?> findPropClass(Method getter, Method setter) {
        Class<?> type = null;
        if (null != getter) {
            type = TypeUtil.getReturnClass(getter);
        }
        if (null == type && null != setter) {
            type = TypeUtil.getFirstParamClass(setter);
        }
        return type;
    }

    private boolean isIgnoreSet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.setter, PropIgnore.class);
    }

    private boolean isIgnoreGet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.getter, PropIgnore.class);
    }

    private boolean isTransientForGet() {
        boolean isTransient = ModifierUtil.hasModifier(this.field, ModifierType.TRANSIENT);
        if (!isTransient && null != this.getter && !(isTransient = ModifierUtil.hasModifier(this.getter, ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(this.getter, Transient.class);
        }
        return isTransient;
    }

    private boolean isTransientForSet() {
        boolean isTransient = ModifierUtil.hasModifier(this.field, ModifierType.TRANSIENT);
        if (!isTransient && null != this.setter && !(isTransient = ModifierUtil.hasModifier(this.setter, ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(this.setter, Transient.class);
        }
        return isTransient;
    }
}

