/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.bean.path.AbstractBeanDesc;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.method.MethodNameUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.BooleanUtil;

public class StrictBeanDesc
extends AbstractBeanDesc {
    private static final long serialVersionUID = 1L;

    public StrictBeanDesc(Class<?> beanClass) {
        super(beanClass);
        this.init();
    }

    private void init() {
        Field[] fields;
        Class beanClass = this.beanClass;
        Map propMap = this.propMap;
        Method[] gettersAndSetters = MethodUtil.getPublicMethods(beanClass, MethodUtil::isGetterOrSetterIgnoreCase);
        for (Field field2 : fields = FieldUtil.getFields(beanClass, field -> !ModifierUtil.isStatic(field) && !FieldUtil.isOuterClassField(field))) {
            PropDesc prop = this.createProp(field2, gettersAndSetters);
            propMap.putIfAbsent(prop.getFieldName(), prop);
        }
    }

    private PropDesc createProp(Field field, Method[] methods) {
        PropDesc prop = this.findProp(field, methods, false);
        if (null == prop.getter || null == prop.setter) {
            PropDesc propIgnoreCase = this.findProp(field, methods, true);
            if (null == prop.getter) {
                prop.getter = propIgnoreCase.getter;
            }
            if (null == prop.setter) {
                prop.setter = propIgnoreCase.setter;
            }
        }
        return prop;
    }

    private PropDesc findProp(Field field, Method[] gettersOrSetters, boolean ignoreCase) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = BooleanUtil.isBoolean(fieldType);
        Method[] getterAndSetter = this.findGetterAndSetter(fieldName, fieldType, gettersOrSetters, ignoreCase);
        if (isBooleanField) {
            if (null == getterAndSetter[0]) {
                getterAndSetter[0] = StrictBeanDesc.getGetterForBoolean(gettersOrSetters, fieldName, ignoreCase);
            }
            if (null == getterAndSetter[1]) {
                getterAndSetter[1] = StrictBeanDesc.getSetterForBoolean(gettersOrSetters, fieldName, ignoreCase);
            }
        }
        return new PropDesc(field, getterAndSetter[0], getterAndSetter[1]);
    }

    private Method[] findGetterAndSetter(String fieldName, Class<?> fieldType, Method[] gettersOrSetters, boolean ignoreCase) {
        Method getter = null;
        Method setter = null;
        for (Method method : gettersOrSetters) {
            String methodName = method.getName();
            if (0 == method.getParameterCount()) {
                if (StrUtil.equals(methodName, MethodNameUtil.genGetter(fieldName), ignoreCase) && method.getReturnType().isAssignableFrom(fieldType)) {
                    getter = method;
                }
            } else if (StrUtil.equals(methodName, MethodNameUtil.genSetter(fieldName), ignoreCase) && fieldType.isAssignableFrom(method.getParameterTypes()[0])) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new Method[]{getter, setter};
    }

    private static Method getGetterForBoolean(Method[] gettersOrSetters, String fieldName, boolean ignoreCase) {
        return MethodUtil.getMethod(gettersOrSetters, m -> {
            if (0 != m.getParameterCount() || !BooleanUtil.isBoolean(m.getReturnType())) {
                return false;
            }
            if (StrUtil.startWith(fieldName, "is", ignoreCase) && StrUtil.equals(fieldName, m.getName(), ignoreCase)) {
                return true;
            }
            return StrUtil.equals(StrUtil.upperFirstAndAddPre(fieldName, "is"), m.getName(), ignoreCase);
        });
    }

    private static Method getSetterForBoolean(Method[] gettersOrSetters, String fieldName, boolean ignoreCase) {
        return MethodUtil.getMethod(gettersOrSetters, m -> {
            if (1 != m.getParameterCount() || !BooleanUtil.isBoolean(m.getParameterTypes()[0])) {
                return false;
            }
            if (StrUtil.startWith(fieldName, "is", ignoreCase)) {
                return StrUtil.equals("set" + StrUtil.removePrefix(fieldName, "is", ignoreCase), m.getName(), ignoreCase);
            }
            return false;
        });
    }
}

