/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.copier.AbsCopier;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.reflect.TypeUtil;

public class MapToMapCopier
extends AbsCopier<Map, Map> {
    private final Type targetType;

    public MapToMapCopier(Map source, Map target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public Map copy() {
        ((Map)this.source).forEach((sKey, sValue) -> {
            if (null == sKey) {
                return;
            }
            MutableEntry<Object, Object> entry = this.copyOptions.editField(sKey, sValue);
            if (null == entry) {
                return;
            }
            sKey = entry.getKey();
            if (null == sKey) {
                return;
            }
            sValue = entry.getValue();
            Object targetValue = ((Map)this.target).get(sKey);
            if (!this.copyOptions.override && null != targetValue) {
                return;
            }
            Type[] typeArguments = TypeUtil.getTypeArguments(this.targetType);
            if (null != typeArguments) {
                sValue = this.copyOptions.convertField(typeArguments[1], sValue);
            }
            if (this.copyOptions.ignoreNullValue && sValue == null) {
                return;
            }
            ((Map)this.target).put(sKey, sValue);
        });
        return (Map)this.target;
    }
}

