/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.path;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.path.node.NameNode;
import org.dromara.hutool.core.bean.path.node.Node;
import org.dromara.hutool.core.bean.path.node.NodeFactory;
import org.dromara.hutool.core.text.StrUtil;

public class BeanPath
implements Iterator<BeanPath> {
    private static final char[] EXP_CHARS = new char[]{'.', '[', ']'};
    private final Node node;
    private final String child;

    public static BeanPath of(String expression) {
        return new BeanPath(expression);
    }

    public BeanPath(String expression) {
        int length = expression.length();
        StringBuilder builder = new StringBuilder();
        boolean isNumStart = false;
        boolean isInWrap = false;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if ('\'' == c) {
                isInWrap = !isInWrap;
                continue;
            }
            if (!isInWrap && ArrayUtil.contains(EXP_CHARS, c)) {
                if (']' == c) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find ']' but no '[' !", expression, i));
                    }
                    isNumStart = false;
                } else {
                    if (isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, i));
                    }
                    if ('[' == c) {
                        isNumStart = true;
                    }
                }
                if (builder.length() <= 0) continue;
                this.node = NodeFactory.createNode(builder.toString());
                this.child = StrUtil.nullIfEmpty(expression.substring(c == '[' ? i : i + 1));
                return;
            }
            builder.append(c);
        }
        if (isNumStart) {
            throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, length - 1));
        }
        this.node = NodeFactory.createNode(builder.toString());
        this.child = null;
    }

    public Node getNode() {
        return this.node;
    }

    public String getChild() {
        return this.child;
    }

    @Override
    public boolean hasNext() {
        return null != this.child;
    }

    @Override
    public BeanPath next() {
        return new BeanPath(this.child);
    }

    public Object getValue(Object bean) {
        Object value = this.node.getValue(bean);
        if (null == value) {
            return null;
        }
        if (!this.hasNext()) {
            return value;
        }
        return this.next().getValue(value);
    }

    public Object setValue(Object bean, Object value) {
        Object newSubBean;
        if (!this.hasNext()) {
            return this.node.setValue(bean, value);
        }
        BeanPath childBeanPath = this.next();
        Cloneable subBean = this.node.getValue(bean);
        if (null == subBean) {
            subBean = BeanPath.isListNode(childBeanPath.node) ? new ArrayList() : new HashMap();
            this.node.setValue(bean, subBean);
            subBean = this.node.getValue(bean);
        }
        if ((newSubBean = childBeanPath.setValue(subBean, value)) != subBean) {
            this.node.setValue(bean, newSubBean);
        }
        return bean;
    }

    public String toString() {
        return "BeanPath{node=" + this.node + ", child='" + this.child + '\'' + '}';
    }

    private static boolean isListNode(Node node) {
        if (node instanceof NameNode) {
            return ((NameNode)node).isNumber();
        }
        return false;
    }
}

