/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.path.node;

import java.util.Collection;
import java.util.List;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.path.node.Node;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;

public class RangeNode
implements Node {
    private final int start;
    private final int end;
    private final int step;

    public RangeNode(String expression) {
        List<String> parts = SplitUtil.splitTrim(expression, ":");
        this.start = Integer.parseInt(parts.get(0));
        this.end = Integer.parseInt(parts.get(1));
        int step = 1;
        if (3 == parts.size()) {
            step = Integer.parseInt(parts.get(2));
        }
        this.step = step;
    }

    @Override
    public Object getValue(Object bean) {
        if (bean instanceof Collection) {
            return CollUtil.sub((Collection)bean, this.start, this.end, this.step);
        }
        if (ArrayUtil.isArray(bean)) {
            return ArrayUtil.sub(bean, this.start, this.end, this.step);
        }
        throw new UnsupportedOperationException("Can not get range value for: " + bean.getClass());
    }

    @Override
    public Object setValue(Object bean, Object value) {
        throw new UnsupportedOperationException("Can not set value with step name.");
    }

    public String toString() {
        return StrUtil.format("[{}:{}:{}]", this.start, this.end, this.step);
    }
}

