/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.CharUtil;

public abstract class AbstractConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (null == value) {
            return null;
        }
        if (TypeUtil.isUnknown(targetType)) {
            throw new ConvertException("Unsupported convert to unKnown type: {}", targetType);
        }
        Class<?> targetClass = TypeUtil.getClass(targetType);
        if (null == targetClass) {
            throw new ConvertException("Target type [{}] is not a class!", targetType);
        }
        if (targetClass.isInstance(value)) {
            return value;
        }
        return this.convertInternal(targetClass, value);
    }

    protected abstract Object convertInternal(Class<?> var1, Object var2);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayUtil.isArray(value)) {
            return ArrayUtil.toString(value);
        }
        if (CharUtil.isChar(value)) {
            return CharUtil.toString(((Character)value).charValue());
        }
        return value.toString();
    }
}

