/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.StreamProgress;
import org.dromara.hutool.core.io.copy.ChannelCopier;
import org.dromara.hutool.core.io.copy.FileChannelCopier;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class NioUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return NioUtil.copyByNIO(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(in, "InputStream channel is null!", new Object[0]);
        Assert.notNull(out, "OutputStream channel is null!", new Object[0]);
        long copySize = NioUtil.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, count, streamProgress);
        IoUtil.flush(out);
        return copySize;
    }

    public static long copy(FileChannel in, FileChannel out) throws IORuntimeException {
        Assert.notNull(in, "In channel is null!", new Object[0]);
        Assert.notNull(out, "Out channel is null!", new Object[0]);
        return FileChannelCopier.of().copy(in, out);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws IORuntimeException {
        return NioUtil.copy(in, out, 8192);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws IORuntimeException {
        return NioUtil.copy(in, out, bufferSize, -1L, null);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, long totalCount, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(in, "In channel is null!", new Object[0]);
        Assert.notNull(out, "Out channel is null!", new Object[0]);
        return new ChannelCopier(bufferSize, totalCount, streamProgress).copy(in, out);
    }

    public static String read(ReadableByteChannel channel, Charset charset) throws IORuntimeException {
        FastByteArrayOutputStream out = NioUtil.read(channel);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(ReadableByteChannel channel) throws IORuntimeException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        NioUtil.copy(channel, Channels.newChannel(out));
        return out;
    }

    public static String readUtf8(FileChannel fileChannel) throws IORuntimeException {
        return NioUtil.read(fileChannel, CharsetUtil.UTF_8);
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IORuntimeException {
        MappedByteBuffer buffer;
        try {
            buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return StrUtil.str(buffer, charset);
    }
}

