/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.checksum;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.EmptyOutputStream;
import org.dromara.hutool.core.lang.Assert;

public class ChecksumUtil {
    public static long checksumCRC32(File file) throws IORuntimeException {
        return ChecksumUtil.checksum(file, (Checksum)new CRC32()).getValue();
    }

    public static long checksumCRC32(InputStream in) throws IORuntimeException {
        return ChecksumUtil.checksum(in, (Checksum)new CRC32()).getValue();
    }

    public static Checksum checksum(File file, Checksum checksum) throws IORuntimeException {
        Assert.notNull(file, "File is null !", new Object[0]);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try {
            return ChecksumUtil.checksum(Files.newInputStream(file.toPath(), new OpenOption[0]), checksum);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Checksum checksum(InputStream in, Checksum checksum) throws IORuntimeException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        if (null == checksum) {
            checksum = new CRC32();
        }
        try {
            in = new CheckedInputStream(in, checksum);
            IoUtil.copy(in, EmptyOutputStream.INSTANCE);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        return checksum;
    }

    public static long checksumValue(InputStream in, Checksum checksum) {
        return ChecksumUtil.checksum(in, checksum).getValue();
    }
}

