/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.watch;

import java.io.Closeable;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.file.PathUtil;
import org.dromara.hutool.core.io.watch.WatchException;
import org.dromara.hutool.core.io.watch.WatchServiceWrapper;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.text.StrUtil;

public class WatchMonitor
extends Thread
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final WatchServiceWrapper watchService;
    private Path dir;
    private Path file;
    private int maxDepth;
    private Watcher watcher;

    public WatchMonitor(Path dir, WatchEvent.Kind<?> ... events) {
        this(dir, 0, events);
    }

    public WatchMonitor(Path dir, int maxDepth, WatchEvent.Kind<?> ... events) {
        this.watchService = WatchServiceWrapper.of(events);
        this.dir = dir;
        this.maxDepth = maxDepth;
        this.init();
    }

    public WatchMonitor setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        this.watch(this.watcher);
    }

    public void watch(Watcher watcher) throws WatchException {
        if (this.watchService.isClosed()) {
            throw new WatchException("Watch Monitor is closed !");
        }
        this.registerPath();
        while (!this.watchService.isClosed()) {
            this.doTakeAndWatch(watcher);
        }
    }

    public WatchMonitor setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @Override
    public void close() {
        this.watchService.close();
    }

    private void init() throws WatchException {
        if (!PathUtil.exists(this.dir, false)) {
            String lastPathEleStr;
            Path lastPathEle = FileUtil.getLastPathEle(this.dir);
            if (null != lastPathEle && StrUtil.contains((CharSequence)(lastPathEleStr = lastPathEle.toString()), '.') && !StrUtil.endWithIgnoreCase(lastPathEleStr, ".d")) {
                this.file = this.dir;
                this.dir = this.file.getParent();
            }
            PathUtil.mkdir(this.dir);
        } else if (PathUtil.isFile(this.dir, false)) {
            this.file = this.dir;
            this.dir = this.file.getParent();
        }
    }

    private void doTakeAndWatch(Watcher watcher) {
        this.watchService.watch(watcher, watchEvent -> null == this.file || this.file.endsWith(watchEvent.context().toString()));
    }

    private void registerPath() {
        this.watchService.registerPath(this.dir, null != this.file ? 0 : this.maxDepth);
    }
}

