/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.page;

import org.dromara.hutool.core.lang.page.PageInfo;

public class NavigatePageInfo
extends PageInfo {
    private final int navigatePageCount;
    private int[] navigatePageNumbers;

    public NavigatePageInfo(int total, int pageSize, int navigatePageCount) {
        super(total, pageSize);
        this.navigatePageCount = navigatePageCount;
        this.calcNavigatePageNumbers();
    }

    public int[] getNavigatePageNumbers() {
        return this.navigatePageNumbers;
    }

    @Override
    public NavigatePageInfo setFirstPageNo(int firstPageNo) {
        super.setFirstPageNo(firstPageNo);
        return this;
    }

    @Override
    public NavigatePageInfo setPageNo(int pageNo) {
        super.setPageNo(pageNo);
        this.calcNavigatePageNumbers();
        return this;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        if (!this.isFirstPage()) {
            str.append("<< ");
        }
        if (this.navigatePageNumbers.length > 0) {
            str.append(this.wrapForDisplay(this.navigatePageNumbers[0]));
        }
        for (int i = 1; i < this.navigatePageNumbers.length; ++i) {
            str.append(" ").append(this.wrapForDisplay(this.navigatePageNumbers[i]));
        }
        if (!this.isLastPage()) {
            str.append(" >>");
        }
        return str.toString();
    }

    private String wrapForDisplay(int pageNumber) {
        if (this.pageNo == pageNumber) {
            return "[" + pageNumber + "]";
        }
        return String.valueOf(pageNumber);
    }

    private void calcNavigatePageNumbers() {
        if (this.pageCount <= this.navigatePageCount) {
            this.navigatePageNumbers = new int[this.pageCount];
            for (int i = 0; i < this.pageCount; ++i) {
                this.navigatePageNumbers[i] = i + 1;
            }
        } else {
            this.navigatePageNumbers = new int[this.navigatePageCount];
            int startNum = this.pageNo - this.navigatePageCount / 2;
            int endNum = this.pageNo + this.navigatePageCount / 2;
            if (startNum < 1) {
                startNum = 1;
                for (int i = 0; i < this.navigatePageCount; ++i) {
                    this.navigatePageNumbers[i] = startNum++;
                }
            } else if (endNum > this.pageCount) {
                endNum = this.pageCount;
                for (int i = this.navigatePageCount - 1; i >= 0; --i) {
                    this.navigatePageNumbers[i] = endNum--;
                }
            } else {
                for (int i = 0; i < this.navigatePageCount; ++i) {
                    this.navigatePageNumbers[i] = startNum++;
                }
            }
        }
    }
}

