/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.ref;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.dromara.hutool.core.lang.ref.Ref;
import org.dromara.hutool.core.lang.ref.ReferenceType;
import org.dromara.hutool.core.util.ObjUtil;

public class ReferenceUtil {
    public static <T> Reference<T> of(ReferenceType type, T referent) {
        return ReferenceUtil.of(type, referent, null);
    }

    public static <T> Reference<T> of(ReferenceType type, T referent, ReferenceQueue<T> queue) {
        switch (type) {
            case SOFT: {
                return new SoftReference<T>(referent, queue);
            }
            case WEAK: {
                return new WeakReference<T>(referent, queue);
            }
            case PHANTOM: {
                return new PhantomReference<T>(referent, queue);
            }
        }
        return null;
    }

    public static <T> T get(Reference<T> obj) {
        return (T)ObjUtil.apply(obj, Reference::get);
    }

    public static <T> T get(Ref<T> obj) {
        return (T)ObjUtil.apply(obj, Ref::get);
    }
}

