/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.selector;

import java.io.Serializable;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.selector.Selector;
import org.dromara.hutool.core.lang.selector.WeightObj;

public class WeightRandomSelector<T>
implements Selector<T>,
Serializable {
    private static final long serialVersionUID = -8244697995702786499L;
    private final TreeMap<Integer, T> weightMap = new TreeMap();

    public static <T> WeightRandomSelector<T> of() {
        return new WeightRandomSelector<T>();
    }

    public WeightRandomSelector() {
    }

    public WeightRandomSelector(WeightObj<T> weightObj) {
        this();
        if (null != weightObj) {
            this.add(weightObj);
        }
    }

    public WeightRandomSelector(Iterable<WeightObj<T>> weightObjs) {
        this();
        if (CollUtil.isNotEmpty(weightObjs)) {
            for (WeightObj<T> weightObj : weightObjs) {
                this.add(weightObj);
            }
        }
    }

    public WeightRandomSelector(WeightObj<T>[] weightObjs) {
        this();
        for (WeightObj<T> weightObj : weightObjs) {
            this.add(weightObj);
        }
    }

    public WeightRandomSelector<T> add(T obj, int weight) {
        return this.add(new WeightObj<T>(obj, weight));
    }

    public WeightRandomSelector<T> add(WeightObj<T> weightObj) {
        int weight;
        if (null != weightObj && (weight = weightObj.getWeight()) > 0) {
            int lastWeight = this.weightMap.isEmpty() ? 0 : this.weightMap.lastKey();
            this.weightMap.put(weight + lastWeight, weightObj.getObj());
        }
        return this;
    }

    public WeightRandomSelector<T> clear() {
        if (null != this.weightMap) {
            this.weightMap.clear();
        }
        return this;
    }

    @Override
    public T select() {
        int randomWeight = (int)((double)this.weightMap.lastKey().intValue() * Math.random());
        NavigableMap<Integer, T> tailMap = this.weightMap.tailMap(randomWeight, false);
        return this.weightMap.get(tailMap.firstKey());
    }
}

